/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces.rules;

import java.util.List;
import java.util.logging.Logger;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.interfaces.EquivalenceChecker;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceFactory;
import org.pi4soa.cdl.interfaces.RoleTypeDefinition;
import org.pi4soa.cdl.interfaces.rules.InterfaceValidationHelper;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.InteractionUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ComponentValidationRule;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.xml.XMLUtils;

public class InteractionRule
implements ComponentValidationRule {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.interfaces.rules");
    private List m_existingIntfDefns = null;

    public InteractionRule(ValidationContext context, List existingIDefs) {
        this.m_existingIntfDefns = existingIDefs;
    }

    public boolean isRuleRelevant(Object component) {
        return component instanceof Interaction;
    }

    public void validate(Object component, ValidationContext context, ModelListener listener) {
        Interaction interaction = (Interaction)component;
        InterfaceValidationHelper ivh = null;
        if (context.getRuleSetProperties() != null && (ivh = (InterfaceValidationHelper)context.getRuleSetProperties().get("interfaceValidationHelper")) == null) {
            logger.severe("Interface validation helper not found");
        }
        String intfName = null;
        String intfNamespace = null;
        String intf = InteractionUtil.getInterface(interaction);
        if (intf != null) {
            intfName = XMLUtils.getLocalname((String)intf);
            intfNamespace = CDLTypeUtil.getNamespace(intf, interaction);
        }
        InterfaceDefinition existingIDefn = null;
        if (this.m_existingIntfDefns != null && intfName != null && intfNamespace != null) {
            int i = 0;
            while (existingIDefn == null && i < this.m_existingIntfDefns.size()) {
                InterfaceDefinition idef = (InterfaceDefinition)this.m_existingIntfDefns.get(i);
                if (idef.getInterfaceName().equals(intfName) && idef.getNamespace().equals(intfNamespace)) {
                    existingIDefn = idef;
                }
                ++i;
            }
        }
        if (existingIDefn != null && ivh != null) {
            InterfaceDefinition currentIDefn = null;
            RoleType roleType = interaction.getToRoleType();
            RoleTypeDefinition rtdef = ivh.getRoleTypeDefinition(roleType.getName());
            if (rtdef != null) {
                currentIDefn = rtdef.getInterface(intfNamespace, intfName);
            }
            if (currentIDefn != null) {
                EquivalenceChecker checker = InterfaceFactory.getEquivalenceChecker();
                String mesg = checker.checkEquivalence(interaction.getOperation(), currentIDefn, existingIDefn);
                if (mesg != null) {
                    listener.report((Object)interaction, mesg, 1);
                }
            } else {
                logger.severe("Could not find current interface definition for equivalence check");
            }
        }
    }
}

