/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces.rules;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDeriver;
import org.pi4soa.cdl.interfaces.InterfaceFactory;
import org.pi4soa.cdl.interfaces.InterfaceIntrospector;
import org.pi4soa.cdl.interfaces.RoleTypeDefinition;
import org.pi4soa.cdl.interfaces.rules.InteractionRule;
import org.pi4soa.cdl.interfaces.rules.InterfaceValidationHelper;
import org.pi4soa.cdl.validation.CDLComponentValidationVisitor;
import org.pi4soa.common.model.Model;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.resource.ArtifactManager;
import org.pi4soa.common.resource.FileSystemArtifactManager;
import org.pi4soa.common.resource.ResourceProperties;
import org.pi4soa.common.validation.AbstractValidationRuleSet;
import org.pi4soa.common.validation.ComponentValidationRule;
import org.pi4soa.common.validation.ComponentValidationRuleRegistry;
import org.pi4soa.common.validation.DefaultComponentValidationRuleRegistry;
import org.pi4soa.common.validation.ValidationContext;

public class InterfaceValidationRuleSet
extends AbstractValidationRuleSet {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.interfaces.rules");
    public static final String INTERFACE_VALIDATION_HELPER = "interfaceValidationHelper";
    public static final String INTERFACE_VALIDATION_INIT_ERROR = "interfaceValidationInitError";
    private static final String DESCRIPTIVE_NAME = "Interfaces";

    public InterfaceValidationRuleSet() {
        super("org.pi4soa.cdl.interfaces", DESCRIPTIVE_NAME, false, true);
    }

    public boolean isRuleSetRelevant(Model model) {
        return model instanceof Package;
    }

    protected void initializeContext(ValidationContext context, Model model) {
        super.initializeContext(context, model);
        if (context.getRuleSetProperties() != null && model instanceof Package) {
            InterfaceDeriver deriver = InterfaceFactory.getInterfaceDeriver();
            RoleTypeDefinition[] rtdefns = null;
            try {
                rtdefns = deriver.getRoleTypeDefinitions((Package)model);
                InterfaceValidationHelper ivh = new InterfaceValidationHelper();
                ivh.setRoleTypeDefinitions(rtdefns);
                context.getRuleSetProperties().put(INTERFACE_VALIDATION_HELPER, ivh);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    context.getRuleSetProperties().put(INTERFACE_VALIDATION_INIT_ERROR, e.getMessage());
                }
                logger.severe("Failed to initialize role type definitions: " + e);
            }
        }
    }

    protected void validateModel(Model model, ValidationContext context, ModelListener listener) {
        Package pack = null;
        InterfaceValidationHelper ivh = null;
        if (model instanceof Package) {
            pack = (Package)model;
        }
        if (context.getRuleSetProperties() != null && (ivh = (InterfaceValidationHelper)context.getRuleSetProperties().get(INTERFACE_VALIDATION_HELPER)) == null) {
            logger.severe("Interface validation helper not found");
        }
        if (pack != null && pack.getTypeDefinitions() != null && ivh != null) {
            ArtifactManager artifacts = this.getArtifactManager(context.getResourceProperties());
            Vector existing = new Vector();
            for (RoleType roleType : pack.getTypeDefinitions().getRoleTypes()) {
                RoleTypeDefinition rtdef = ivh.getRoleTypeDefinition(roleType.getName());
                if (rtdef == null) continue;
                this.buildExistingInterfaceDefinitions(pack, rtdef, artifacts, existing);
            }
            if (existing.size() > 0) {
                DefaultComponentValidationRuleRegistry registry = new DefaultComponentValidationRuleRegistry();
                InteractionRule ir = new InteractionRule(context, existing);
                registry.registerRule((ComponentValidationRule)ir);
                CDLComponentValidationVisitor visitor = new CDLComponentValidationVisitor((ComponentValidationRuleRegistry)registry, context, listener);
                pack.visit(visitor);
            }
        }
        if (pack != null && context.getRuleSetProperties() != null && context.getRuleSetProperties().containsKey(INTERFACE_VALIDATION_INIT_ERROR)) {
            listener.report((Object)pack, (String)context.getRuleSetProperties().get(INTERFACE_VALIDATION_INIT_ERROR), 2);
        }
    }

    protected void buildExistingInterfaceDefinitions(Package cdlpack, RoleTypeDefinition rtdef, ArtifactManager artifacts, Vector existing) {
        InterfaceIntrospector[] introspectors = InterfaceFactory.getIntrospectors();
        Iterator iter = rtdef.getInterfaces().iterator();
        while (introspectors != null && introspectors.length > 0 && iter.hasNext()) {
            InterfaceDefinition idef = (InterfaceDefinition)iter.next();
            int i = 0;
            while (i < introspectors.length) {
                InterfaceDefinition introIDef = introspectors[i].getInterfaceDefinition(cdlpack, artifacts, idef.getNamespace(), idef.getInterfaceName());
                if (introIDef != null) {
                    existing.add(introIDef);
                }
                ++i;
            }
        }
    }

    protected ArtifactManager getArtifactManager(ResourceProperties props) {
        int index;
        FileSystemArtifactManager ret = null;
        String folder = props.getProperty(null, "resourceLocation");
        if (folder != null && (index = folder.lastIndexOf(47)) != -1) {
            folder = folder.substring(0, index);
            ret = new FileSystemArtifactManager(folder);
        }
        return ret;
    }
}

