/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.projection;

import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.projection.DefaultVisitorProxy;
import org.pi4soa.cdl.projection.ProjectionRegistry;

public class CDLParticipantProjection
extends DefaultVisitorProxy {
    private RoleType[] m_roleTypes = null;

    public CDLParticipantProjection(CDLVisitor visitor, ParticipantType participantType) {
        super(visitor);
        EList<RoleType> roles = participantType.getRoleTypes();
        this.m_roleTypes = new RoleType[roles.size()];
        int i = 0;
        while (i < roles.size()) {
            this.m_roleTypes[i] = (RoleType)roles.get(i);
            ++i;
        }
    }

    protected boolean evaluate(CDLType cdltype) {
        boolean ret = false;
        ret = cdltype.isRelevantToRoleTypes(this.m_roleTypes);
        return ret;
    }

    protected CDLType getProxy(CDLType cdlType) {
        return ProjectionRegistry.getProjectionProxy(cdlType, this.m_roleTypes);
    }

    protected RoleType[] getProjectedRoleTypes() {
        return this.m_roleTypes;
    }
}

