/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.projection;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.projection.CDLTypeProxy;
import org.pi4soa.cdl.projection.NoActionProxy;
import org.pi4soa.cdl.projection.ProjectionRegistry;

public class CDLTypeRoleProjection
extends EObjectImpl
implements CDLType,
CDLTypeProxy {
    private CDLType m_cdlType = null;
    private RoleType[] m_roleTypes = null;

    public CDLTypeRoleProjection(CDLType cdlType, RoleType[] roleTypes) {
        this.m_cdlType = cdlType;
        this.m_roleTypes = roleTypes;
    }

    protected boolean isRoleRelevantToProjection(String roleTypeName) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < this.m_roleTypes.length) {
            ret = this.m_roleTypes[i].getName().equals(roleTypeName);
            ++i;
        }
        return ret;
    }

    protected boolean isRoleListRelevantToProjection(RoleType[] roleTypes) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < roleTypes.length) {
            ret = this.isRoleRelevantToProjection(roleTypes[i].getName());
            ++i;
        }
        return ret;
    }

    protected EList emptyList() {
        return new BasicEList();
    }

    protected EList newList() {
        return new BasicEList();
    }

    public String getDescription() {
        return this.getCDLType().getDescription();
    }

    public void setDescription(String value) {
    }

    public EList getSemanticAnnotations() {
        return this.getCDLType().getSemanticAnnotations();
    }

    public String getName() {
        return this.getCDLType().getName();
    }

    public Package getPackage() {
        return (Package)this.getProxy(this.getCDLType().getPackage());
    }

    public Choreography getEnclosingChoreography() {
        return (Choreography)this.getProxy(this.getCDLType().getEnclosingChoreography());
    }

    public RoleType[] getRoleTypesForContext() {
        return this.getCDLType().getRoleTypesForContext();
    }

    public boolean isRoleTypeAssociatedWithContext(String roleType) {
        return this.getCDLType().isRoleTypeAssociatedWithContext(roleType);
    }

    public boolean isRelevantToRoleType(RoleType roleType) {
        return this.getCDLType().isRelevantToRoleType(roleType);
    }

    public boolean isRelevantToRoleTypes(RoleType[] roleTypes) {
        return this.getCDLType().isRelevantToRoleTypes(roleTypes);
    }

    public boolean isGroupingConstruct() {
        return this.getCDLType().isGroupingConstruct();
    }

    public boolean isConditionalGroupingConstruct() {
        return this.getCDLType().isConditionalGroupingConstruct();
    }

    public boolean isSequentialGroupingConstruct() {
        return this.getCDLType().isSequentialGroupingConstruct();
    }

    public void visit(CDLVisitor visitor) {
    }

    public CDLType getParent() {
        return this.getProxy(this.getCDLType().getParent());
    }

    public int hashCode() {
        int ret = super.hashCode();
        if (this.getCDLType() != null) {
            ret = this.getCDLType().hashCode();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (!ret && this.getCDLType() != null) {
            if (obj instanceof CDLTypeRoleProjection) {
                CDLTypeRoleProjection rp = (CDLTypeRoleProjection)obj;
                if (rp.getCDLType() != null) {
                    ret = this.getCDLType().equals(rp.getCDLType());
                }
            } else if (obj instanceof CDLType) {
                ret = this.getCDLType().equals((CDLType)obj);
            }
        }
        return ret;
    }

    public CDLType getCDLType() {
        return this.m_cdlType;
    }

    public Object getModelObject() {
        return this.getCDLType();
    }

    public RoleType[] getProjectionRoleTypes() {
        return this.m_roleTypes;
    }

    public EList filterList(List cdltypes) {
        EList ret = this.newList();
        for (Object obj : cdltypes) {
            if (obj instanceof CDLType) {
                CDLType cdltype = (CDLType)obj;
                if (!cdltype.isRelevantToRoleTypes(this.m_roleTypes)) continue;
                ret.add((Object)this.getProxy(cdltype));
                continue;
            }
            ret.add(obj);
        }
        return ret;
    }

    protected EList filterActivityList(EList cdltypes) {
        EList ret = this.filterList((List)cdltypes);
        if (ret.size() == 0) {
            ret.add((Object)new NoActionProxy(null, this.getCDLType(), this.getProjectionRoleTypes()));
        }
        return ret;
    }

    protected CDLType getProxy(CDLType type) {
        CDLType ret = type;
        if (type != null) {
            ret = ProjectionRegistry.getProjectionProxy(type, this.getProjectionRoleTypes());
        }
        return ret;
    }

    public EList eContents() {
        return this.filterList((List)this.m_cdlType.eContents());
    }
}

