/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.projection;

import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.Assign;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.Choice;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Conditional;
import org.pi4soa.cdl.ExceptionHandler;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.Finalize;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.NoAction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Parallel;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Sequence;
import org.pi4soa.cdl.SilentAction;
import org.pi4soa.cdl.When;
import org.pi4soa.cdl.While;
import org.pi4soa.cdl.projection.NoActionProxy;
import org.pi4soa.cdl.util.ActivityUtil;
import org.pi4soa.cdl.util.ChoiceUtil;

public abstract class DefaultVisitorProxy
implements CDLVisitor {
    private CDLVisitor m_visitor = null;

    public DefaultVisitorProxy(CDLVisitor visitor) {
        this.m_visitor = visitor;
    }

    public void assign(Assign assign) {
        if (this.evaluate(assign)) {
            this.m_visitor.assign((Assign)this.getProxy(assign));
        }
    }

    public void choiceStart(Choice choice) {
        if (this.evaluate(choice)) {
            this.m_visitor.choiceStart((Choice)this.getProxy(choice));
        }
    }

    public void choiceEnd(Choice choice) {
        if (this.evaluate(choice)) {
            Choice proxy = (Choice)this.getProxy(choice);
            if (ChoiceUtil.isChoiceOptional(choice, this.getProjectedRoleTypes()) && ActivityUtil.isActivityInScopeOfParticipant((Activity)choice, this.getProjectedRoleTypes())) {
                this.m_visitor.noAction(new NoActionProxy(ChoiceUtil.getOptionalPathName(choice), choice, this.getProjectedRoleTypes()));
            }
            this.m_visitor.choiceEnd(proxy);
        }
    }

    public void choreographyStart(Choreography choreography) {
        if (this.evaluate(choreography)) {
            this.m_visitor.choreographyStart((Choreography)this.getProxy(choreography));
        }
    }

    public void choreographyEnd(Choreography choreography) {
        if (this.evaluate(choreography)) {
            this.m_visitor.choreographyEnd((Choreography)this.getProxy(choreography));
        }
    }

    public void conditionalStart(Conditional conditional) {
        if (this.evaluate(conditional)) {
            this.m_visitor.conditionalStart((Conditional)this.getProxy(conditional));
        }
    }

    public void conditionalEnd(Conditional conditional) {
        if (this.evaluate(conditional)) {
            this.m_visitor.conditionalEnd((Conditional)this.getProxy(conditional));
        }
    }

    public void exceptionHandlerStart(ExceptionHandler handler) {
        if (this.evaluate(handler)) {
            this.m_visitor.exceptionHandlerStart((ExceptionHandler)this.getProxy(handler));
        }
    }

    public void exceptionHandlerEnd(ExceptionHandler handler) {
        if (this.evaluate(handler)) {
            this.m_visitor.exceptionHandlerEnd((ExceptionHandler)this.getProxy(handler));
        }
    }

    public void exceptionWorkUnitStart(ExceptionWorkUnit workunit) {
        if (this.evaluate(workunit)) {
            this.m_visitor.exceptionWorkUnitStart((ExceptionWorkUnit)this.getProxy(workunit));
        }
    }

    public void exceptionWorkUnitEnd(ExceptionWorkUnit workunit) {
        if (this.evaluate(workunit)) {
            this.m_visitor.exceptionWorkUnitEnd((ExceptionWorkUnit)this.getProxy(workunit));
        }
    }

    public void finalizerStart(FinalizerHandler finalizer) {
        if (this.evaluate(finalizer)) {
            this.m_visitor.finalizerStart((FinalizerHandler)this.getProxy(finalizer));
        }
    }

    public void finalizerEnd(FinalizerHandler finalizer) {
        if (this.evaluate(finalizer)) {
            this.m_visitor.finalizerEnd((FinalizerHandler)this.getProxy(finalizer));
        }
    }

    public void finalize(Finalize finalize) {
        if (this.evaluate(finalize)) {
            this.m_visitor.finalize((Finalize)this.getProxy(finalize));
        }
    }

    public void interaction(Interaction interaction) {
        if (this.evaluate(interaction)) {
            this.m_visitor.interaction((Interaction)this.getProxy(interaction));
        }
    }

    public void noAction(NoAction noAction) {
        if (this.evaluate(noAction)) {
            this.m_visitor.noAction((NoAction)this.getProxy(noAction));
        }
    }

    public void packageStart(Package pack) {
        this.m_visitor.packageStart((Package)this.getProxy(pack));
    }

    public void packageEnd(Package pack) {
        this.m_visitor.packageEnd((Package)this.getProxy(pack));
    }

    public void parallelStart(Parallel parallel) {
        if (this.evaluate(parallel)) {
            this.m_visitor.parallelStart((Parallel)this.getProxy(parallel));
        }
    }

    public void parallelEnd(Parallel parallel) {
        if (this.evaluate(parallel)) {
            this.m_visitor.parallelEnd((Parallel)this.getProxy(parallel));
        }
    }

    public void perform(Perform perform) {
        if (this.evaluate(perform)) {
            this.m_visitor.perform((Perform)this.getProxy(perform));
        }
    }

    public void sequenceStart(Sequence sequence) {
        if (this.evaluate(sequence)) {
            this.m_visitor.sequenceStart((Sequence)this.getProxy(sequence));
        }
    }

    public void sequenceEnd(Sequence sequence) {
        if (this.evaluate(sequence)) {
            this.m_visitor.sequenceEnd((Sequence)this.getProxy(sequence));
        }
    }

    public void silentAction(SilentAction silentAction) {
        if (this.evaluate(silentAction)) {
            this.m_visitor.silentAction((SilentAction)this.getProxy(silentAction));
        }
    }

    public void whenStart(When when) {
        if (this.evaluate(when)) {
            this.m_visitor.whenStart((When)this.getProxy(when));
        }
    }

    public void whenEnd(When when) {
        if (this.evaluate(when)) {
            this.m_visitor.whenEnd((When)this.getProxy(when));
        }
    }

    public void whileStart(While whileElem) {
        if (this.evaluate(whileElem)) {
            this.m_visitor.whileStart((While)this.getProxy(whileElem));
        }
    }

    public void whileEnd(While whileElem) {
        if (this.evaluate(whileElem)) {
            this.m_visitor.whileEnd((While)this.getProxy(whileElem));
        }
    }

    protected abstract CDLType getProxy(CDLType var1);

    protected abstract boolean evaluate(CDLType var1);

    protected abstract RoleType[] getProjectedRoleTypes();
}

