/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.projection;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choice;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Conditional;
import org.pi4soa.cdl.ExceptionHandler;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Parallel;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Sequence;
import org.pi4soa.cdl.When;
import org.pi4soa.cdl.While;
import org.pi4soa.cdl.projection.ChoiceRoleProjection;
import org.pi4soa.cdl.projection.ChoreographyRoleProjection;
import org.pi4soa.cdl.projection.ConditionalRoleProjection;
import org.pi4soa.cdl.projection.ExceptionHandlerRoleProjection;
import org.pi4soa.cdl.projection.ExceptionWorkUnitRoleProjection;
import org.pi4soa.cdl.projection.FinalizerHandlerRoleProjection;
import org.pi4soa.cdl.projection.InteractionRoleProjection;
import org.pi4soa.cdl.projection.PackageRoleProjection;
import org.pi4soa.cdl.projection.ParallelRoleProjection;
import org.pi4soa.cdl.projection.PerformRoleProjection;
import org.pi4soa.cdl.projection.SequenceRoleProjection;
import org.pi4soa.cdl.projection.WhenRoleProjection;
import org.pi4soa.cdl.projection.WhileRoleProjection;

public class ProjectionRegistry {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.projection");
    private static Hashtable m_proxyClasses = new Hashtable();

    static {
        ProjectionRegistry.registerProjectionProxy(Choice.class.getName(), ChoiceRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Choreography.class.getName(), ChoreographyRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Conditional.class.getName(), ConditionalRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(ExceptionHandler.class.getName(), ExceptionHandlerRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(ExceptionWorkUnit.class.getName(), ExceptionWorkUnitRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(FinalizerHandler.class.getName(), FinalizerHandlerRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Interaction.class.getName(), InteractionRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Package.class.getName(), PackageRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Parallel.class.getName(), ParallelRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Perform.class.getName(), PerformRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(Sequence.class.getName(), SequenceRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(When.class.getName(), WhenRoleProjection.class);
        ProjectionRegistry.registerProjectionProxy(While.class.getName(), WhileRoleProjection.class);
    }

    public static CDLType getProjectionProxy(CDLType cdlType, RoleType[] roleTypes) {
        CDLType ret = cdlType;
        String type = cdlType.eClass().getInstanceClassName();
        Class proxyClass = ProjectionRegistry.getProxyClass(type);
        if (proxyClass != null) {
            try {
                Class<?> intf = Class.forName(type);
                Class[] argTypes = new Class[]{intf, RoleType[].class};
                Constructor con = proxyClass.getConstructor(argTypes);
                if (con == null) {
                    logger.severe("Could not find appropriate constructor on projection proxy class '" + proxyClass.getName() + "'");
                } else {
                    Object[] params = new Object[]{cdlType, roleTypes};
                    Object obj = con.newInstance(params);
                    if (obj instanceof CDLType) {
                        ret = (CDLType)obj;
                    } else {
                        logger.severe("Instantiated object is nota projection proxy: " + obj);
                    }
                }
            }
            catch (Exception e) {
                logger.severe("Failed to instantiate proxy class '" + proxyClass + "' for CDL type '" + type + "': " + e);
            }
        }
        return ret;
    }

    protected static Class getProxyClass(String type) {
        return (Class)m_proxyClasses.get(type);
    }

    public static void registerProjectionProxy(String type, Class proxyClass) {
        m_proxyClasses.put(type, proxyClass);
    }
}

