/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Parallel;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RoleType;

public class ActivityUtil {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.util");

    public static Activity getPrecedingActivity(Activity act) {
        Activity ret = null;
        if (act != null) {
            CDLType parent = act.getParent();
            if (parent != null && parent.isSequentialGroupingConstruct()) {
                int index = parent.eContents().indexOf((Object)act);
                while (ret == null && index > 0) {
                    Object obj = parent.eContents().get(--index);
                    if (!(obj instanceof Activity)) continue;
                    ret = (Activity)obj;
                }
            }
            if (ret == null && parent instanceof Activity) {
                ret = (Activity)parent;
            }
        }
        return ret;
    }

    public static List getSubsequentActivities(Activity act) {
        Vector ret = new Vector();
        if (act != null) {
            if (act.isGroupingConstruct()) {
                Activity next;
                Iterator iter = act.eContents().iterator();
                boolean f_end = false;
                while (!f_end && iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof Activity)) continue;
                    ret.add(obj);
                    if (!act.isSequentialGroupingConstruct()) continue;
                    f_end = true;
                }
                if (act.isConditionalGroupingConstruct() && (next = ActivityUtil.getNextActivityInParent(act)) != null && !ret.contains(next)) {
                    ret.add(next);
                }
            } else {
                Activity next = ActivityUtil.getNextActivityInParent(act);
                if (next != null) {
                    ret.add(next);
                }
            }
        }
        return ret;
    }

    protected static Activity getNextActivityInParent(CDLType act) {
        CDLType parent;
        Activity ret = null;
        if (act != null && (parent = act.getParent()) != null) {
            if (!parent.isSequentialGroupingConstruct()) {
                ret = ActivityUtil.getNextActivityInParent(parent);
            } else {
                int index = parent.eContents().indexOf((Object)act);
                ++index;
                while (ret == null && index < parent.eContents().size()) {
                    Object obj = parent.eContents().get(index);
                    if (obj instanceof Activity) {
                        ret = (Activity)obj;
                    }
                    ++index;
                }
                if (ret == null && parent instanceof Activity) {
                    ret = ActivityUtil.getNextActivityInParent(parent);
                }
            }
        }
        return ret;
    }

    public static boolean isActivityInScopeOfParticipant(Activity act, ParticipantType ptype) {
        boolean ret = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Checking if activity '" + act + "' is in scope of " + "participant '" + ptype + "'?");
        }
        Object[] roleTypes = new RoleType[ptype.getRoleTypes().size()];
        ptype.getRoleTypes().toArray(roleTypes);
        ret = ActivityUtil.isActivityInScopeOfParticipant(act, (RoleType[])roleTypes);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Is activity '" + act + "' in scope of " + "participant '" + ptype + "'? " + ret);
        }
        return ret;
    }

    public static boolean isActivityInScopeOfParticipant(Activity act, RoleType[] roleTypes) {
        int i;
        boolean ret = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Checking if activity '" + act + "' is in scope of " + "participant '" + roleTypes + "'?");
        }
        if (act != null) {
            ret = ActivityUtil.checkForMultipleParallelPaths(act, roleTypes);
        }
        Choreography choreo = act.getEnclosingChoreography();
        while (!ret && act != null) {
            CDLType parent = act.getParent();
            if ((act = ActivityUtil.getPrecedingActivity(act)) == parent) {
                ret = ActivityUtil.checkForMultipleParallelPaths(act, roleTypes);
                continue;
            }
            if (act == null) continue;
            i = 0;
            while (!ret && i < roleTypes.length) {
                RoleType rtype = roleTypes[i];
                if (act.isRelevantToRoleType(rtype)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Activity '" + act + "' is in scope due to being a " + "predecessor for role types '" + roleTypes + "'");
                    }
                    ret = true;
                }
                ++i;
            }
        }
        if (act == null && !ret && choreo != null) {
            List<Perform> performs = choreo.getPerformingActivities();
            i = 0;
            while (!ret && i < performs.size()) {
                ret = ActivityUtil.isActivityInScopeOfParticipant((Activity)performs.get(i), roleTypes);
                ++i;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Is activity '" + act + "' in scope of " + "role types '" + roleTypes + "'? " + ret);
        }
        return ret;
    }

    protected static boolean checkForMultipleParallelPaths(Activity act, RoleType[] roleTypes) {
        boolean ret = false;
        if (act instanceof Parallel) {
            int relevant = 0;
            for (Object obj : ((Parallel)act).getActivities()) {
                if (!(obj instanceof Activity)) continue;
                boolean f_found = false;
                int i = 0;
                while (!f_found && i < roleTypes.length) {
                    RoleType rtype = roleTypes[i];
                    if (((Activity)obj).isRelevantToRoleType(rtype)) {
                        f_found = true;
                        ++relevant;
                    }
                    ++i;
                }
            }
            if (relevant > 1) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Activity '" + act + "' is in scope due to multiple " + "paths associated with " + "role types '" + roleTypes + "'");
                }
                ret = true;
            }
        }
        return ret;
    }
}

