/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.logging.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.DataType;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.WorkUnit;
import org.pi4soa.cdl.projection.CDLTypeProxy;
import org.pi4soa.common.util.EMFUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Node;

public class CDLTypeUtil {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.util");

    public static boolean validNamespace(Node node) {
        boolean ret = false;
        if (node.getNamespaceURI() != null && (node.getNamespaceURI().equals("http://www.w3.org/2005/10/cdl") || node.getNamespaceURI().equals("http://www.pi4soa.org/cdl2"))) {
            ret = true;
        }
        return ret;
    }

    public static boolean isDuplicateCDLTypeWithAttribute(CDLType cdlType, String attributeName) {
        boolean ret = false;
        if (cdlType instanceof EObject) {
            CDLType eobj = cdlType;
            Package pack = cdlType.getPackage();
            EStructuralFeature feature = eobj.eClass().getEStructuralFeature(attributeName);
            Object val = null;
            if (feature != null) {
                val = eobj.eGet(feature);
            }
            if (pack instanceof EObject && val != null && (!(val instanceof String) || NamesUtil.isSet((String)((String)val)))) {
                TreeIterator iter = pack.eAllContents();
                while (!ret && iter.hasNext()) {
                    Object otherVal;
                    EObject cur = (EObject)iter.next();
                    if (eobj.eClass() != cur.eClass() || cur == eobj || !val.equals(otherVal = cur.eGet(feature))) continue;
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static InformationType getInformationType(DataType type) {
        ChannelType chanType;
        InformationType ret = null;
        if (type instanceof InformationType) {
            ret = (InformationType)type;
        } else if (type instanceof ChannelType && (chanType = (ChannelType)type).getReferenceToken() != null && chanType.getReferenceToken().getInformationType() != null) {
            ret = chanType.getReferenceToken().getInformationType();
        }
        logger.finer("Information type for '" + type + "' is " + ret);
        return ret;
    }

    public static String getRealInformationType(DataType type) {
        ChannelType chanType;
        String ret = null;
        if (type instanceof InformationType) {
            InformationType infoType = (InformationType)type;
            if (NamesUtil.isSet((String)infoType.getTypeName())) {
                ret = infoType.getTypeName();
            }
        } else if (type instanceof ChannelType && (chanType = (ChannelType)type).getReferenceToken() != null && chanType.getReferenceToken().getInformationType() != null) {
            ret = CDLTypeUtil.getRealInformationType(chanType.getReferenceToken().getInformationType());
        }
        logger.finer("Real information type for '" + type + "' is " + ret);
        return ret;
    }

    public static String getRealInformationElement(DataType type) {
        ChannelType chanType;
        String ret = null;
        if (type instanceof InformationType) {
            InformationType infoType = (InformationType)type;
            if (NamesUtil.isSet((String)infoType.getElementName())) {
                ret = infoType.getElementName();
            }
        } else if (type instanceof ChannelType && (chanType = (ChannelType)type).getReferenceToken() != null && chanType.getReferenceToken().getInformationType() != null) {
            ret = CDLTypeUtil.getRealInformationElement(chanType.getReferenceToken().getInformationType());
        }
        logger.finer("Real information element for '" + type + "' is " + ret);
        return ret;
    }

    public static String getNamespace(String qname, CDLType cdlType) {
        return CDLTypeUtil.getNamespace(qname, cdlType, false);
    }

    public static String getNamespace(String qname, CDLType cdlType, boolean defaultTns) {
        String ret = null;
        if (qname != null && cdlType != null && cdlType.getPackage() != null) {
            String def = null;
            if (defaultTns) {
                def = cdlType.getPackage().getTargetNamespace();
            }
            ret = XMLUtils.getNamespace((String)qname, (XMLPrefixResolver)CDLTypeUtil.getPrefixResolver(cdlType.getPackage()), (String)def);
        }
        return ret;
    }

    public static XMLPrefixResolver getPrefixResolver(Package pack) {
        return new CDLPrefixResolver(pack);
    }

    public static String getLocation(CDLType cdlType) {
        String ret = null;
        if (cdlType != null) {
            String parentLoc;
            ret = CDLTypeUtil.getElementName(cdlType);
            if (NamesUtil.isSet((String)cdlType.getName())) {
                ret = String.valueOf(ret) + "[@name=\"" + cdlType.getName() + "\"]";
            }
            if (cdlType.getParent() != null && !(cdlType.getParent() instanceof Package) && (parentLoc = CDLTypeUtil.getLocation(cdlType.getParent())) != null) {
                ret = String.valueOf(parentLoc) + "/" + ret;
            }
        }
        return ret;
    }

    protected static String getElementName(CDLType cdlType) {
        String ret = cdlType.eClass().getName();
        if (cdlType instanceof WorkUnit) {
            ret = "workunit";
        }
        ret = String.valueOf(Character.toLowerCase(ret.charAt(0))) + ret.substring(1);
        return ret;
    }

    public static String getURI(CDLType cdlType) {
        String ret = null;
        if (cdlType instanceof CDLTypeProxy) {
            cdlType = ((CDLTypeProxy)((Object)cdlType)).getCDLType();
        }
        if (cdlType instanceof EObject) {
            ret = EMFUtil.getURI((Object)cdlType);
        }
        return ret;
    }

    public static String getURIFragment(CDLType cdlType) {
        String ret = null;
        if (cdlType instanceof CDLTypeProxy) {
            cdlType = ((CDLTypeProxy)((Object)cdlType)).getCDLType();
        }
        if (cdlType instanceof EObject) {
            ret = EMFUtil.getURIFragment((Object)cdlType);
        }
        return ret;
    }

    public static CDLType getCDLType(CDLType base, String uriFragment) {
        Object component;
        CDLType ret = null;
        if (base != null && (component = EMFUtil.getComponent((Object)base, (String)uriFragment)) instanceof CDLType) {
            ret = (CDLType)component;
        }
        return ret;
    }

    static class CDLPrefixResolver
    implements XMLPrefixResolver {
        private Package m_package = null;

        public CDLPrefixResolver(Package pack) {
            this.m_package = pack;
        }

        public String getNamespace(String prefix) {
            return this.m_package.getNameSpaceURIForPrefix(prefix);
        }

        public String getPrefix(String namespace) {
            return this.m_package.getNameSpacePrefixForURI(namespace);
        }
    }
}

