/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xml.XMLUtils;

public class ChoreographyUtil {
    public static boolean isCyclic(Choreography choreo) {
        boolean ret = false;
        Vector trail = new Vector();
        ret = ChoreographyUtil.isRecursive(choreo, trail);
        return ret;
    }

    protected static boolean isRecursive(Choreography choreo, Vector trail) {
        boolean ret = false;
        if (trail.contains(choreo)) {
            ret = true;
        } else {
            trail.add(choreo);
            List<Perform> performs = choreo.getPerformingActivities();
            int i = 0;
            while (!ret && i < performs.size()) {
                Activity act = performs.get(i);
                ret = ChoreographyUtil.isRecursive(act.getEnclosingChoreography(), trail);
                ++i;
            }
            trail.remove(choreo);
        }
        return ret;
    }

    public static ExceptionWorkUnit getExceptionWorkUnit(String exceptionType, Choreography choreo) {
        ExceptionWorkUnit ret = null;
        if (choreo != null && choreo.getPackage() != null && choreo.getExceptionHandler() != null && exceptionType != null) {
            ExceptionWorkUnit defaultHandler = null;
            Iterator iter = choreo.getExceptionHandler().getExceptionWorkUnits().iterator();
            while (ret == null && iter.hasNext()) {
                ExceptionWorkUnit ewu = (ExceptionWorkUnit)iter.next();
                if (NamesUtil.isSet((String)ewu.getExceptionType())) {
                    String localname2;
                    String localname1 = XMLUtils.getLocalname((String)ewu.getExceptionType());
                    if (!localname1.equals(localname2 = XMLUtils.getLocalname((String)exceptionType))) continue;
                    XMLPrefixResolver resolver = CDLTypeUtil.getPrefixResolver(choreo.getPackage());
                    String ns1 = XMLUtils.getNamespace((String)ewu.getExceptionType(), (XMLPrefixResolver)resolver, (String)choreo.getPackage().getTargetNamespace());
                    String ns2 = XMLUtils.getNamespace((String)exceptionType, (XMLPrefixResolver)resolver, (String)choreo.getPackage().getTargetNamespace());
                    if (ns1 == null || ns2 == null || !ns1.equals(ns2)) continue;
                    ret = ewu;
                    continue;
                }
                defaultHandler = ewu;
            }
            if (ret == null) {
                ret = defaultHandler;
            }
        }
        return ret;
    }

    public static boolean isExceptionTypeHandled(String exceptionType, Choreography choreo) {
        boolean ret = false;
        if (ChoreographyUtil.getExceptionWorkUnit(exceptionType, choreo) != null) {
            ret = true;
        } else {
            List<Perform> performs = choreo.getPerformingActivities();
            if (performs.size() > 0 && !ChoreographyUtil.isCyclic(choreo)) {
                ret = true;
                int i = 0;
                while (ret && i < performs.size()) {
                    Perform perform = performs.get(i);
                    ret = ChoreographyUtil.isExceptionTypeHandled(exceptionType, perform.getEnclosingChoreography());
                    ++i;
                }
            }
        }
        return ret;
    }

    public static Collection getRelevantVariables(Choreography choreo, Collection col, boolean channelsOnly) {
        Vector<Variable> ret = new Vector<Variable>();
        for (Variable var : col) {
            if (var != null && (choreo != var.getEnclosingChoreography() || channelsOnly && !(var.getType() instanceof ChannelType))) continue;
            ret.add(var);
        }
        return ret;
    }

    public static Collection getRelevantFinalizers(Choreography choreo, Collection col) {
        Vector<FinalizerHandler> ret = new Vector<FinalizerHandler>();
        for (FinalizerHandler fin : col) {
            if (fin != null && choreo != fin.getEnclosingChoreography()) continue;
            ret.add(fin);
        }
        return ret;
    }

    public static Collection getRelevantCallableChoreographies(Activity activity, Collection col) {
        Vector<Choreography> ret = new Vector<Choreography>();
        for (Choreography choreo : col) {
            if (choreo != null && (choreo == activity.getEnclosingChoreography() || !(choreo.getParent() instanceof Package)) && choreo.getParent() != activity.getEnclosingChoreography()) continue;
            ret.add(choreo);
        }
        return ret;
    }
}

