/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.BindDetails;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.DefaultCDLVisitor;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.util.ActivityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionUtil {
    public static boolean isSameInteractionType(Interaction i1, Interaction i2) {
        boolean ret = false;
        if (i1 != null && i2 != null && i1.getChannelVariable() == i2.getChannelVariable() && i1.getOperation() != null && i1.getOperation().equals(i2.getOperation())) {
            ret = true;
        }
        return ret;
    }

    public static boolean isSendExchange(ExchangeDetails exchange) {
        boolean ret = false;
        if (exchange != null && exchange.getSendVariable() != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isReceiveExchange(ExchangeDetails exchange) {
        boolean ret = false;
        if (exchange != null && exchange.getReceiveVariable() != null) {
            ret = true;
        }
        return ret;
    }

    public static Collection getRelevantRecordDetails(Interaction interaction, Collection col) {
        Vector<RecordDetails> ret = new Vector<RecordDetails>();
        for (RecordDetails details : col) {
            if (details != null && interaction != details.getParent()) continue;
            ret.add(details);
        }
        return ret;
    }

    public static String getInterface(Interaction interaction) {
        String ret = null;
        if (interaction != null && interaction.getChannelVariable() != null && interaction.getChannelVariable().getType() instanceof ChannelType) {
            Behavior behavior;
            ChannelType ctype = (ChannelType)interaction.getChannelVariable().getType();
            if (ctype.getBehavior() != null) {
                ret = ctype.getBehavior().getInterface();
            } else if (ctype.getRoleType() != null && (behavior = ctype.getRoleType().getBehavior(null)) != null) {
                ret = behavior.getInterface();
            }
        }
        return ret;
    }

    public static boolean hasPrecedingInteraction(Activity act) {
        List<Perform> performs;
        boolean ret = false;
        Choreography choreo = act.getEnclosingChoreography();
        while (!ret && act != null) {
            if (!((act = ActivityUtil.getPrecedingActivity(act)) instanceof Interaction)) continue;
            ret = true;
        }
        if (!ret && choreo != null && choreo.getRoot() != Boolean.TRUE && (performs = choreo.getPerformingActivities()).size() > 0) {
            ret = true;
            int i = 0;
            while (ret && i < performs.size()) {
                ret = InteractionUtil.hasPrecedingInteraction(performs.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static boolean hasPrecedingInteraction(Activity act, ParticipantType ptype) {
        List<Perform> performs;
        boolean ret = false;
        Choreography choreo = act.getEnclosingChoreography();
        while (!ret && act != null) {
            if (!((act = ActivityUtil.getPrecedingActivity(act)) instanceof Interaction)) continue;
            int i = 0;
            while (!ret && i < ptype.getRoleTypes().size()) {
                RoleType rtype = (RoleType)ptype.getRoleTypes().get(i);
                if (act.isRelevantToRoleType(rtype)) {
                    ret = true;
                }
                ++i;
            }
        }
        if (!ret && choreo != null && choreo.getRoot() != Boolean.TRUE && (performs = choreo.getPerformingActivities()).size() > 0) {
            ret = true;
            int i = 0;
            while (ret && i < performs.size()) {
                ret = InteractionUtil.hasPrecedingInteraction(performs.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static List<ExchangeDetails> getRequestExchangeDetails(ExchangeDetails details) {
        Vector<ExchangeDetails> ret = new Vector<ExchangeDetails>();
        if (details.getAction() == ExchangeActionType.REQUEST) {
            ret.add(details);
        } else {
            Interaction interaction = details.getInteraction();
            Iterator iter = interaction.getExchangeDetails().iterator();
            while (ret.size() == 0 && iter.hasNext()) {
                ExchangeDetails ed = (ExchangeDetails)iter.next();
                if (ed.getAction() != ExchangeActionType.REQUEST) continue;
                ret.add(ed);
            }
        }
        if (ret.size() == 0) {
            InteractionUtil.findRequestExchangeDetails(details.getInteraction(), details, details.getInteraction().getChannelVariable(), details.getInteraction().getFromParticipant(), details.getInteraction().getToParticipant(), ret);
        }
        return ret;
    }

    protected static void findRequestExchangeDetails(Activity act, ExchangeDetails details, Variable channelVariable, Participant fromParticipant, Participant toParticipant, List results) {
        Choreography choreo;
        int initialSize = results.size();
        Activity original = act;
        do {
            Interaction interaction;
            if (!((act = ActivityUtil.getPrecedingActivity(act)) instanceof Interaction) || !(interaction = (Interaction)act).getOperation().equals(details.getInteraction().getOperation()) || interaction.getChannelVariable() != channelVariable || interaction.getToRoleType() != details.getInteraction().getToRoleType() || interaction.getFromRoleType() != details.getInteraction().getFromRoleType() || toParticipant != null && interaction.getToParticipant() != toParticipant || fromParticipant != null && interaction.getFromParticipant() != fromParticipant) continue;
            Iterator iter = interaction.getExchangeDetails().iterator();
            while (results.size() == initialSize && iter.hasNext()) {
                ExchangeDetails ed = (ExchangeDetails)iter.next();
                if (ed.getAction() != ExchangeActionType.REQUEST) continue;
                results.add(ed);
            }
            act = null;
        } while (results.size() == initialSize && act != null);
        if (results.size() == initialSize && (choreo = original.getEnclosingChoreography()) != null) {
            for (Perform perform : choreo.getPerformingActivities()) {
                Variable newChannel = null;
                int i = 0;
                while (newChannel == null && i < perform.getBindDetails().size()) {
                    BindDetails bd = (BindDetails)perform.getBindDetails().get(i);
                    if (bd.getFreeVariable() == channelVariable) {
                        newChannel = bd.getThisVariable();
                    }
                    ++i;
                }
                if (newChannel == null) continue;
                Participant newToParticipant = null;
                Participant newFromParticipant = null;
                InteractionUtil.findRequestExchangeDetails(perform, details, newChannel, newFromParticipant, newToParticipant, results);
            }
        }
    }

    public static List<ExchangeDetails> getResponseExchangeDetails(final ExchangeDetails req) {
        final Vector<ExchangeDetails> ret = new Vector<ExchangeDetails>();
        DefaultCDLVisitor visitor = new DefaultCDLVisitor(){

            public void interaction(Interaction interaction) {
                int i = 0;
                while (i < interaction.getExchangeDetails().size()) {
                    List<ExchangeDetails> reqs;
                    if (((ExchangeDetails)interaction.getExchangeDetails().get(i)).getAction() == ExchangeActionType.RESPOND && (reqs = InteractionUtil.getRequestExchangeDetails((ExchangeDetails)interaction.getExchangeDetails().get(i))) != null && reqs.contains(req)) {
                        ret.add((ExchangeDetails)interaction.getExchangeDetails().get(i));
                    }
                    ++i;
                }
            }
        };
        if (req.getEnclosingChoreography() != null) {
            req.getEnclosingChoreography().visit(visitor);
        }
        return ret;
    }
}

