/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.common.model.Model;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.AbstractValidationRuleSet;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.validation.ValidationRuleSet;

public class BaseValidationRuleSet
extends AbstractValidationRuleSet
implements ValidationRuleSet {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.validation");
    public static final String RULE_SET_ID = BaseValidationRuleSet.class.getName();
    private static final String DESCRIPTIVE_NAME = null;

    public BaseValidationRuleSet() {
        super(RULE_SET_ID, DESCRIPTIVE_NAME, false, true);
        this.setPriority(100);
    }

    protected void initializeContext(ValidationContext context, Model model) {
        super.initializeContext(context, model);
        if (context != null) {
            context.setSupportedVersion(CDLManager.getVersion());
        }
    }

    public boolean isRuleSetRelevant(Model model) {
        return model instanceof Package;
    }

    public void validate(Model model, ValidationContext context, ModelListener listener) throws ValidationException {
        if (model instanceof Package) {
            this.initializeContext(context, model);
            try {
                ((Package)model).validate(listener, context);
            }
            catch (Exception cdle) {
                logger.log(Level.SEVERE, "Failed to validate Choreography Description", cdle);
                throw new ValidationException("Failed to validate Choreography Description", (Throwable)cdle);
            }
        }
    }

    protected void validateModel(Model model, ValidationContext context, ModelListener listener) {
    }
}

