/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath;

import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.common.model.ModelListener;

public class DefaultXPathContext
implements XPathContext {
    private CDLType m_source = null;
    private Choreography m_choreography = null;
    private boolean m_exception = false;
    private ModelListener m_modelListener = null;
    private String m_mesgPrefix = null;
    private static final String PREFIX_SEPARATOR = ": ";

    public DefaultXPathContext(CDLType src, Choreography choreo, boolean exception, ModelListener l, String mesgPrefix) {
        this.m_source = src;
        this.m_choreography = choreo;
        this.m_exception = exception;
        this.m_modelListener = l;
        this.m_mesgPrefix = mesgPrefix;
    }

    public static XPathContext createContext(CDLType src, Choreography choreo, ModelListener l) {
        return new DefaultXPathContext(src, choreo, false, l, null);
    }

    public static XPathContext createContext(CDLType src, Choreography choreo, ModelListener l, String mesgPrefix) {
        return new DefaultXPathContext(src, choreo, false, l, mesgPrefix);
    }

    public static XPathContext createContext(CDLType src, Choreography choreo, ModelListener l, String mesgPrefix, boolean exception) {
        return new DefaultXPathContext(src, choreo, exception, l, mesgPrefix);
    }

    public CDLType getSource() {
        return this.m_source;
    }

    public void setSource(CDLType src) {
        this.m_source = src;
    }

    public Choreography getChoreography() {
        return this.m_choreography;
    }

    public boolean isException() {
        return this.m_exception;
    }

    public void setMessagePrefix(String mesg) {
        this.m_mesgPrefix = mesg;
    }

    public void reportError(String mesg) {
        if (this.m_modelListener != null) {
            String reportMessage = mesg;
            if (this.m_mesgPrefix != null) {
                reportMessage = String.valueOf(this.m_mesgPrefix) + PREFIX_SEPARATOR + reportMessage;
            }
            this.m_modelListener.report((Object)this.m_source, reportMessage, 2);
        }
    }

    public void reportWarning(String mesg) {
        if (this.m_modelListener != null) {
            String reportMessage = mesg;
            if (this.m_mesgPrefix != null) {
                reportMessage = String.valueOf(this.m_mesgPrefix) + PREFIX_SEPARATOR + reportMessage;
            }
            this.m_modelListener.report((Object)this.m_source, reportMessage, 1);
        }
    }
}

