/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath;

import java.util.Map;
import java.util.Vector;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.Function;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathFunctionRegistry;
import org.pi4soa.cdl.xpath.functions.XPathFunction;
import org.pi4soa.common.resource.ResourceLocator;

public class XPathValidatingVisitor
extends XPathVisitor {
    private XPathContext m_context = null;
    private boolean m_variableOnly = false;
    private RoleType[] m_roles = null;
    private String m_variableName = null;
    private String m_variablePart = null;
    private String m_variableDocPath = null;
    private boolean m_exceptionTypeOnly = false;
    private String m_exceptionType = null;
    private boolean m_participantBased = false;
    private boolean m_silent = false;
    private Participant m_participant = null;
    private Participant m_contextParticipant = null;

    public XPathValidatingVisitor(XPathContext context, RoleType[] roles, Participant participant, boolean variableOnly, boolean exceptionTypeOnly) {
        this.m_context = context;
        this.m_variableOnly = variableOnly;
        this.m_roles = roles;
        this.m_exceptionTypeOnly = exceptionTypeOnly;
        this.m_contextParticipant = participant;
    }

    public boolean visitFunction(ExpressionOwner owner, Function function) {
        if (function instanceof FuncExtFunction) {
            XPathFunction cdlfunc;
            FuncExtFunction extfunc = (FuncExtFunction)function;
            if (extfunc.getNamespace() == null || !extfunc.getNamespace().equals("http://www.w3.org/2005/10/cdl")) {
                this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_NOT_FOUND_FUNCTION_NAMESPACE", (Object[])new Object[]{extfunc.getFunctionName()}));
            }
            if ((cdlfunc = XPathFunctionRegistry.getFunction(extfunc.getFunctionName())) == null) {
                this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_NOT_FOUND_CDL_FUNCTION", (Object[])new Object[]{extfunc.getFunctionName()}));
            } else {
                String varName;
                Map parameters = cdlfunc.validate(extfunc, this.m_context);
                if (extfunc.getFunctionName().equals("getVariable")) {
                    varName = (String)parameters.get("variableName");
                    Variable var = this.m_context.getChoreography().getVariable(varName);
                    if (var != null && var.getSilent() == Boolean.TRUE) {
                        this.m_silent = true;
                    }
                } else if (extfunc.getFunctionName().equals("isVariableAvailable")) {
                    varName = (String)parameters.get("variableName");
                    Variable var = this.m_context.getChoreography().getVariable(varName);
                    if (var != null && var.getSilent() == Boolean.TRUE) {
                        this.m_silent = true;
                    }
                }
                if (this.m_variableOnly) {
                    if (this.m_variableName != null || !extfunc.getFunctionName().equals("getVariable")) {
                        this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_ONLY_ONE_FUNCTION", (Object[])new Object[]{"getVariable"}));
                    } else {
                        this.m_variableName = (String)parameters.get("variableName");
                        this.m_variablePart = (String)parameters.get("part");
                        this.m_variableDocPath = (String)parameters.get("documentPath");
                    }
                } else if (this.m_exceptionTypeOnly) {
                    if (this.m_exceptionType != null || !extfunc.getFunctionName().equals("hasExceptionOccurred")) {
                        this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_ONLY_ONE_FUNCTION", (Object[])new Object[]{"hasExceptionOccurred"}));
                    } else {
                        this.m_exceptionType = (String)parameters.get("exceptionType");
                    }
                }
                if (parameters.containsKey("roles")) {
                    this.validateRoleTypes(extfunc, (RoleType[])parameters.get("roles"));
                }
                if (cdlfunc.isParticipantBased()) {
                    Participant part = (Participant)parameters.get("participant");
                    if (this.m_participantBased && part != this.m_participant) {
                        this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_DIFFERENT_PARTICIPANTS", (Object[])new Object[0]));
                    }
                    this.m_participant = part;
                    this.m_participantBased = true;
                }
            }
        }
        return true;
    }

    protected void validateRoleTypes(FuncExtFunction extfunc, RoleType[] roleTypes) {
        Vector<RoleType> commonRoleTypes = new Vector<RoleType>();
        int i = 0;
        while (roleTypes != null && i < roleTypes.length) {
            int j = 0;
            while (this.m_roles != null && j < this.m_roles.length) {
                if (roleTypes[i] == this.m_roles[j]) {
                    commonRoleTypes.add(this.m_roles[j]);
                }
                ++j;
            }
            ++i;
        }
        if (commonRoleTypes.size() == 0) {
            String roles = "";
            int i2 = 0;
            while (i2 < roleTypes.length) {
                if (i2 != 0) {
                    roles = String.valueOf(roles) + ",";
                }
                roles = String.valueOf(roles) + roleTypes[i2].getName();
                ++i2;
            }
            this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_INCOMPATIBLE_ROLES", (Object[])new Object[]{extfunc.getFunctionName(), roles}));
        } else {
            this.m_roles = new RoleType[commonRoleTypes.size()];
            commonRoleTypes.copyInto(this.m_roles);
        }
    }

    public String getVariableName() {
        return this.m_variableName;
    }

    public String getVariablePart() {
        return this.m_variablePart;
    }

    public String getVariableDocumentPath() {
        return this.m_variableDocPath;
    }

    public String getExceptionType() {
        return this.m_exceptionType;
    }

    public RoleType[] getRoleTypes() {
        return this.m_roles;
    }

    public Participant getParticipant() {
        return this.m_participant;
    }

    public boolean isParticipantBased() {
        return this.m_participantBased;
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public void validationFinished() {
        if (this.m_variableOnly && this.getVariableName() == null) {
            this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_MUST_USE_FUNCTION", (Object[])new Object[]{"getVariable"}));
        }
        if (this.m_participantBased && this.m_participant != null && this.m_contextParticipant != null && this.m_participant != this.m_contextParticipant) {
            this.m_context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_INCOMPATIBLE_PARTICIPANT_WITH_CONTEXT", (Object[])new Object[0]));
        }
    }
}

