/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathVisitor;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.xpath.CDLPrefixResolver;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidatingVisitor;
import org.pi4soa.common.resource.ResourceLocator;

public class XPathValidator {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.xpath");

    public static ValidationResult validateVariable(XPathContext context, String variable, RoleType[] roles, boolean allRolesRequired) {
        ValidationResult ret = null;
        XPathValidatingVisitor visitor = new XPathValidatingVisitor(context, roles, null, true, false);
        XPathValidator.validate(variable, visitor, context, allRolesRequired);
        if (visitor.getVariableName() != null && context.getChoreography() != null) {
            ret = new ValidationResult(visitor.getRoleTypes(), null, visitor.getVariableName(), visitor.getVariablePart(), visitor.getVariableDocumentPath(), context.getChoreography().getVariable(visitor.getVariableName()), visitor.getParticipant(), visitor.isParticipantBased(), visitor.isSilent());
        }
        return ret;
    }

    public static ValidationResult validateExceptionType(XPathContext context, Package pack, RoleType[] roles, String expression) {
        ValidationResult ret = null;
        XPathValidatingVisitor visitor = new XPathValidatingVisitor(context, roles, null, false, true);
        XPathValidator.validate(expression, visitor, context, false);
        if (visitor.getExceptionType() != null && pack != null) {
            ret = new ValidationResult(visitor.getRoleTypes(), null, visitor.getExceptionType());
        }
        return ret;
    }

    public static ValidationResult validateExpression(XPathContext context, String expression, RoleType[] roles, Participant participant, boolean allRolesRequired) {
        ValidationResult ret = null;
        XPathValidatingVisitor visitor = new XPathValidatingVisitor(context, roles, participant, false, false);
        XPath xpath = XPathValidator.validate(expression, visitor, context, allRolesRequired);
        ret = new ValidationResult(visitor.getRoleTypes(), xpath, visitor.getVariableName(), visitor.getVariablePart(), visitor.getVariableDocumentPath(), null, visitor.getParticipant(), visitor.isParticipantBased(), visitor.isSilent());
        return ret;
    }

    protected static XPath validate(String expression, XPathValidatingVisitor visitor, XPathContext context, boolean allRolesRequired) {
        XPath xpath = null;
        int numOfRoleTypes = visitor.getRoleTypes().length;
        CDLPrefixResolver prefixResolver = null;
        prefixResolver = context.getSource() != null ? new CDLPrefixResolver(context.getSource().getPackage()) : new CDLPrefixResolver();
        try {
            xpath = new XPath(expression, null, (PrefixResolver)prefixResolver, 0);
        }
        catch (Exception e) {
            context.reportError(e.getLocalizedMessage());
        }
        if (xpath != null) {
            try {
                xpath.callVisitors(null, (XPathVisitor)visitor);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to process XPath expression", e);
            }
            visitor.validationFinished();
            if (allRolesRequired && visitor.getRoleTypes().length != numOfRoleTypes) {
                context.reportError(ResourceLocator.getMessage((String)"cdl", (String)"_XPATH_NOT_VALID_ALL_ROLES", null));
            }
        }
        return xpath;
    }
}

