/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Hashtable;
import java.util.Map;
import org.apache.xpath.Expression;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.objects.XString;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.functions.XPathFunction;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.TimeUtil;

public abstract class DefaultXPathFunction
implements XPathFunction {
    private String m_functionName = null;
    private int m_numberOfParameters = 0;
    private int m_numberOfMandatoryParameters = 0;
    private boolean m_repeatingParameters = false;
    private int[] m_parameterTypes = null;
    private String[] m_parameterNames = null;
    private int m_returnType = 0;

    public DefaultXPathFunction(String funcName, int numParams, int numMandatoryParams, boolean repeatingParams, int[] paramTypes, String[] paramNames, int returnType) {
        this.m_functionName = funcName;
        this.m_numberOfParameters = numParams;
        this.m_numberOfMandatoryParameters = numMandatoryParams;
        this.m_repeatingParameters = repeatingParams;
        this.m_parameterTypes = paramTypes;
        this.m_parameterNames = paramNames;
    }

    public String getName() {
        return this.m_functionName;
    }

    protected boolean validateParameters(FuncExtFunction excfunc, XPathContext context) {
        boolean ret = true;
        if (this.isRepeatingParameters()) {
            if (excfunc.getArgCount() < this.getNumberOfParameters() || excfunc.getArgCount() % this.getNumberOfParameters() != 0) {
                context.reportError(this.getMessage("_XPATH_REPEATING_PARAMS", new Object[]{this.getName()}));
                ret = false;
            }
        } else if (excfunc.getArgCount() < this.getNumberOfMandatoryParameters()) {
            context.reportError(this.getMessage("_XPATH_NOT_ENOUGH_PARAMS", new Object[]{this.getName()}));
            ret = false;
        } else if (excfunc.getArgCount() > this.getNumberOfParameters()) {
            context.reportError(this.getMessage("_XPATH_TOO_MANY_PARAMS", new Object[]{this.getName()}));
            ret = false;
        }
        if (ret) {
            int i = 0;
            while (this.getNumberOfParameters() > 0 && i < excfunc.getArgCount()) {
                int type = this.getParameterTypes()[i % this.getNumberOfParameters()];
                String name = this.getParameterNames()[i % this.getNumberOfParameters()];
                Expression val = excfunc.getArg(i);
                switch (type) {
                    case 2: 
                    case 4: {
                        if (val instanceof XString) break;
                        context.reportError(this.getMessage("_XPATH_PARAM_TYPE", new Object[]{this.getName(), name}));
                        ret = false;
                        break;
                    }
                    case 5: {
                        if (!(val instanceof XString)) break;
                        try {
                            TimeUtil.getDuration((String)val.toString());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            context.reportError(this.getMessage("_XPATH_DURATION_PARAM_TYPE", new Object[]{this.getName(), name}));
                            ret = false;
                        }
                        break;
                    }
                    case 8: {
                        if (!(val instanceof XString)) break;
                        try {
                            TimeUtil.getDeadline((String)val.toString());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            context.reportError(this.getMessage("_XPATH_DEADLINE_PARAM_TYPE", new Object[]{this.getName(), name}));
                            ret = false;
                        }
                        break;
                    }
                    default: {
                        context.reportError(this.getMessage("_XPATH_PARAM_UNKNOWN_TYPE", new Object[]{this.getName(), name}));
                        ret = false;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    protected int getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    protected int getNumberOfMandatoryParameters() {
        return this.m_numberOfMandatoryParameters;
    }

    protected boolean isRepeatingParameters() {
        return this.m_repeatingParameters;
    }

    protected int[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    protected String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public int getReturnType() {
        return this.m_returnType;
    }

    protected Map buildReturnParameters(String roleName, Variable var, XPathContext context) {
        Hashtable<String, RoleType[]> ret = new Hashtable<String, RoleType[]>();
        RoleType[] roleTypes = var.getRoleTypesForContext();
        if (roleName != null) {
            RoleType[] singleRoleType = new RoleType[1];
            int i = 0;
            while (i < roleTypes.length && singleRoleType[0] == null) {
                if (roleTypes[i].getName().equals(roleName)) {
                    singleRoleType[0] = roleTypes[i];
                }
                ++i;
            }
            if (singleRoleType[0] != null) {
                ret.put("roles", singleRoleType);
            }
        } else {
            ret.put("roles", roleTypes);
        }
        return ret;
    }

    protected void validateVariableAtRoleOrParticipant(Variable var, String name, XPathContext context) {
        RoleType[] roleTypes;
        if (name != null && (roleTypes = this.getRoleTypes(name, context)) != null) {
            boolean inContext = false;
            int i = 0;
            while (!inContext && i < roleTypes.length) {
                if (var.isRoleTypeAssociatedWithContext(roleTypes[i].getName())) {
                    inContext = true;
                }
                ++i;
            }
            if (!inContext) {
                context.reportError(this.getMessage("_XPATH_VAR_NOT_KNOWN_IN_ROLE_OR_PARTICIPANT", new Object[]{this.getName(), var.getName(), name}));
            }
        }
    }

    protected boolean validateRoleOrParticipant(String name, XPathContext context) {
        boolean ret = false;
        Package cdlpack = context.getSource().getPackage();
        Choreography choreo = context.getSource().getEnclosingChoreography();
        if (cdlpack != null && name != null && cdlpack.getRoleType(name) == null && choreo != null && choreo.getParticipant(name) == null) {
            context.reportError(this.getMessage("_XPATH_UNKNOWN_ROLE_OR_PARTICIPANT", new Object[]{this.getName(), name}));
        } else {
            ret = true;
        }
        return ret;
    }

    protected RoleType[] getRoleTypes(String name, XPathContext context) {
        RoleType[] ret = null;
        RoleType singleRoleType = context.getSource().getPackage().getRoleType(name);
        if (singleRoleType != null) {
            ret = new RoleType[]{singleRoleType};
        } else {
            Participant part = context.getSource().getEnclosingChoreography().getParticipant(name);
            if (part != null && part.getRoleTypes().size() > 0) {
                ret = new RoleType[part.getRoleTypes().size()];
                int i = 0;
                while (i < part.getRoleTypes().size()) {
                    ret[i] = (RoleType)part.getRoleTypes().get(i);
                    ++i;
                }
            }
        }
        return ret;
    }

    protected String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)"cdl", (String)key, (Object[])params);
    }

    public boolean isParticipantBased() {
        return false;
    }
}

