/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pi4soa.common.util.SerializationUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannel
implements Channel,
Externalizable {
    private static final long serialVersionUID = -4022227091644163432L;
    private static final int SERIALIZATION_VERSION = 1;
    private Long m_internalId;
    private String m_name = null;
    private String m_type = null;
    private String m_serviceType = null;
    private Set<Identity> m_identities = new HashSet<Identity>();
    private String m_serviceReferenceType = null;
    private EndpointReference m_serviceReference = null;
    private Map<String, Serializable> m_properties = new Hashtable<String, Serializable>();

    public DefaultChannel() {
    }

    public DefaultChannel(String name, String type, String serviceRefType, String serviceType) {
        this.m_name = name;
        this.m_type = type;
        this.m_serviceReferenceType = serviceRefType;
        this.m_serviceType = serviceType;
    }

    public Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public boolean addPrimaryIdentity(Identity id) {
        boolean ret = false;
        if (!this.m_identities.contains(id)) {
            this.m_identities.add(new Identity(id));
            ret = true;
        }
        return ret;
    }

    @Override
    public Set<Identity> getPrimaryIdentities() {
        return this.m_identities;
    }

    public void setPrimaryIdentities(Set<Identity> ids) {
        this.m_identities = ids;
    }

    @Override
    public boolean isPrimaryIdentity(Identity id) {
        boolean ret = false;
        ret = this.getPrimaryIdentities().contains(id);
        return ret;
    }

    @Override
    public boolean hasPrimaryIdentity(String name) {
        boolean ret = false;
        Iterator<Identity> iter = this.getPrimaryIdentities().iterator();
        while (!ret && iter.hasNext()) {
            Identity primid = iter.next();
            if (!primid.getName().equals(name)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public String getServiceReferenceType() {
        return this.m_serviceReferenceType;
    }

    public void setServiceReferenceType(String refType) {
        this.m_serviceReferenceType = refType;
    }

    @Override
    public EndpointReference getServiceReference() {
        return this.m_serviceReference;
    }

    public void setServiceReference(EndpointReference ref) {
        this.m_serviceReference = ref;
    }

    @Override
    public String getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(String serviceType) {
        this.m_serviceType = serviceType;
    }

    @Override
    public Serializable getProperty(String name) {
        return this.m_properties.get(name);
    }

    @Override
    public void setProperty(String name, Serializable value) {
        this.m_properties.put(name, value);
    }

    public Map<String, Serializable> getProperties() {
        return this.m_properties;
    }

    public void setProperties(Map<String, Serializable> props) {
        this.m_properties = props;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object obj) {
        Channel other;
        boolean ret = false;
        if (obj instanceof Channel && (other = (Channel)obj).getName() != null && this.getName() != null && other.getName().equals(this.getName()) && (other.getServiceReference() == null || this.getServiceReference() == null || other.getServiceReference().equals(this.getServiceReference()))) {
            Iterator<Identity> iter = this.getPrimaryIdentities().iterator();
            while (!ret && iter.hasNext()) {
                Identity id = iter.next();
                if (!other.isPrimaryIdentity(id)) continue;
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_name));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_type));
        out.writeInt(this.m_identities.size());
        Iterator<Identity> iter = this.m_identities.iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
        }
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_serviceReferenceType));
        out.writeObject(this.m_serviceReference);
        SerializationUtil.encodeMap(this.m_properties, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_name = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_type = SerializationUtil.decodeUTF((String)in.readUTF());
            int num = in.readInt();
            int i = 0;
            while (i < num) {
                this.m_identities.add((Identity)in.readObject());
                ++i;
            }
            this.m_serviceReferenceType = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_serviceReference = (EndpointReference)in.readObject();
            SerializationUtil.decodeMap(this.m_properties, (ObjectInput)in);
        }
    }
}

