/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.util.SerializationUtil;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.MutableMessage;
import org.pi4soa.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessage
implements MutableMessage,
Externalizable {
    private static final long serialVersionUID = -1720370259789361857L;
    private static final int SERIALIZATION_VERSION = 1;
    private String m_operationName = null;
    private String m_faultName = null;
    private String m_type = null;
    private boolean m_isRequest = false;
    private boolean m_isRPC = false;
    private String m_serviceType = null;
    private EndpointReference m_serviceEndpoint = null;
    private Serializable m_value = null;
    private Identity m_sessionId = null;
    private Identity m_channelIdentity = null;
    private List<Identity> m_behaviorIdentities = null;
    private Map m_properties = new Hashtable();
    private int m_retryCount = -1;
    private int m_failedToProcessCount = 0;

    public DefaultMessage() {
    }

    public DefaultMessage(String opName, String faultName, String type, boolean isRequest, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        this.m_operationName = opName;
        this.m_faultName = faultName;
        this.m_type = type;
        this.m_isRequest = isRequest;
        this.m_serviceType = serviceType;
        this.m_serviceEndpoint = serviceEndpoint;
        this.m_value = value;
        this.m_sessionId = sessionId;
        this.m_channelIdentity = channelIdentity;
        this.m_isRPC = true;
    }

    public DefaultMessage(String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        this(null, null, type, true, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        this.m_isRPC = false;
    }

    @Override
    public String getOperationName() {
        return this.m_operationName;
    }

    @Override
    public void setOperationName(String name) {
        this.m_operationName = name;
    }

    @Override
    public String getFaultName() {
        return this.m_faultName;
    }

    @Override
    public void setFaultName(String faultName) {
        this.m_faultName = faultName;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public boolean isRequest() {
        return this.m_isRequest;
    }

    @Override
    public boolean isRPCStyle() {
        return this.m_isRPC;
    }

    public void setRPCStyle(boolean rpc) {
        this.m_isRPC = rpc;
    }

    @Override
    public String getServiceType() {
        return this.m_serviceType;
    }

    @Override
    public void setServiceType(String serviceType) {
        this.m_serviceType = serviceType;
    }

    @Override
    public EndpointReference getServiceEndpoint() {
        return this.m_serviceEndpoint;
    }

    @Override
    public Serializable getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Serializable value) {
        this.m_value = value;
    }

    @Override
    public Serializable getMultiPartValue(String part) throws IllegalStateException, ServiceException {
        if (!(this.m_value instanceof Map)) {
            throw new IllegalStateException("Not a multi-part message");
        }
        return (Serializable)((Map)((Object)this.m_value)).get(part);
    }

    @Override
    public void setMultiPartValue(String part, Serializable value) throws IllegalStateException {
        if (this.m_value == null) {
            this.m_value = new Hashtable();
        } else if (!(this.m_value instanceof Map)) {
            throw new IllegalStateException("Not a multi-part message");
        }
        ((Map)((Object)this.m_value)).put(part, value);
    }

    @Override
    public boolean isMultiPart() {
        return this.m_value instanceof Map;
    }

    @Override
    public Identity getSessionIdentity() {
        return this.m_sessionId;
    }

    @Override
    public void setSessionIdentity(Identity id) {
        this.m_sessionId = id;
    }

    @Override
    public Identity getChannelIdentity() {
        return this.m_channelIdentity;
    }

    @Override
    public void setChannelIdentity(Identity id) {
        this.m_channelIdentity = id;
    }

    public void setMessageIdentities(Identity[] ids) {
        this.m_behaviorIdentities = new Vector<Identity>();
        int i = 0;
        while (i < ids.length) {
            this.m_behaviorIdentities.add(ids[i]);
            ++i;
        }
    }

    @Override
    public void setMessageIdentities(List<Identity> ids) {
        this.m_behaviorIdentities = ids;
    }

    @Override
    public List<Identity> getMessageIdentities() {
        return this.m_behaviorIdentities;
    }

    @Override
    public Identity getMessageIdentity(String name) {
        List<Identity> identities = this.getMessageIdentities();
        Identity ret = null;
        if (identities != null) {
            int i = 0;
            while (i < identities.size()) {
                if (identities.get(i).getName() != null && identities.get(i).getName().equals(name)) {
                    ret = identities.get(i);
                }
                ++i;
            }
        }
        return ret;
    }

    @Override
    public boolean isOutbound() {
        return false;
    }

    @Override
    public Serializable getProperty(String name) {
        return (Serializable)this.m_properties.get(name);
    }

    @Override
    public void setProperty(String name, Serializable value) {
        this.m_properties.put(name, value);
    }

    public Map getProperties() {
        return this.m_properties;
    }

    @Override
    public void processingFailed() {
        --this.m_retryCount;
        ++this.m_failedToProcessCount;
    }

    @Override
    public boolean shouldRetry() {
        return this.m_retryCount >= 0;
    }

    @Override
    public void setRetryCount(int retryCount) {
        this.m_retryCount = retryCount;
    }

    @Override
    public int getFailedToProcessCount() {
        return this.m_failedToProcessCount;
    }

    public String toString() {
        String fault = "";
        if (NamesUtil.isSet((String)this.getFaultName())) {
            fault = "fault=" + this.getFaultName() + " ";
        }
        return "message[operation=" + this.getOperationName() + " " + fault + "request=\"" + this.isRequest() + "\" messageType=" + this.getType() + " serviceType=" + this.getServiceType() + " serviceEndpoint=" + this.getServiceEndpoint() + " outbound=" + this.isOutbound() + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_operationName));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_faultName));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_type));
        out.writeBoolean(this.m_isRequest);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_serviceType));
        out.writeObject(this.m_serviceEndpoint);
        out.writeObject(this.m_value);
        out.writeObject(this.m_sessionId);
        out.writeObject(this.m_channelIdentity);
        out.writeObject(this.m_behaviorIdentities);
        SerializationUtil.encodeMap((Map)this.m_properties, (ObjectOutput)out);
        out.writeInt(this.m_retryCount);
        out.writeInt(this.m_failedToProcessCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_operationName = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_faultName = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_type = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_isRequest = in.readBoolean();
            this.m_serviceType = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_serviceEndpoint = (EndpointReference)in.readObject();
            this.m_value = (Serializable)in.readObject();
            this.m_sessionId = (Identity)in.readObject();
            this.m_channelIdentity = (Identity)in.readObject();
            this.m_behaviorIdentities = (List)in.readObject();
            SerializationUtil.decodeMap((Map)this.m_properties, (ObjectInput)in);
            this.m_retryCount = in.readInt();
            this.m_failedToProcessCount = in.readInt();
        }
    }
}

