/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.pi4soa.common.util.SerializationUtil;

public class Identity
implements Externalizable {
    private static final long serialVersionUID = 2299055399090352158L;
    private static final int SERIALIZATION_VERSION = 1;
    public static final String VALUE_SEPARATOR = "=";
    public static final String TOKEN_SEPARATOR = ";";
    public static final String LIST_SEPARATOR = ", ";
    public static final String ID_SUFFIX = "}";
    public static final String ID_PREFIX = "ID{";
    public static final String LIST_SUFFIX = "]";
    public static final String LIST_PREFIX = "[";
    private Long m_internalId;
    private String m_id = null;
    private String m_fullId = null;
    private String m_name = null;
    private String[] m_tokens = null;
    private Object[] m_values = null;

    public Identity() {
    }

    public Identity(Identity id) {
        this.m_id = id.m_id;
        this.m_fullId = id.m_fullId;
        this.m_name = id.m_name;
        this.m_tokens = id.m_tokens;
        this.m_values = id.m_values;
    }

    public Identity(String name, String id) {
        this.m_name = name;
        this.m_fullId = id;
        this.initializeTokenValues();
        this.initializeId();
    }

    public Identity(String name, String[] tokens, Object[] values) {
        this.m_name = name;
        this.m_tokens = tokens;
        this.m_values = values;
        this.initializeId();
        this.initializeFullId();
    }

    protected void initializeId() {
        StringBuffer ret = new StringBuffer();
        if (this.m_tokens != null && this.m_values != null && this.m_tokens.length == this.m_values.length && this.m_values.length > 0) {
            int i = 0;
            while (i < this.m_tokens.length) {
                if (i > 0) {
                    ret.append(TOKEN_SEPARATOR);
                }
                ret.append(this.m_values[i].toString());
                ++i;
            }
            this.m_id = ret.toString();
        } else {
            this.m_id = this.m_fullId;
        }
    }

    protected void initializeFullId() {
        StringBuffer ret = new StringBuffer(ID_PREFIX);
        if (this.m_tokens != null && this.m_values != null && this.m_tokens.length == this.m_values.length) {
            int i = 0;
            while (i < this.m_tokens.length) {
                if (i > 0) {
                    ret.append(TOKEN_SEPARATOR);
                }
                ret.append(this.m_tokens[i]);
                ret.append(VALUE_SEPARATOR);
                ret.append(this.m_values[i].toString());
                ++i;
            }
        }
        ret.append(ID_SUFFIX);
        this.m_fullId = ret.toString();
    }

    protected void initializeTokenValues() {
        int startpos = -1;
        int endpos = -1;
        if (this.m_fullId != null && (startpos = this.m_fullId.indexOf(ID_PREFIX)) != -1 && (endpos = this.m_fullId.indexOf(ID_SUFFIX)) != -1) {
            Vector<String> tokens = new Vector<String>();
            Vector<String> values = new Vector<String>();
            int valuepos = -1;
            startpos += ID_PREFIX.length();
            while ((valuepos = this.m_fullId.indexOf(VALUE_SEPARATOR, startpos)) != -1) {
                int nexttokenpos = this.m_fullId.indexOf(TOKEN_SEPARATOR, valuepos);
                int valueendpos = nexttokenpos;
                if (valueendpos == -1) {
                    valueendpos = endpos;
                }
                String token = this.m_fullId.substring(startpos, valuepos);
                String value = this.m_fullId.substring(valuepos + VALUE_SEPARATOR.length(), valueendpos);
                Object objValue = value;
                if (value.startsWith(LIST_PREFIX)) {
                    Vector<String> v = new Vector<String>();
                    int endlist = value.indexOf(LIST_SUFFIX);
                    if (endlist != -1) {
                        StringTokenizer st = new StringTokenizer(value.substring(LIST_PREFIX.length(), endlist), LIST_SEPARATOR);
                        while (st.hasMoreTokens()) {
                            String listValue = st.nextToken();
                            v.add(listValue);
                        }
                        objValue = v;
                    }
                }
                tokens.add(token);
                values.add((String)objValue);
                startpos = valueendpos + TOKEN_SEPARATOR.length();
            }
            this.m_tokens = new String[tokens.size()];
            this.m_values = new Object[values.size()];
            tokens.copyInto(this.m_tokens);
            values.copyInto(this.m_values);
        } else {
            this.m_tokens = new String[0];
            this.m_values = new Object[0];
        }
    }

    protected Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    public String getId() {
        return this.m_id;
    }

    protected void setId(String id) {
        this.m_id = id;
    }

    public String getFullId() {
        return this.m_fullId;
    }

    protected void setFullId(String id) {
        this.m_fullId = id;
    }

    public String[] getTokens() {
        if (this.m_tokens == null) {
            this.initializeTokenValues();
        }
        return this.m_tokens;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof Identity) {
            Identity other = (Identity)obj;
            ret = true;
            if (ret && (this.getTokens() == null || this.getValues() == null || this.getTokens().length != this.getValues().length)) {
                ret = false;
            }
            if (ret && (other.getTokens() == null || other.getValues() == null || other.getTokens().length != other.getValues().length)) {
                ret = false;
            }
            if (ret && this.getTokens().length != other.getTokens().length) {
                ret = false;
            }
            if (ret && this.getValues().length == 0 && !this.valuesEqual(this.getId(), other.getId())) {
                ret = false;
            }
            int i = 0;
            while (ret && i < this.m_tokens.length) {
                Object value1 = this.getValues()[i];
                Object value2 = other.getValues()[i];
                if (value1 == null || value2 == null || !this.valuesEqual(value1, value2)) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }

    protected boolean valuesEqual(Object value1, Object value2) {
        boolean ret;
        block5: {
            block6: {
                block7: {
                    block3: {
                        block4: {
                            ret = false;
                            if (!(value1 instanceof String)) break block3;
                            if (!(value2 instanceof String)) break block4;
                            ret = value1.equals(value2);
                            break block5;
                        }
                        if (!(value2 instanceof List)) break block5;
                        ret = ((List)value2).contains(value1);
                        break block5;
                    }
                    if (!(value2 instanceof String)) break block6;
                    if (!(value1 instanceof String)) break block7;
                    ret = value2.equals(value1);
                    break block5;
                }
                if (!(value1 instanceof List)) break block5;
                ret = ((List)value1).contains(value2);
                break block5;
            }
            if (value1 instanceof List && value2 instanceof List) {
                int i = 0;
                while (!ret && i < ((List)value1).size()) {
                    if (((List)value2).contains(((List)value1).get(i))) {
                        ret = true;
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    public int hashCode() {
        int ret = 0;
        try {
            ret = this.getId().hashCode();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String toString() {
        return this.m_id.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_id));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_fullId));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_name));
        int size = 0;
        if (this.m_tokens != null && this.m_values != null) {
            size = this.m_tokens.length;
        }
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            out.writeUTF(SerializationUtil.encodeUTF((String)this.m_tokens[i]));
            out.writeObject(this.m_values[i]);
            ++i;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_id = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_fullId = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_name = SerializationUtil.decodeUTF((String)in.readUTF());
            int size = in.readInt();
            this.m_tokens = new String[size];
            this.m_values = new String[size];
            int i = 0;
            while (i < size) {
                this.m_tokens[i] = SerializationUtil.decodeUTF((String)in.readUTF());
                this.m_values[i] = in.readObject();
                ++i;
            }
        }
    }
}

