/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathEvaluatorFactory;
import org.pi4soa.service.DefaultEndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAEndpointReference
extends DefaultEndpointReference
implements Externalizable {
    private static final long serialVersionUID = 9037624993128045115L;
    private static final int SERIALIZATION_VERSION = 1;
    public static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private static Logger logger = Logger.getLogger("org.pi4soa.service");

    public WSAEndpointReference() {
    }

    public WSAEndpointReference(String address) throws ServiceException {
        super(WSAEndpointReference.getURL(address), NameSpaceUtil.getFullyQualifiedName((String)WSA_NAMESPACE, (String)"EndpointReference"));
    }

    protected static String getURL(String address) throws ServiceException {
        String ret = null;
        try {
            new URL(address);
            ret = address;
        }
        catch (Exception exception) {
            try {
                XPathEvaluator evaluator = XPathEvaluatorFactory.getXPathEvaluator();
                Object obj = evaluator.evaluate((Object)address, "/*[local-name()='EndpointReference']/*[local-name()='Address']/text()", null);
                if (obj != null) {
                    ret = obj.toString();
                }
            }
            catch (Exception e2) {
                logger.severe("Failed to convert address '" + address + "' into URL: " + e2);
            }
        }
        if (ret == null) {
            throw new ServiceException("Failed to convert WSA endpoint reference '" + address + "'");
        }
        logger.fine("Converted WSA endpoint ref '" + address + "' into URL '" + ret + "'");
        return ret;
    }

    @Override
    public String toText(Collection<Identity> ids) {
        String ret = null;
        StringBuffer tokens = new StringBuffer();
        Hashtable<String, Object> idtokens = new Hashtable<String, Object>();
        if (ids != null) {
            for (Identity identry : ids) {
                if (identry.getTokens() == null || identry.getValues() == null || identry.getTokens().length != identry.getValues().length) continue;
                int j = 0;
                while (j < identry.getTokens().length) {
                    if (!idtokens.containsKey(identry.getTokens()[j])) {
                        idtokens.put(identry.getTokens()[j], identry.getValues()[j]);
                    }
                    ++j;
                }
            }
        }
        Enumeration iter = idtokens.keys();
        while (iter.hasMoreElements()) {
            String token = (String)iter.nextElement();
            String value = (String)idtokens.get(token);
            tokens.append("<" + token + ">" + value + "</" + token + ">");
        }
        ret = "<wsa:EndpointReference xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" ><wsa:Address>" + this.getEndpointURL() + "</wsa:Address>" + "<wsa:Metadata>" + tokens.toString() + "</wsa:Metadata>" + "</wsa:EndpointReference>";
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short version = in.readShort();
    }
}

