/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IdentityType implements Enumerator
{
    PRIMARY(1, "Primary", "Primary"),
    ALTERNATE(2, "Alternate", "Alternate"),
    ASSOCIATION(3, "Association", "Association"),
    DERIVED(4, "Derived", "Derived");

    public static final int PRIMARY_VALUE = 1;
    public static final int ALTERNATE_VALUE = 2;
    public static final int ASSOCIATION_VALUE = 3;
    public static final int DERIVED_VALUE = 4;
    private static final IdentityType[] VALUES_ARRAY;
    public static final List<IdentityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IdentityType[]{PRIMARY, ALTERNATE, ASSOCIATION, DERIVED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IdentityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdentityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdentityType get(int value) {
        switch (value) {
            case 1: {
                return PRIMARY;
            }
            case 2: {
                return ALTERNATE;
            }
            case 3: {
                return ASSOCIATION;
            }
            case 4: {
                return DERIVED;
            }
        }
        return null;
    }

    private IdentityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

