/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageClassification implements Enumerator
{
    REQUEST(1, "Request", "Request"),
    RESPONSE(2, "Response", "Response"),
    NOTIFICATION(3, "Notification", "Notification");

    public static final int REQUEST_VALUE = 1;
    public static final int RESPONSE_VALUE = 2;
    public static final int NOTIFICATION_VALUE = 3;
    private static final MessageClassification[] VALUES_ARRAY;
    public static final List<MessageClassification> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageClassification[]{REQUEST, RESPONSE, NOTIFICATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageClassification get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageClassification result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageClassification getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageClassification result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageClassification get(int value) {
        switch (value) {
            case 1: {
                return REQUEST;
            }
            case 2: {
                return RESPONSE;
            }
            case 3: {
                return NOTIFICATION;
            }
        }
        return null;
    }

    private MessageClassification(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

