/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.common.util.EMFUtil;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.LookaheadMessageImpl;
import org.pi4soa.service.behavior.impl.MessageActivityImpl;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.session.internal.InternalSession;

public abstract class ActivityTypeImpl
extends BehaviorTypeImpl
implements ActivityType {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_globalDescriptionURI = null;
    private String m_endpointDescriptionURI = null;

    public boolean isActivityExtensionRequired() {
        return false;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.activityType(this);
        super.visit(visitor);
    }

    public Serializable getVariable(InternalSession session, String variableName, String partName) throws LockedInformationException, UnresolvedConstraintException, ServiceException {
        Serializable ret = null;
        ret = session.getVariable(variableName);
        if (this.isSet(partName) && ret != null) {
            if (ret instanceof Map) {
                if ((ret = (Serializable)((Map)((Object)ret)).get(partName)) == null) {
                    throw new UnresolvedConstraintException(variableName);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Extracting part from variable '" + variableName + "' part '" + partName + "' in multi-part message: session=" + session + " value=" + ret);
                }
            } else {
                ret = null;
                logger.warning(session.getId() + ": Activity '" + this.getName() + "' - Attempt to access part '" + partName + "' on variable '" + variableName + "' which is not a multi-part message");
            }
        } else if (ret instanceof Map && ((Map)((Object)ret)).size() == 1) {
            Object obj = ((Map)((Object)ret)).values().iterator().next();
            if (obj instanceof Serializable) {
                ret = (Serializable)obj;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Extracting single part from variable '" + variableName + "' in multi-part message: session=" + session + " value=" + ret);
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVariable(InternalSession session, String variableName, String partName, Serializable value) throws LockedInformationException, ServiceException {
        if (this.isSet(partName)) {
            Serializable oldValue = null;
            try {
                oldValue = session.getVariable(variableName);
            }
            catch (UnresolvedConstraintException unresolvedConstraintException) {}
            Hashtable<String, Serializable> mesg = null;
            if (oldValue instanceof Map) {
                mesg = (Hashtable<String, Serializable>)oldValue;
            } else if (oldValue == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Creating empty map for variable '" + variableName + "' multi-part message: session=" + session);
                }
                mesg = new Hashtable<String, Serializable>();
                session.setVariable(variableName, mesg);
            } else {
                logger.severe(session.getId() + ": Activity '" + this.getName() + "' - Message is not a multi-part" + " message, part=" + partName);
            }
            if (mesg == null) return;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Setting variable '" + variableName + "' part '" + partName + "' in multi-part message: session=" + session + " value=" + value);
            }
            mesg.put(partName, value);
            return;
        }
        Serializable oldValue = null;
        try {
            oldValue = session.getVariable(variableName);
        }
        catch (UnresolvedConstraintException unresolvedConstraintException) {}
        if (oldValue instanceof Map) {
            if (value instanceof Map) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Replacing multipart variable '" + variableName + "': session=" + session + " value=" + value);
                }
                session.setVariable(variableName, value);
                return;
            }
            if (((Map)((Object)oldValue)).size() != 1) {
                logger.severe("Cannot replace existing multi-part variable, containing multiple entries, with a non-multipart value: " + value + " session=" + session);
                throw new ServiceException("Cannot replace existing multi-part variable, containing multiple entries, with a non-multipart value");
            }
            String pname = (String)((Map)((Object)oldValue)).keySet().iterator().next();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Updating variable '" + variableName + "' single part '" + pname + "' in multi-part message: session=" + session + " value=" + value);
            }
            ((Map)((Object)oldValue)).put(pname, value);
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Setting variable '" + variableName + "': session=" + session + " value=" + value);
        }
        session.setVariable(variableName, value);
    }

    protected void initializeConditions(List acts, List predicates) {
        if (acts != null) {
            for (Object act : acts) {
                PredicateImpl pred = null;
                if (act instanceof MessageActivityImpl) {
                    LookaheadMessageImpl lookahead = new LookaheadMessageImpl();
                    lookahead.setMessageActivity((MessageActivityImpl)act);
                    pred = lookahead;
                } else if (act instanceof PredicateImpl) {
                    pred = (PredicateImpl)act;
                }
                predicates.add(pred);
            }
        }
    }

    public String getEndpointDescriptionURI() {
        if (this.m_endpointDescriptionURI == null) {
            this.m_endpointDescriptionURI = EMFUtil.getURIFragment((Object)this);
        }
        return this.m_endpointDescriptionURI;
    }

    public String getGlobalDescriptionURI() {
        return this.m_globalDescriptionURI;
    }

    public void setGlobalDescriptionURI(String newGlobalDescriptionURI) {
        this.m_globalDescriptionURI = newGlobalDescriptionURI;
    }

    protected abstract List getNextMessageRelevantActivities(BehaviorTypeImpl var1, boolean var2, BehaviorTypeImpl var3, List var4);

    protected ActivityTypeImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.ACTIVITY_TYPE;
    }
}

