/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.AtomicUnit;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.SessionFactory;

public class AtomicUnitImpl
extends StructuralTypeImpl
implements AtomicUnit,
InternalSessionListener {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, OutOfSequenceMessageException {
        boolean ret = false;
        if (this.getActivityTypes().size() > 0) {
            InternalSession subsession = SessionFactory.getAtomicSession(session);
            subsession.setInternalSessionListener(this);
            subsession.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
            ret = subsession.process(event);
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return ret;
    }

    public void sessionListenerRegistered(InternalSession session) {
    }

    public void sessionFinished(InternalSession session) throws ServiceException {
        if (session.getTerminatingException() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Propagating exception '" + session.getTerminatingException() + "'");
            }
            this.propagateException(session.getParent(), session.getTerminatingException());
        } else {
            this.completed(session.getParent());
        }
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                session.sessionCompleted();
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Atomic Unit could not find completed child");
        }
    }

    protected void propagateException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        super.handleException(session, exception);
    }

    protected void handleException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Terminating atomic unit session due to exception '" + exception + "'");
        }
        session.sessionTerminated(exception);
    }

    protected List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        int pos = 0;
        if (after != null && (pos = this.getActivityTypes().indexOf((Object)after)) != -1) {
            ++pos;
        }
        if (pos != -1) {
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (ret == null && this.getParentImpl() instanceof ActivityTypeImpl && scope != this) {
                ret = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path);
            }
        }
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.atomicUnitStart(this);
        super.visit(visitor);
        visitor.atomicUnitEnd(this);
    }

    protected AtomicUnitImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.ATOMIC_UNIT;
    }
}

