/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.CompletionHandler;
import org.pi4soa.service.behavior.DefaultBehaviorVisitor;
import org.pi4soa.service.behavior.ExceptionHandler;
import org.pi4soa.service.behavior.Finalize;
import org.pi4soa.service.behavior.MessageActivity;
import org.pi4soa.service.behavior.Perform;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.VariableDeclaration;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.CompletionHandlerImpl;
import org.pi4soa.service.behavior.impl.ExceptionHandlerImpl;
import org.pi4soa.service.behavior.impl.FinalizeImpl;
import org.pi4soa.service.behavior.impl.PerformImpl;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.behavior.impl.SendImpl;
import org.pi4soa.service.behavior.impl.SequenceImpl;
import org.pi4soa.service.behavior.impl.ServiceDescriptionImpl;
import org.pi4soa.service.behavior.impl.SessionEndPredicateImpl;
import org.pi4soa.service.behavior.impl.XPathConditionImpl;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorDescriptionImpl
extends SequenceImpl
implements BehaviorDescription {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private PredicateImpl m_completionPredicate = null;
    private boolean m_initializedConditions = false;
    private List m_activationConditions = null;
    private List<Perform> m_performActivities = null;
    protected static final String COMPLETION_EXPRESSION_EDEFAULT = null;
    protected String completionExpression = COMPLETION_EXPRESSION_EDEFAULT;
    protected EList<VariableDeclaration> variableDeclarations;
    protected EList<BehaviorDescription> enclosedBehaviorDescriptions;
    protected EList<ExceptionHandler> exceptionHandlers;
    protected EList<CompletionHandler> completionHandlers;
    protected static final Boolean ROOT_EDEFAULT = Boolean.FALSE;
    protected Boolean root = ROOT_EDEFAULT;
    protected static final Boolean HAS_COMPLETION_EXPRESSION_EDEFAULT = Boolean.FALSE;
    protected Boolean hasCompletionExpression = HAS_COMPLETION_EXPRESSION_EDEFAULT;
    protected static final String PARTICIPANT_EDEFAULT = null;
    protected String participant = PARTICIPANT_EDEFAULT;

    @Override
    protected BehaviorDescriptionImpl getBehaviorDescriptionImpl() {
        return this;
    }

    @Override
    public String getFullyQualifiedName() {
        BehaviorDescriptionImpl bd;
        String ret = "";
        if (this.getParent() instanceof BehaviorTypeImpl && (bd = ((BehaviorTypeImpl)this.getParent()).getBehaviorDescriptionImpl()) != null) {
            ret = String.valueOf(bd.getFullyQualifiedName()) + ".";
        }
        ret = String.valueOf(ret) + this.getName();
        return ret;
    }

    @Override
    public void scheduled(InternalSession session) {
        super.scheduled(session);
        for (VariableDeclaration decl : this.getVariableDeclarations()) {
            if (decl.getSilent() == Boolean.TRUE) {
                session.silentVariable(decl.getName());
                continue;
            }
            session.observableVariable(decl.getName());
        }
    }

    @Override
    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getCompletionCondition() != null && session.getConfiguration().getEvaluateState()) {
            session.setCompletionPredicates(new Predicate[]{(XPathConditionImpl)this.getCompletionCondition()});
        }
        return super.processEvent(session, event);
    }

    @Override
    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        if (child instanceof ExceptionHandler) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Session " + session.hashCode() + " id=" + session.getId() + ": Exception handler child completed, so setting " + "status to completed-unsuccessfully");
            }
            session.setStatus(3);
            session.sessionCompleted();
            session.sessionFinished();
        } else if (child instanceof CompletionHandler) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Session " + session.hashCode() + " id=" + session.getId() + ": Completion handler child completed, so setting " + "status to closed");
            }
            session.setStatus(4);
            session.sessionCompleted();
        } else {
            super.childCompleted(session, child);
        }
    }

    @Override
    protected void completed(InternalSession session) throws ServiceException {
        session.setCompletionPredicates(null);
        session.clearTimeouts(this.getEndpointDescriptionURI());
        if (this.getCompletionHandlers().size() == 0) {
            session.setStatus(4);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Session " + session.hashCode() + " id=" + session.getId() + " completed, so setting status to closed");
            }
            session.sessionCompleted();
        } else if (session.getStatus() == 3) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Session " + session.hashCode() + " id=" + session.getId() + " completed unsuccessfully, so leaving status the same");
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Session " + session.hashCode() + " id=" + session.getId() + " completed, so setting status to completed-successfully");
            }
            session.setStatus(2);
        }
    }

    @Override
    protected void handleException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        session.setCompletionPredicates(null);
        session.sessionTerminated(exception);
        boolean exceptionHandled = false;
        int i = 0;
        while (!exceptionHandled && i < this.getExceptionHandlers().size()) {
            try {
                ExceptionHandlerImpl ehi = (ExceptionHandlerImpl)this.getExceptionHandlers().get(i);
                if (ehi.canProcess(session, exception)) {
                    exceptionHandled = ehi.process(session, exception);
                }
            }
            catch (Exception me) {
                logger.warning("Failed to process exception: " + me);
            }
            ++i;
        }
        if (!exceptionHandled) {
            if (session.isRoot()) {
                logger.info("Exception has not been handled '" + exception + "'");
                if (session.getConfiguration().getServiceTracker() != null) {
                    session.getConfiguration().getServiceTracker().unhandledException(session, exception.getExceptionType());
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(session.getId() + ": Exception '" + exception + "' was not handled - propagating to parent session");
            }
            this.completed(session);
        } else {
            session.terminatingExceptionHandled();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(session.getId() + ": Exception '" + exception + "' has been handled");
            }
        }
    }

    public boolean canTriggerException(InternalSession session, ServiceEvent se) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < this.getExceptionHandlers().size()) {
            try {
                ExceptionHandlerImpl ehi = (ExceptionHandlerImpl)this.getExceptionHandlers().get(i);
                ret = ehi.canProcess(session, se);
            }
            catch (Exception me) {
                logger.warning("Failed to process exception: " + me);
            }
            ++i;
        }
        return ret;
    }

    public void triggerException(InternalSession session, ServiceEvent se) {
        boolean exceptionHandled = false;
        int i = 0;
        while (!exceptionHandled && i < this.getExceptionHandlers().size()) {
            try {
                ExceptionHandlerImpl ehi = (ExceptionHandlerImpl)this.getExceptionHandlers().get(i);
                if (ehi.canProcess(session, se)) {
                    exceptionHandled = ehi.process(session, se);
                }
            }
            catch (Exception me) {
                logger.warning("Failed to process exception: " + me);
            }
            ++i;
        }
    }

    @Override
    protected List getEndOfSequenceMessageRelevantActivities(BehaviorTypeImpl scope) {
        Vector<SessionEndPredicateImpl> ret = new Vector<SessionEndPredicateImpl>();
        if (scope != this) {
            ret.add(new SessionEndPredicateImpl(this.getPerformingActivities()));
        }
        return ret;
    }

    @Override
    public BehaviorDescription getEnclosedBehaviorDescription(String name) {
        BehaviorDescription ret = null;
        Iterator iter = this.getEnclosedBehaviorDescriptions().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (BehaviorDescription)iter.next();
            if (ret.getName().equals(name)) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public VariableDeclaration getVariable(String name) {
        VariableDeclaration ret = null;
        Iterator iter = this.getVariableDeclarations().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (VariableDeclaration)iter.next();
            if (ret.getName().equals(name)) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public CompletionHandler getCompletionHandler(String name) {
        CompletionHandler ret = null;
        Iterator iter = this.getCompletionHandlers().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (CompletionHandler)iter.next();
            if (ret.getName().equals(name)) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean isRoot() {
        boolean ret = false;
        if (this.getRoot() == Boolean.TRUE && this.getParent() instanceof ServiceDescription) {
            ret = true;
        }
        return ret;
    }

    @Override
    protected boolean isBlockingActivity() {
        return true;
    }

    public PredicateImpl getCompletionCondition() {
        return this.m_completionPredicate;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        if (this.isSet(this.getCompletionExpression())) {
            XPathConditionImpl xpath = new XPathConditionImpl(this);
            xpath.setExpression(this.getCompletionExpression());
            xpath.setBlockingPredicate(this.isBlockingActivity());
            this.m_completionPredicate = xpath;
        }
        if (!this.m_initializedConditions) {
            this.m_initializedConditions = true;
            if (this.isRoot()) {
                List list = this.getNextMessageRelevantActivities(null, true, null, null);
                this.initializeConditions(list, this.getActivationConditions());
            }
        }
        super.initializeElement();
    }

    @Override
    public void cleanup() {
        if (this.getActivityTypes().size() == 0) {
            List<Perform> performs = this.getPerformingActivities();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Remove behavior description: " + this);
            }
            if (this.getParent() instanceof BehaviorDescription) {
                ((BehaviorDescription)this.getParent()).getEnclosedBehaviorDescriptions().remove((Object)this);
            } else if (this.getParent() instanceof ServiceDescriptionImpl) {
                ((ServiceDescriptionImpl)this.getParent()).getBehaviorDescriptions().remove((Object)this);
            }
            int i = performs.size() - 1;
            while (i >= 0) {
                PerformImpl perform = (PerformImpl)performs.get(i);
                perform.setBehaviorDescription(null);
                perform.cleanup();
                --i;
            }
            i = this.getCompletionHandlers().size() - 1;
            while (i >= 0) {
                CompletionHandlerImpl handler = (CompletionHandlerImpl)this.getCompletionHandlers().get(i);
                EList<Finalize> finalizes = handler.getFinalizeActivities();
                int j = finalizes.size() - 1;
                while (j >= 0) {
                    FinalizeImpl finalize = (FinalizeImpl)finalizes.get(j);
                    finalize.setCompletionHandler(null);
                    finalize.cleanup();
                    --j;
                }
                --i;
            }
        } else {
            int i = this.getEnclosedBehaviorDescriptions().size() - 1;
            while (i >= 0) {
                BehaviorDescription ebd = (BehaviorDescription)this.getEnclosedBehaviorDescriptions().get(i);
                if (ebd.getPerformingActivities().size() == 0) {
                    this.getEnclosedBehaviorDescriptions().remove((Object)ebd);
                }
                --i;
            }
        }
    }

    public List getActivationConditions() {
        if (this.m_activationConditions == null) {
            this.m_activationConditions = new Vector();
        }
        return this.m_activationConditions;
    }

    @Override
    public MessageActivity[] getInitialMessageActivities() {
        Object[] ret = null;
        List acts = this.getNextMessageRelevantActivities(null, true, null, null);
        Iterator iter = acts.iterator();
        Vector results = new Vector();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof MessageActivity)) continue;
            results.add(obj);
        }
        ret = new MessageActivity[results.size()];
        results.copyInto(ret);
        return ret;
    }

    @Override
    public boolean canBeInitiated() {
        boolean ret = false;
        if (this.getRoot() == Boolean.TRUE) {
            List acts = this.getNextMessageRelevantActivities(null, true, null, null);
            Iterator iter = acts.iterator();
            while (!ret && iter.hasNext()) {
                if (!(iter.next() instanceof SendImpl)) continue;
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public List<Perform> getPerformingActivities() {
        List<Perform> ret = this.m_performActivities;
        if (ret == null) {
            final Vector<Perform> list = new Vector<Perform>();
            ServiceDescription sdesc = this.getServiceDescription();
            if (sdesc != null) {
                sdesc.visit(new DefaultBehaviorVisitor(){

                    public void perform(Perform elem) {
                        if (elem.getBehaviorDescription() == BehaviorDescriptionImpl.this) {
                            list.add(elem);
                        }
                    }
                });
            }
            if (this.isInitialized()) {
                this.m_performActivities = list;
            }
            ret = list;
        }
        return ret;
    }

    @Override
    public void visit(BehaviorVisitor visitor) {
        visitor.behaviorDescriptionStart(this);
        super.visit(visitor);
        visitor.behaviorDescriptionEnd(this);
    }

    protected BehaviorDescriptionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.BEHAVIOR_DESCRIPTION;
    }

    @Override
    public EList<ExceptionHandler> getExceptionHandlers() {
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new EObjectContainmentEList(ExceptionHandler.class, (InternalEObject)this, 6);
        }
        return this.exceptionHandlers;
    }

    @Override
    public EList<CompletionHandler> getCompletionHandlers() {
        if (this.completionHandlers == null) {
            this.completionHandlers = new EObjectContainmentEList(CompletionHandler.class, (InternalEObject)this, 7);
        }
        return this.completionHandlers;
    }

    @Override
    public Boolean getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Boolean newRoot) {
        Boolean oldRoot = this.root;
        this.root = newRoot;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldRoot, (Object)this.root));
        }
    }

    @Override
    public Boolean getHasCompletionExpression() {
        return this.hasCompletionExpression;
    }

    @Override
    public void setHasCompletionExpression(Boolean newHasCompletionExpression) {
        Boolean oldHasCompletionExpression = this.hasCompletionExpression;
        this.hasCompletionExpression = newHasCompletionExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldHasCompletionExpression, (Object)this.hasCompletionExpression));
        }
    }

    @Override
    public String getParticipant() {
        return this.participant;
    }

    @Override
    public void setParticipant(String newParticipant) {
        String oldParticipant = this.participant;
        this.participant = newParticipant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldParticipant, (Object)this.participant));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getVariableDeclarations()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getEnclosedBehaviorDescriptions()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getExceptionHandlers()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getCompletionHandlers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getCompletionExpression();
            }
            case 4: {
                return this.getVariableDeclarations();
            }
            case 5: {
                return this.getEnclosedBehaviorDescriptions();
            }
            case 6: {
                return this.getExceptionHandlers();
            }
            case 7: {
                return this.getCompletionHandlers();
            }
            case 8: {
                return this.getRoot();
            }
            case 9: {
                return this.getHasCompletionExpression();
            }
            case 10: {
                return this.getParticipant();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setCompletionExpression((String)newValue);
                return;
            }
            case 4: {
                this.getVariableDeclarations().clear();
                this.getVariableDeclarations().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getEnclosedBehaviorDescriptions().clear();
                this.getEnclosedBehaviorDescriptions().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getExceptionHandlers().clear();
                this.getExceptionHandlers().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getCompletionHandlers().clear();
                this.getCompletionHandlers().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setRoot((Boolean)newValue);
                return;
            }
            case 9: {
                this.setHasCompletionExpression((Boolean)newValue);
                return;
            }
            case 10: {
                this.setParticipant((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setCompletionExpression(COMPLETION_EXPRESSION_EDEFAULT);
                return;
            }
            case 4: {
                this.getVariableDeclarations().clear();
                return;
            }
            case 5: {
                this.getEnclosedBehaviorDescriptions().clear();
                return;
            }
            case 6: {
                this.getExceptionHandlers().clear();
                return;
            }
            case 7: {
                this.getCompletionHandlers().clear();
                return;
            }
            case 8: {
                this.setRoot(ROOT_EDEFAULT);
                return;
            }
            case 9: {
                this.setHasCompletionExpression(HAS_COMPLETION_EXPRESSION_EDEFAULT);
                return;
            }
            case 10: {
                this.setParticipant(PARTICIPANT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return COMPLETION_EXPRESSION_EDEFAULT == null ? this.completionExpression != null : !COMPLETION_EXPRESSION_EDEFAULT.equals(this.completionExpression);
            }
            case 4: {
                return this.variableDeclarations != null && !this.variableDeclarations.isEmpty();
            }
            case 5: {
                return this.enclosedBehaviorDescriptions != null && !this.enclosedBehaviorDescriptions.isEmpty();
            }
            case 6: {
                return this.exceptionHandlers != null && !this.exceptionHandlers.isEmpty();
            }
            case 7: {
                return this.completionHandlers != null && !this.completionHandlers.isEmpty();
            }
            case 8: {
                return ROOT_EDEFAULT == null ? this.root != null : !ROOT_EDEFAULT.equals(this.root);
            }
            case 9: {
                return HAS_COMPLETION_EXPRESSION_EDEFAULT == null ? this.hasCompletionExpression != null : !HAS_COMPLETION_EXPRESSION_EDEFAULT.equals(this.hasCompletionExpression);
            }
            case 10: {
                return PARTICIPANT_EDEFAULT == null ? this.participant != null : !PARTICIPANT_EDEFAULT.equals(this.participant);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public EList<BehaviorDescription> getEnclosedBehaviorDescriptions() {
        if (this.enclosedBehaviorDescriptions == null) {
            this.enclosedBehaviorDescriptions = new EObjectContainmentEList(BehaviorDescription.class, (InternalEObject)this, 5);
        }
        return this.enclosedBehaviorDescriptions;
    }

    @Override
    public EList<VariableDeclaration> getVariableDeclarations() {
        if (this.variableDeclarations == null) {
            this.variableDeclarations = new EObjectContainmentEList(VariableDeclaration.class, (InternalEObject)this, 4);
        }
        return this.variableDeclarations;
    }

    @Override
    public String getCompletionExpression() {
        return this.completionExpression;
    }

    @Override
    public void setCompletionExpression(String newCompletionExpression) {
        String oldCompletionExpression = this.completionExpression;
        this.completionExpression = newCompletionExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldCompletionExpression, (Object)this.completionExpression));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (completionExpression: ");
        result.append(this.completionExpression);
        result.append(", root: ");
        result.append(this.root);
        result.append(", hasCompletionExpression: ");
        result.append(this.hasCompletionExpression);
        result.append(", participant: ");
        result.append(this.participant);
        result.append(')');
        return result.toString();
    }
}

