/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.service.DeferProcessingException;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorType;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.ServiceDescriptionImpl;
import org.pi4soa.service.behavior.xpath.BehaviorResolver;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.util.ServiceDescriptionManager;

public abstract class BehaviorTypeImpl
extends EObjectImpl
implements BehaviorType,
BehaviorElement,
XMLPrefixResolver {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    private boolean m_initialized = false;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    public static final String BEHAVIOR_RESOURCE = "behavior";

    protected void validateBehaviorType(ModelListener l, ValidationContext context) throws ValidationException {
        this.validateSyntax(l, context);
        for (Object obj : this.eContents()) {
            if (!(obj instanceof BehaviorTypeImpl)) continue;
            ((BehaviorTypeImpl)obj).validateBehaviorType(l, context);
        }
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        if (this.isSet(this.getName()) && this.getName().indexOf(32) != -1) {
            l.report((Object)this, BehaviorTypeImpl.getMessage("_INVALID_CHAR", new Object[]{"name", " "}), 2);
        }
        EList attrs = this.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.isRequired() && attr.getEType().getInstanceClass() == String.class && !attr.isMany()) {
                try {
                    String val = (String)this.eGet((EStructuralFeature)attr);
                    if (!this.isSet(val)) {
                        l.report((Object)this, BehaviorTypeImpl.getMessage("_REQUIRED_ATTRIBUTE", new Object[]{NamesUtil.getDisplayName((String)attr.getName())}), 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        EList refs = this.eClass().getEAllReferences();
        int i2 = 0;
        while (i2 < refs.size()) {
            EReference ref = (EReference)refs.get(i2);
            if (ref.isMany() && ref.getLowerBound() > 0) {
                List list = (List)this.eGet((EStructuralFeature)ref);
                if (list.size() < ref.getLowerBound()) {
                    l.report((Object)this, BehaviorTypeImpl.getMessage("_TOO_FEW_REFERENCES", new Object[]{NamesUtil.getDisplayName((String)ref.getName()), new Integer(ref.getLowerBound()), ref.getEType().getName()}), 2);
                }
            } else if (ref.isRequired() && !this.eIsSet((EStructuralFeature)ref)) {
                l.report((Object)this, BehaviorTypeImpl.getMessage("_REQUIRED_REFERENCE", new Object[]{NamesUtil.getDisplayName((String)ref.getName())}), 2);
            }
            ++i2;
        }
    }

    public String getId() {
        return ServiceDescriptionManager.getURIFragment(this);
    }

    public void scheduled(InternalSession session) {
    }

    public boolean process(InternalSession session, ServiceEvent event) throws ServiceException, OutOfSequenceMessageException {
        boolean postpone;
        boolean processed;
        boolean ret;
        block16: {
            ret = false;
            processed = false;
            postpone = false;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Process behavior type: " + this + " session=" + session + " event=" + event);
            }
            try {
                if (this.canProcess(session, event)) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Can process behavior type: " + this);
                    }
                    ret = this.processEvent(session, event);
                    processed = true;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Processed event for " + this + " returned " + ret);
                    }
                } else if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Cannot process behavior type: " + this);
                }
            }
            catch (LockedInformationException lie) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Locked information '" + lie + "' for behavior type: " + this + " session=" + session);
                }
                postpone = true;
            }
            catch (DeferProcessingException dpe) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Defer processing '" + dpe + "' for behavior type: " + this + " session=" + session);
                }
                postpone = true;
            }
            catch (UnresolvedConstraintException uie) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Unresolved constraint '" + uie + "' for behavior type: " + this + " session=" + session);
                }
                if (this.handlesUnresolvedConstraint()) break block16;
                ExceptionEvent evt = new ExceptionEvent(uie.getExceptionType());
                logger.severe("Converting unresolved constraint exception into exception event");
                if (session.getConfiguration().getServiceTracker() != null) {
                    session.getConfiguration().getServiceTracker().error(session, uie.getMessage(), uie);
                }
                this.handleException(session, evt);
                processed = true;
            }
        }
        if (!postpone && !processed && this.shouldSkipNode(session, event)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Skipping behavior type: " + this);
            }
            this.completed(session);
            this.unschedule(session);
        }
        return ret;
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        return true;
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException, LockedInformationException, OutOfSequenceMessageException {
        this.unschedule(session);
        return false;
    }

    protected void unschedule(InternalSession session) {
        session.unschedule(this);
    }

    protected boolean shouldSkipNode(InternalSession session, ServiceEvent event) throws ServiceException {
        return false;
    }

    protected void completed(InternalSession session) throws ServiceException {
        if (this.getParentImpl() != null) {
            this.getParentImpl().childCompleted(session, this);
        }
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
    }

    protected void handleException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        if (this.getParentImpl() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Passing exception '" + exception + "' to parent '" + this.getParentImpl() + "'");
            }
            this.getParentImpl().handleException(session, exception);
        }
    }

    protected boolean handlesUnresolvedConstraint() {
        return false;
    }

    public BehaviorType getParent() {
        return this.getParentImpl();
    }

    protected BehaviorTypeImpl getParentImpl() {
        BehaviorTypeImpl ret = null;
        if (this.eContainer() instanceof BehaviorTypeImpl) {
            ret = (BehaviorTypeImpl)this.eContainer();
        }
        return ret;
    }

    protected void cleanupElements() throws ServiceException {
        int size = this.eContents().size();
        int pos = 0;
        while (pos < this.eContents().size()) {
            Object obj = this.eContents().get(pos);
            if (obj instanceof BehaviorTypeImpl) {
                ((BehaviorTypeImpl)obj).cleanupElements();
            }
            if (this.eContents().size() == size && this.eContents().get(pos) == obj) {
                ++pos;
                continue;
            }
            pos = 0;
            size = this.eContents().size();
        }
        this.cleanup();
    }

    protected void cleanup() {
    }

    protected BehaviorDescriptionImpl getBehaviorDescriptionImpl() {
        if (this.getParentImpl() != null) {
            return this.getParentImpl().getBehaviorDescriptionImpl();
        }
        return null;
    }

    public BehaviorDescription getEnclosingBehaviorDescription() {
        return this.getBehaviorDescriptionImpl();
    }

    protected ServiceDescriptionImpl getServiceDescriptionImpl() {
        if (this.getParentImpl() != null) {
            return this.getParentImpl().getServiceDescriptionImpl();
        }
        return null;
    }

    public ServiceDescription getServiceDescription() {
        return this.getServiceDescriptionImpl();
    }

    protected boolean isChoice() {
        return false;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
        ExtensionException exception = null;
        for (Object obj : this.eContents()) {
            try {
                if (!(obj instanceof BehaviorTypeImpl)) continue;
                ((BehaviorTypeImpl)obj).initialize(resolver);
            }
            catch (ExtensionException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void initialize() throws ServiceException {
        if (!this.m_initialized) {
            this.m_initialized = true;
            int size = this.eContents().size();
            int pos = 0;
            while (pos < this.eContents().size()) {
                Object obj = this.eContents().get(pos);
                if (obj instanceof BehaviorTypeImpl) {
                    ((BehaviorTypeImpl)obj).initialize();
                }
                if (this.eContents().size() == size && this.eContents().get(pos) == obj) {
                    ++pos;
                    continue;
                }
                pos = 0;
                size = this.eContents().size();
            }
            this.initializeElement();
        }
    }

    protected void initializeElement() throws ServiceException {
    }

    public void visit(BehaviorVisitor visitor) {
        for (Object obj : this.eContents()) {
            if (!(obj instanceof BehaviorType)) continue;
            ((BehaviorType)obj).visit(visitor);
        }
    }

    protected boolean isSet(String value) {
        boolean ret = false;
        if (value != null && value.trim().length() > 0) {
            ret = true;
        }
        return ret;
    }

    public String getNamespace(String prefix) {
        ServiceDescriptionImpl sd;
        String ret = null;
        if (prefix != null && (ret = BehaviorResolver.getInstance().getNamespace(prefix)) == null && (sd = this.getServiceDescriptionImpl()) != null) {
            ret = sd.getNameSpaceURIForPrefix(prefix);
        }
        return ret;
    }

    public String getPrefix(String namespace) {
        return null;
    }

    protected static String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)BEHAVIOR_RESOURCE, (String)key, (Object[])params);
    }

    protected BehaviorTypeImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.BEHAVIOR_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }
}

