/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.ChannelDeclaration;
import org.pi4soa.service.behavior.Identity;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.UsageType;
import org.pi4soa.service.behavior.impl.VariableDeclarationImpl;
import org.pi4soa.service.util.BehaviorTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelDeclarationImpl
extends VariableDeclarationImpl
implements ChannelDeclaration {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedFQChannelType = null;
    private boolean m_enableFQNCaching = false;
    protected static final String CHANNEL_TYPE_EDEFAULT = null;
    protected String channelType = CHANNEL_TYPE_EDEFAULT;
    protected ServiceType serviceType;
    protected static final UsageType USAGE_EDEFAULT = UsageType.DISTINCT;
    protected UsageType usage = USAGE_EDEFAULT;
    protected EList<Identity> identities;

    @Override
    public String getFullyQualifiedChannelType() {
        if ((this.m_cachedFQChannelType == null || !this.m_enableFQNCaching) && NamesUtil.isSet((String)this.getChannelType())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getChannelType(), this);
            String localpart = XMLUtils.getLocalname((String)this.getChannelType());
            this.m_cachedFQChannelType = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                if (this.m_enableFQNCaching) {
                    logger.fine("Caching qname=" + this.m_cachedFQChannelType + " for " + this);
                } else {
                    logger.fine("Returning qname=" + this.m_cachedFQChannelType + " for " + this);
                }
            }
        }
        return this.m_cachedFQChannelType;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
    }

    @Override
    public Identity getIdentity(String name) {
        Identity ret = null;
        for (Identity id : this.getIdentities()) {
            if (!id.getIdentityName().equals(name)) continue;
            ret = id;
        }
        return ret;
    }

    protected ChannelDeclarationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.CHANNEL_DECLARATION;
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public void setChannelType(String newChannelType) {
        String oldChannelType = this.channelType;
        this.channelType = newChannelType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldChannelType, (Object)this.channelType));
        }
    }

    @Override
    public ServiceType getServiceType() {
        if (this.serviceType != null && this.serviceType.eIsProxy()) {
            InternalEObject oldServiceType = (InternalEObject)this.serviceType;
            this.serviceType = (ServiceType)this.eResolveProxy(oldServiceType);
            if (this.serviceType != oldServiceType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldServiceType, (Object)this.serviceType));
            }
        }
        return this.serviceType;
    }

    public ServiceType basicGetServiceType() {
        return this.serviceType;
    }

    @Override
    public void setServiceType(ServiceType newServiceType) {
        ServiceType oldServiceType = this.serviceType;
        this.serviceType = newServiceType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldServiceType, (Object)this.serviceType));
        }
    }

    @Override
    public UsageType getUsage() {
        return this.usage;
    }

    @Override
    public void setUsage(UsageType newUsage) {
        UsageType oldUsage = this.usage;
        UsageType usageType = this.usage = newUsage == null ? USAGE_EDEFAULT : newUsage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldUsage, (Object)this.usage));
        }
    }

    @Override
    public EList<Identity> getIdentities() {
        if (this.identities == null) {
            this.identities = new EObjectContainmentEList(Identity.class, (InternalEObject)this, 9);
        }
        return this.identities;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getIdentities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getChannelType();
            }
            case 7: {
                if (resolve) {
                    return this.getServiceType();
                }
                return this.basicGetServiceType();
            }
            case 8: {
                return this.getUsage();
            }
            case 9: {
                return this.getIdentities();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setChannelType((String)newValue);
                return;
            }
            case 7: {
                this.setServiceType((ServiceType)newValue);
                return;
            }
            case 8: {
                this.setUsage((UsageType)((Object)newValue));
                return;
            }
            case 9: {
                this.getIdentities().clear();
                this.getIdentities().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setChannelType(CHANNEL_TYPE_EDEFAULT);
                return;
            }
            case 7: {
                this.setServiceType(null);
                return;
            }
            case 8: {
                this.setUsage(USAGE_EDEFAULT);
                return;
            }
            case 9: {
                this.getIdentities().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return CHANNEL_TYPE_EDEFAULT == null ? this.channelType != null : !CHANNEL_TYPE_EDEFAULT.equals(this.channelType);
            }
            case 7: {
                return this.serviceType != null;
            }
            case 8: {
                return this.usage != USAGE_EDEFAULT;
            }
            case 9: {
                return this.identities != null && !this.identities.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (channelType: ");
        result.append(this.channelType);
        result.append(", usage: ");
        result.append((Object)this.usage);
        result.append(')');
        return result.toString();
    }
}

