/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.ExceptionUtil;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.ChoiceImpl;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.ResumableBehaviorElement;
import org.pi4soa.service.session.internal.SessionConfiguration;

public class ChoiceDelayedEvaluation
implements ResumableBehaviorElement,
Externalizable {
    private static final long serialVersionUID = 8918642110318369370L;
    private static final int SERIALIZATION_VERSION = 1;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private transient ChoiceImpl m_choice = null;
    private String m_choiceId = null;
    private Vector m_behaviorElements = new Vector();

    public ChoiceDelayedEvaluation() {
    }

    public ChoiceDelayedEvaluation(ChoiceImpl choice) {
        this.m_choice = choice;
        this.m_choiceId = this.m_choice.getId();
    }

    public ChoiceImpl getChoiceImpl() {
        return this.m_choice;
    }

    public void addBehaviorElement(BehaviorElement be) {
        this.m_behaviorElements.add(be);
    }

    public List getBehaviorElements() {
        return this.m_behaviorElements;
    }

    public String getId() {
        return String.valueOf(this.getClass().getSimpleName()) + ":" + this.m_choiceId;
    }

    public void scheduled(InternalSession session) {
    }

    public boolean process(InternalSession session, ServiceEvent event) throws ServiceException {
        boolean choiceMade = false;
        int i = 0;
        while (!choiceMade && i < this.getBehaviorElements().size()) {
            block11: {
                BehaviorElement ati = (BehaviorElement)this.getBehaviorElements().get(i);
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Evaluate delayed choice=" + ati);
                    }
                    if (ati.canProcess(session, event)) {
                        choiceMade = true;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Delayed choice made=" + ati);
                        }
                        session.schedule(ati);
                    } else {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Remove delayed choice, as returned false=" + ati);
                        }
                        this.getBehaviorElements().remove(ati);
                    }
                }
                catch (UnresolvedConstraintException unresolvedConstraintException) {
                    if (!logger.isLoggable(Level.FINEST)) break block11;
                    logger.finest("Retain delayed choice=" + ati);
                }
            }
            ++i;
        }
        if (choiceMade) {
            session.unschedule(this);
        } else if (this.getBehaviorElements().size() == 0) {
            session.unschedule(this);
            ExceptionEvent exc = new ExceptionEvent(ExceptionUtil.getExceptionQName((String)"http://www.pi4soa.org/service", (String)"ChoiceElementNotSelected"));
            this.m_choice.handleException(session, exc);
        }
        return false;
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException {
        return true;
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
    }

    public void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Resume choice for '" + sdesc + "': Locating choice " + "element for id '" + this.m_choiceId + "'");
        }
        if (this.m_choiceId != null) {
            this.m_choice = (ChoiceImpl)config.getSessionComponentResolver().getBehaviorElement(sdesc, this.m_choiceId);
        }
        int i = this.m_behaviorElements.size() - 1;
        while (i >= 0) {
            Object obj = this.m_behaviorElements.get(i);
            if (obj instanceof String) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.fine("Resume choice for '" + sdesc + "': Locating behavior " + "element for id '" + obj + "'");
                }
                BehaviorElement elem = config.getSessionComponentResolver().getBehaviorElement(sdesc, (String)obj);
                this.m_behaviorElements.remove(i);
                if (elem != null) {
                    this.m_behaviorElements.insertElementAt(elem, i);
                } else {
                    throw new ServiceException("Failed to resume session for '" + sdesc + "': Unable to locate behavior " + "element for id '" + obj + "'");
                }
            }
            --i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.m_choiceId);
        out.writeInt(this.m_behaviorElements.size());
        int i = 0;
        while (i < this.m_behaviorElements.size()) {
            BehaviorElement be = (BehaviorElement)this.m_behaviorElements.get(i);
            out.writeUTF(be.getId());
            ++i;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_choiceId = in.readUTF();
            int num = in.readInt();
            int i = 0;
            while (i < num) {
                this.m_behaviorElements.add(in.readUTF());
                ++i;
            }
        }
    }
}

