/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.common.util.ExceptionUtil;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.Choice;
import org.pi4soa.service.behavior.MessageActivity;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.ChoiceDelayedEvaluation;
import org.pi4soa.service.behavior.impl.LookaheadMessageImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;

public class ChoiceImpl
extends StructuralTypeImpl
implements Choice {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private int m_nonObservableElements = 0;

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException {
        boolean choiceMade = false;
        ChoiceDelayedEvaluation delayedEvaluation = null;
        int i = 0;
        while (!choiceMade && i < this.getActivityTypes().size()) {
            BehaviorElement be = (BehaviorElement)this.getActivityTypes().get(i);
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Evaluate choice=" + be);
                }
                if (be.canProcess(session, event)) {
                    choiceMade = true;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Choice made=" + be);
                    }
                    session.schedule(be);
                }
            }
            catch (UnresolvedConstraintException unresolvedConstraintException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Add to delayed evaluation choice=" + be);
                }
                if (delayedEvaluation == null) {
                    delayedEvaluation = new ChoiceDelayedEvaluation(this);
                }
                delayedEvaluation.addBehaviorElement(be);
            }
            ++i;
        }
        if (choiceMade) {
            this.unschedule(session);
        } else if (session.getConfiguration().isMonitoring() && this.isOptional() && this.shouldSkipNode(session, event)) {
            this.completed(session);
            this.unschedule(session);
        } else if (delayedEvaluation != null) {
            if (delayedEvaluation.getBehaviorElements().size() < this.getActivityTypes().size()) {
                session.schedule(delayedEvaluation);
                this.unschedule(session);
            }
        } else {
            this.unschedule(session);
            ExceptionEvent exc = new ExceptionEvent(ExceptionUtil.getExceptionQName((String)"http://www.pi4soa.org/service", (String)"ChoiceElementNotSelected"));
            this.handleException(session, exc);
        }
        return false;
    }

    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        for (Object elem : this.getActivityTypes()) {
            if (!(elem instanceof StructuralTypeImpl)) continue;
            StructuralTypeImpl stype = (StructuralTypeImpl)elem;
            List preconds = stype.getPreConditions();
            List mas = stype.getNextMessageRelevantActivities(null, true, stype, null);
            if (preconds == null || mas == null) continue;
            int i = preconds.size() - 1;
            while (i >= 0) {
                Object precond = preconds.get(i);
                MessageActivity prema = null;
                if (precond instanceof LookaheadMessageImpl && !mas.contains(prema = ((LookaheadMessageImpl)precond).getMessageActivity())) {
                    boolean f_associated = false;
                    int j = 0;
                    while (!f_associated && j < this.getActivityTypes().size()) {
                        Object path = this.getActivityTypes().get(j);
                        if (path instanceof StructuralTypeImpl && path != stype && this.isAssociatedWithPath((StructuralTypeImpl)path, prema)) {
                            f_associated = true;
                        }
                        ++j;
                    }
                    if (f_associated) {
                        preconds.remove(precond);
                    }
                }
                --i;
            }
        }
    }

    protected boolean isAssociatedWithPath(StructuralTypeImpl scope, MessageActivity ma) {
        boolean ret = false;
        List preconds = scope.getNextMessageRelevantActivities(null, true, scope, null);
        if (preconds != null) {
            ret = preconds.contains(ma);
        }
        return ret;
    }

    protected void initializePostConditions() {
        if (this.getParentImpl() instanceof ActivityTypeImpl) {
            List list = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, null, null);
            int i = 0;
            while (i < this.getActivityTypes().size()) {
                Object obj = this.getActivityTypes().get(i);
                if (obj instanceof StructuralTypeImpl) {
                    StructuralTypeImpl st = (StructuralTypeImpl)obj;
                    boolean optional = true;
                    List pres = st.getPreConditions();
                    int j = 0;
                    while (optional && j < pres.size()) {
                        Object pred = pres.get(j);
                        if (pred instanceof LookaheadMessageImpl && (list == null || !list.contains(((LookaheadMessageImpl)pred).getMessageActivity()))) {
                            optional = false;
                        }
                        ++j;
                    }
                    if (optional) {
                        ++this.m_nonObservableElements;
                    }
                }
                ++i;
            }
            if (this.isOptional()) {
                this.initializeConditions(list, this.getPostConditions());
            }
        }
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        this.completed(session);
    }

    protected boolean shouldSkipNode(InternalSession session, ServiceEvent event) throws ServiceException {
        boolean ret = false;
        ret = this.evaluatePostConditions(session, event);
        return ret;
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        if (after != null) {
            if (this.getParentImpl() instanceof ActivityTypeImpl && !this.isCheckingPreConditions() && scope != this) {
                ret = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path);
            }
        } else {
            int i = 0;
            while (i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                List sublist = act.getNextMessageRelevantActivities(null, false, scope, path);
                if (sublist == null) {
                    logger.warning("Choice element [" + act.getId() + "] does not contain any lookahead message activities");
                } else if (ret == null) {
                    ret = sublist;
                } else {
                    int j = 0;
                    while (j < sublist.size()) {
                        if (!ret.contains(sublist.get(j))) {
                            ret.add(sublist.get(j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (ret == null) {
                logger.warning("Choice [" + this.getId() + "] does not contain any lookahead message activities");
            }
        }
        return ret;
    }

    protected boolean isChoice() {
        return true;
    }

    public boolean isSequentialGroupingConstruct() {
        return false;
    }

    public boolean isOptional() {
        return this.getNumberOfNonObservableElements() > 0;
    }

    protected int getNumberOfNonObservableElements() {
        return this.m_nonObservableElements;
    }

    public boolean isPredicateExtensionRequired() {
        return false;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.choiceStart(this);
        super.visit(visitor);
        visitor.choiceEnd(this);
    }

    protected ChoiceImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.CHOICE;
    }
}

