/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.CompletionHandler;
import org.pi4soa.service.behavior.Finalize;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.SessionEndPredicateImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.InternalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionHandlerImpl
extends StructuralTypeImpl
implements CompletionHandler {
    protected EList<Finalize> finalizeActivities;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");

    @Override
    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return false;
    }

    @Override
    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                this.completed(session);
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Completion handler could not find completed child");
        }
    }

    @Override
    protected List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List<SessionEndPredicateImpl> ret = null;
        int pos = 0;
        if (after != null && (pos = this.getActivityTypes().indexOf((Object)after)) != -1) {
            ++pos;
        }
        if (pos != -1) {
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (ret == null) {
                ret = new Vector<SessionEndPredicateImpl>();
                if (scope != this) {
                    ret.add(new SessionEndPredicateImpl((List)this.getFinalizeActivities()));
                }
            }
        }
        return ret;
    }

    @Override
    public void visit(BehaviorVisitor visitor) {
        visitor.completionHandlerStart(this);
        super.visit(visitor);
        visitor.completionHandlerEnd(this);
    }

    protected CompletionHandlerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.COMPLETION_HANDLER;
    }

    @Override
    public EList<Finalize> getFinalizeActivities() {
        if (this.finalizeActivities == null) {
            this.finalizeActivities = new EObjectWithInverseResolvingEList(Finalize.class, (InternalEObject)this, 3, 2);
        }
        return this.finalizeActivities;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getFinalizeActivities()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getFinalizeActivities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getFinalizeActivities();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.finalizeActivities != null && !this.finalizeActivities.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

