/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.Conditional;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.ChoiceImpl;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.behavior.impl.XPathConditionImpl;
import org.pi4soa.service.session.internal.InternalSession;

public class ConditionalImpl
extends StructuralTypeImpl
implements Conditional {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private PredicateImpl m_predicate = null;
    protected static final String EXPRESSION_EDEFAULT = null;
    protected String expression = EXPRESSION_EDEFAULT;

    public PredicateImpl getCondition() {
        return this.m_predicate;
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return false;
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                this.completed(session);
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Conditional could not find completed child");
        }
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        int pos = 0;
        if (after != null) {
            pos = this.getActivityTypes().indexOf((Object)after);
            if (pos != -1) {
                ++pos;
            } else {
                logger.warning("Conditional [" + this.getId() + "] does not contain activity: " + after);
            }
        }
        if (pos != -1) {
            List skiplist;
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (!(after != null && ret != null || this.isChoiceElement() || local || !(this.getParentImpl() instanceof ActivityTypeImpl) || this.isCheckingPreConditions() || scope == this || (skiplist = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path)) == null)) {
                if (ret == null) {
                    ret = skiplist;
                } else {
                    int i2 = 0;
                    while (i2 < skiplist.size()) {
                        if (!ret.contains(skiplist.get(i2))) {
                            ret.add(skiplist.get(i2));
                        }
                        ++i2;
                    }
                }
            }
            if (ret == null) {
                logger.fine("Conditional [" + this.getId() + "] does not contain any lookahead message activities");
            }
        }
        return ret;
    }

    protected boolean isChoiceElement() {
        return this.getParent() instanceof ChoiceImpl;
    }

    public boolean isConditionalGroupingConstruct() {
        return true;
    }

    public boolean isConditionObservable() {
        return this.getCondition() != null;
    }

    protected void initializeElement() throws ServiceException {
        if (this.isSet(this.getExpression())) {
            XPathConditionImpl xpath = new XPathConditionImpl(this);
            xpath.setExpression(this.getExpression());
            xpath.setBlockingPredicate(this.isBlockingActivity());
            this.m_predicate = xpath;
            this.getPreConditions().add(xpath);
        }
        super.initializeElement();
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.conditionalStart(this);
        super.visit(visitor);
        visitor.conditionalEnd(this);
    }

    protected ConditionalImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.CONDITIONAL;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String newExpression) {
        String oldExpression = this.expression;
        this.expression = newExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldExpression, (Object)this.expression));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getExpression();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setExpression((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setExpression(EXPRESSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return EXPRESSION_EDEFAULT == null ? this.expression != null : !EXPRESSION_EDEFAULT.equals(this.expression);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (expression: ");
        result.append(this.expression);
        result.append(')');
        return result.toString();
    }
}

