/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Message;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.ExceptionHandler;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.SessionEndPredicateImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.util.BehaviorTypeUtil;

public class ExceptionHandlerImpl
extends StructuralTypeImpl
implements ExceptionHandler {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedFQExceptionType = null;
    private boolean m_enableFQNCaching = false;
    protected static final String EXCEPTION_TYPE_EDEFAULT = null;
    protected String exceptionType = EXCEPTION_TYPE_EDEFAULT;

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (NamesUtil.isSet((String)this.getExceptionType())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getExceptionType(), this);
            if (namespace == null) {
                l.report((Object)this, ExceptionHandlerImpl.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getExceptionType()}), 2);
            } else if (context != null) {
                String localpart = XMLUtils.getLocalname((String)this.getExceptionType());
                if (!context.getSchemaManager().isValidType(namespace, localpart)) {
                    l.report((Object)this, ExceptionHandlerImpl.getMessage("_UNKNOWN_TYPE_IN_NAMESPACE", new Object[]{localpart, namespace}), 2);
                }
            }
        }
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, ServiceException {
        boolean ret = false;
        if (event instanceof ExceptionEvent) {
            ExceptionEvent exc = (ExceptionEvent)event;
            if (this.getFullyQualifiedExceptionType() == null || exc.getExceptionType().equals(this.getFullyQualifiedExceptionType())) {
                ret = true;
            }
        } else if (event instanceof Message) {
            List list = this.getNextMessageRelevantActivities(null, false, this, null);
            int i = 0;
            while (!ret && i < list.size()) {
                BehaviorElement be = (BehaviorElement)list.get(i);
                ret = be.canProcess(session, event);
                ++i;
            }
        }
        return ret;
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return true;
    }

    protected boolean isConditionalStructure() {
        return true;
    }

    protected boolean shouldSkipNode(InternalSession session, ServiceEvent event) {
        return true;
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                this.completed(session);
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Exception handler could not find completed child");
        }
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List<SessionEndPredicateImpl> ret = null;
        int pos = 0;
        if (after != null && (pos = this.getActivityTypes().indexOf((Object)after)) != -1) {
            ++pos;
        }
        if (pos != -1) {
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (ret == null) {
                ret = new Vector<SessionEndPredicateImpl>();
                if (this.getEnclosingBehaviorDescription() != null && scope != this) {
                    ret.add(new SessionEndPredicateImpl(this.getEnclosingBehaviorDescription().getPerformingActivities()));
                }
            }
        }
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.exceptionHandlerStart(this);
        super.visit(visitor);
        visitor.exceptionHandlerEnd(this);
    }

    public String getFullyQualifiedExceptionType() {
        if ((this.m_cachedFQExceptionType == null || !this.m_enableFQNCaching) && NamesUtil.isSet((String)this.getExceptionType())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getExceptionType(), this);
            String localpart = XMLUtils.getLocalname((String)this.getExceptionType());
            this.m_cachedFQExceptionType = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                if (this.m_enableFQNCaching) {
                    logger.fine("Caching qname=" + this.m_cachedFQExceptionType + " for " + this);
                } else {
                    logger.fine("Returning qname=" + this.m_cachedFQExceptionType + " for " + this);
                }
            }
        }
        return this.m_cachedFQExceptionType;
    }

    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
    }

    protected ExceptionHandlerImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.EXCEPTION_HANDLER;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String newExceptionType) {
        String oldExceptionType = this.exceptionType;
        this.exceptionType = newExceptionType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldExceptionType, (Object)this.exceptionType));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getExceptionType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setExceptionType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setExceptionType(EXCEPTION_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return EXCEPTION_TYPE_EDEFAULT == null ? this.exceptionType != null : !EXCEPTION_TYPE_EDEFAULT.equals(this.exceptionType);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (exceptionType: ");
        result.append(this.exceptionType);
        result.append(')');
        return result.toString();
    }
}

