/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.Identity;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.Message;
import org.pi4soa.service.MutableMessage;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.ChannelDeclaration;
import org.pi4soa.service.behavior.IdentityType;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageActivity;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.VariableDeclaration;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.extensions.ActivityExtension;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageActivityImpl
extends ActivityTypeImpl
implements MessageActivity {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    protected ChannelDeclaration channel;
    protected VariableDeclaration variable;
    protected static final String VARIABLE_PART_EDEFAULT = null;
    protected String variablePart = VARIABLE_PART_EDEFAULT;
    protected MessageDefinition messageDefinition;

    @Override
    public String getOperationName() {
        String ret = null;
        if (this.getMessageDefinition() != null && this.getMessageDefinition().getOperationDefinition() != null) {
            ret = this.getMessageDefinition().getOperationDefinition().getName();
        }
        return ret;
    }

    @Override
    public String getFaultName() {
        String ret = null;
        if (this.getMessageDefinition() != null) {
            ret = this.getMessageDefinition().getFaultName();
        }
        return ret;
    }

    @Override
    public String getFullyQualifiedFaultName() {
        String ret = null;
        if (this.getMessageDefinition() != null) {
            ret = this.getMessageDefinition().getFullyQualifiedFaultName();
        }
        return ret;
    }

    protected String getMessageType() {
        String ret = null;
        if (this.getMessageDefinition() != null && this.getMessageDefinition().getInformationType() != null && !NamesUtil.isSet((String)(ret = this.getMessageDefinition().getInformationType().getFullyQualifiedType()))) {
            ret = this.getMessageDefinition().getInformationType().getFullyQualifiedElement();
        }
        return ret;
    }

    @Override
    public MessageClassification getClassification() {
        MessageClassification ret = MessageClassification.REQUEST;
        if (this.getMessageDefinition() != null) {
            ret = this.getMessageDefinition().getClassification();
        }
        return ret;
    }

    @Override
    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException {
        boolean ret = false;
        if (event instanceof ExceptionEvent) {
            event = ((ExceptionEvent)event).getMessage();
        }
        if (event instanceof Message) {
            Message mesg = (Message)event;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Check match: " + mesg + " against " + this);
            }
            if (this.isInitialMatch(mesg)) {
                Channel channel = null;
                if (this.getChannel() != null) {
                    channel = session.getChannel(this.getChannel().getName(), this.getChannel().getFullyQualifiedChannelType(), this.getChannel().getInformationType().getFullyQualifiedType(), this.getChannel().getServiceType().getFullyQualifiedName());
                }
                if (channel != null && this.isFullMatch(mesg, channel, session)) {
                    ret = true;
                    if (mesg instanceof MutableMessage) {
                        if (mesg.getOperationName() == null) {
                            ((MutableMessage)mesg).setOperationName(this.getOperationName());
                        }
                        if (mesg.getFaultName() == null) {
                            ((MutableMessage)mesg).setFaultName(this.getFullyQualifiedFaultName());
                        }
                        if (mesg.getServiceType() == null) {
                            ((MutableMessage)mesg).setServiceType(this.getChannel().getServiceType().getFullyQualifiedName());
                        }
                    }
                } else if (channel != null) {
                    logger.fine("Message '" + event + "' was not a full " + "match against: " + this);
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Message '" + event + "' was not an initial " + "match against: " + this);
            }
        }
        return ret;
    }

    protected void completeMessage(Message mesg) {
        if (mesg instanceof MutableMessage) {
            if (mesg.getOperationName() == null) {
                ((MutableMessage)mesg).setOperationName(this.getOperationName());
            }
            if (mesg.getFaultName() == null) {
                ((MutableMessage)mesg).setFaultName(this.getFullyQualifiedFaultName());
            }
            if (mesg.getServiceType() == null) {
                ((MutableMessage)mesg).setServiceType(this.getChannel().getServiceType().getFullyQualifiedName());
            }
        }
    }

    protected boolean isInitialMatch(Message mesg) {
        boolean ret = false;
        if (mesg != null && (!this.isSet(mesg.getServiceType()) || mesg.getServiceType().equals(this.getChannel().getServiceType().getFullyQualifiedName())) && this.isSignatureMatch(mesg) && this.isMessageClassificationMatch(mesg)) {
            ret = true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("isInitiatMatch ret=" + ret);
        }
        return ret;
    }

    protected boolean isSignatureMatch(Message mesg) {
        boolean ret = true;
        if (mesg.isRPCStyle() && mesg.getOperationName() != null) {
            ret = mesg.getOperationName().equals(this.getOperationName());
            if (ret) {
                ret = this.isFaultMatch(mesg);
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("isSignatureMatch operation name mismatch '" + mesg.getOperationName() + "' against '" + this.getOperationName() + "'");
            }
        } else if (!NamesUtil.isSet((String)mesg.getType())) {
            ret = false;
        }
        if (ret && NamesUtil.isSet((String)mesg.getType())) {
            ret = mesg.getType().equals(this.getMessageType());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Match message type '" + mesg.getType() + "' to activity value '" + this.getMessageType() + "' = " + ret);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("isSignatureMatch ret=" + ret);
        }
        return ret;
    }

    public boolean isMessageClassificationMatch(Message mesg) {
        boolean ret = false;
        if (mesg != null && (!mesg.isRPCStyle() || mesg.isRequest() && this.getClassification() == MessageClassification.REQUEST || !mesg.isRequest() && (this.getClassification() == MessageClassification.RESPONSE || this.getClassification() == MessageClassification.NOTIFICATION))) {
            ret = true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("isMessageClassificatonMatch: request=" + mesg.isRequest() + " classification=" + this.getClassification().getName() + " ret=" + ret);
        }
        return ret;
    }

    public boolean isFaultMatch(Message mesg) {
        boolean ret = false;
        if (mesg != null) {
            String mesgfn = mesg.getFaultName();
            String fqn = this.getFullyQualifiedFaultName();
            if (!NamesUtil.isSet((String)mesgfn) && !NamesUtil.isSet((String)fqn)) {
                ret = true;
            } else if (NamesUtil.isSet((String)mesgfn) && NamesUtil.isSet((String)fqn) && mesgfn.equals(fqn)) {
                ret = true;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("IsFaultMatch? mesg fault=" + mesgfn + " against fqn=" + fqn + " ret=" + ret);
            }
        }
        return ret;
    }

    public boolean isFullMatch(Message mesg, Channel channel, InternalSession session) {
        boolean ret;
        block15: {
            block16: {
                block17: {
                    block14: {
                        ret = true;
                        if (channel.getServiceReference() == null || mesg.getServiceEndpoint() == null || mesg.getServiceEndpoint().equals(channel.getServiceReference())) break block14;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Endpoint reference mismatch: " + channel.getServiceReference() + " against " + mesg.getServiceEndpoint());
                        }
                        ret = false;
                        break block15;
                    }
                    if (session.getSessionIdentity() == null) break block16;
                    if (mesg.getSessionIdentity() == null || mesg.getChannelIdentity() == null) break block17;
                    if (channel.getPrimaryIdentities().size() <= 0) break block15;
                    ret = channel.isPrimaryIdentity(mesg.getChannelIdentity());
                    if (!logger.isLoggable(Level.FINE)) break block15;
                    logger.fine("Is channel identity the primary identity: " + ret);
                    break block15;
                }
                if (session.getConfiguration().getServiceTracker() != null) {
                    session.getConfiguration().getServiceTracker().error(session, MessageActivityImpl.getMessage("_MESSAGE_EXPLICIT_IDENTITY", new Object[]{mesg}), null);
                    ret = false;
                } else {
                    logger.severe(MessageActivityImpl.getMessage("_MESSAGE_EXPLICIT_IDENTITY", new Object[]{mesg}));
                    ret = false;
                }
                break block15;
            }
            ret = false;
            org.pi4soa.service.behavior.Identity[] idrefs = this.getIdentities(IdentityType.PRIMARY);
            if (idrefs != null && idrefs.length > 0) {
                Identity mesgId;
                int i = 0;
                while (!ret && i < idrefs.length) {
                    mesgId = mesg.getMessageIdentity(idrefs[i].getIdentityName());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Identity for '" + idrefs[i].getIdentityName() + "' = " + mesgId);
                    }
                    if (mesgId != null) {
                        if (channel.getPrimaryIdentities().size() > 0) {
                            if (channel.hasPrimaryIdentity(idrefs[i].getIdentityName())) {
                                ret = channel.isPrimaryIdentity(mesgId);
                            }
                        } else {
                            ret = true;
                        }
                    }
                    ++i;
                }
                if (!ret && (idrefs = this.getIdentities(IdentityType.ALTERNATE)) != null && idrefs.length > 0) {
                    i = 0;
                    while (!ret && i < idrefs.length) {
                        mesgId = mesg.getMessageIdentity(idrefs[i].getIdentityName());
                        if (mesgId != null && channel.hasPrimaryIdentity(idrefs[i].getIdentityName())) {
                            ret = channel.isPrimaryIdentity(mesgId);
                        }
                        ++i;
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("IsFullMatch: " + ret);
        }
        return ret;
    }

    @Override
    public boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException, OutOfSequenceMessageException {
        if (event instanceof ExceptionEvent) {
            this.handleException(session, (ExceptionEvent)event);
        } else {
            this.handleMessage(session, event);
        }
        this.completed(session);
        super.processEvent(session, event);
        return true;
    }

    protected void handleMessage(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException {
        if (event instanceof Message) {
            Message mesg = (Message)event;
            if (this.getChannel() == null) {
                throw new ServiceException("No channel details available");
            }
            Channel channel = session.getChannel(this.getChannel().getName(), this.getChannel().getFullyQualifiedChannelType(), this.getChannel().getInformationType().getFullyQualifiedType(), this.getChannel().getServiceType().getFullyQualifiedName());
            this.registerPrimaryIdentities(session, mesg, channel);
            this.processMessageContent(session, mesg, channel);
        }
    }

    protected void registerPrimaryIdentities(InternalSession session, Message message, Channel channel) throws ServiceException {
        if (channel.getServiceReference() == null && message.getServiceEndpoint() != null) {
            session.setServiceReference(channel, message.getServiceEndpoint());
        }
        if (message.getSessionIdentity() != null && message.getChannelIdentity() != null) {
            if (channel.getPrimaryIdentities().size() == 0) {
                session.registerChannelIdentity(channel, message.getChannelIdentity(), this.isServerChannel());
            }
        } else {
            this.registerMessageIdentities(session, message.getMessageIdentities(), channel);
        }
    }

    public boolean isServerChannel() {
        boolean ret = false;
        if (this.getClassification() == MessageClassification.REQUEST) {
            ret = true;
        }
        return ret;
    }

    protected void registerMessageIdentities(InternalSession session, List<Identity> messageIdentities, Channel channel) throws ServiceException {
        Identity id;
        int i;
        boolean f_found = false;
        org.pi4soa.service.behavior.Identity[] idrefs = this.getIdentities(IdentityType.PRIMARY);
        if (idrefs != null && idrefs.length > 0 && messageIdentities != null) {
            i = 0;
            while (i < idrefs.length) {
                id = this.getMessageIdentity(messageIdentities, idrefs[i].getIdentityName());
                if (id != null) {
                    session.registerChannelIdentity(channel, id, this.isServerChannel());
                    f_found = true;
                }
                ++i;
            }
        }
        if ((idrefs = this.getIdentities(IdentityType.ALTERNATE)) != null && idrefs.length > 0 && messageIdentities != null) {
            i = 0;
            while (i < idrefs.length) {
                id = this.getMessageIdentity(messageIdentities, idrefs[i].getIdentityName());
                if (id != null) {
                    session.registerChannelIdentity(channel, id, this.isServerChannel());
                    f_found = true;
                }
                ++i;
            }
        }
        if (!f_found) {
            logger.severe("No PRIMARY or ALTERNATE identities found in message associated with channel '" + channel.getName() + "'");
        }
        if ((idrefs = this.getIdentities(IdentityType.DERIVED)) != null && idrefs.length > 0 && messageIdentities != null) {
            i = 0;
            while (i < idrefs.length) {
                id = this.getMessageIdentity(messageIdentities, idrefs[i].getIdentityName());
                if (id != null) {
                    session.registerDerivedIdentity(id);
                }
                ++i;
            }
        }
    }

    protected Identity getMessageIdentity(List<Identity> identities, String idName) {
        Identity ret = null;
        int i = 0;
        while (ret == null && i < identities.size()) {
            if (identities.get(i).getName().equals(idName)) {
                ret = identities.get(i);
            }
            ++i;
        }
        return ret;
    }

    protected void processMessageContent(InternalSession session, Message message, Channel channel) throws ServiceException {
    }

    protected org.pi4soa.service.behavior.Identity[] getIdentities(IdentityType idType) {
        Vector<org.pi4soa.service.behavior.Identity> v = new Vector<org.pi4soa.service.behavior.Identity>();
        Object[] ret = null;
        Iterator iter = this.getChannel().getIdentities().iterator();
        while (ret == null && iter.hasNext()) {
            org.pi4soa.service.behavior.Identity id = (org.pi4soa.service.behavior.Identity)iter.next();
            if (id.getType() != idType) continue;
            v.add(id);
        }
        ret = new org.pi4soa.service.behavior.Identity[v.size()];
        v.copyInto(ret);
        return ret;
    }

    @Override
    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        Vector<MessageActivityImpl> ret = new Vector<MessageActivityImpl>();
        ret.add(this);
        return ret;
    }

    @Override
    public boolean isActivityExtensionRequired() {
        return this.getVariable() == null;
    }

    protected String getInterfaceName() {
        return null;
    }

    protected abstract ActivityExtension getActivityExtension();

    @Override
    protected void initializeElement() throws ServiceException {
        if (this.getMessageDefinition() != null && this.getMessageDefinition().getInformationType() != null && this.getChannel() != null) {
            InformationType infoType = this.getMessageDefinition().getInformationType();
            for (org.pi4soa.service.behavior.Identity id : this.getChannel().getIdentities()) {
                boolean idok = true;
                int i = 0;
                while (idok && i < id.getTokens().size()) {
                    String token = (String)id.getTokens().get(i);
                    if (infoType.getTokenLocator(token) == null) {
                        idok = false;
                    }
                    ++i;
                }
                if (!idok) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Adding reference to identity '" + id + "' for infoType '" + infoType + "'");
                }
                infoType.getIdentityReferences().add(id);
            }
        }
    }

    protected MessageActivityImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.MESSAGE_ACTIVITY;
    }

    @Override
    public MessageDefinition getMessageDefinition() {
        if (this.messageDefinition != null && this.messageDefinition.eIsProxy()) {
            InternalEObject oldMessageDefinition = (InternalEObject)this.messageDefinition;
            this.messageDefinition = (MessageDefinition)this.eResolveProxy(oldMessageDefinition);
            if (this.messageDefinition != oldMessageDefinition && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldMessageDefinition, (Object)this.messageDefinition));
            }
        }
        return this.messageDefinition;
    }

    public MessageDefinition basicGetMessageDefinition() {
        return this.messageDefinition;
    }

    @Override
    public void setMessageDefinition(MessageDefinition newMessageDefinition) {
        MessageDefinition oldMessageDefinition = this.messageDefinition;
        this.messageDefinition = newMessageDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldMessageDefinition, (Object)this.messageDefinition));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                if (resolve) {
                    return this.getChannel();
                }
                return this.basicGetChannel();
            }
            case 3: {
                if (resolve) {
                    return this.getVariable();
                }
                return this.basicGetVariable();
            }
            case 4: {
                return this.getVariablePart();
            }
            case 5: {
                if (resolve) {
                    return this.getMessageDefinition();
                }
                return this.basicGetMessageDefinition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setChannel((ChannelDeclaration)newValue);
                return;
            }
            case 3: {
                this.setVariable((VariableDeclaration)newValue);
                return;
            }
            case 4: {
                this.setVariablePart((String)newValue);
                return;
            }
            case 5: {
                this.setMessageDefinition((MessageDefinition)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setChannel(null);
                return;
            }
            case 3: {
                this.setVariable(null);
                return;
            }
            case 4: {
                this.setVariablePart(VARIABLE_PART_EDEFAULT);
                return;
            }
            case 5: {
                this.setMessageDefinition(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.channel != null;
            }
            case 3: {
                return this.variable != null;
            }
            case 4: {
                return VARIABLE_PART_EDEFAULT == null ? this.variablePart != null : !VARIABLE_PART_EDEFAULT.equals(this.variablePart);
            }
            case 5: {
                return this.messageDefinition != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String getVariablePart() {
        return this.variablePart;
    }

    @Override
    public void setVariablePart(String newVariablePart) {
        String oldVariablePart = this.variablePart;
        this.variablePart = newVariablePart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldVariablePart, (Object)this.variablePart));
        }
    }

    @Override
    public ChannelDeclaration getChannel() {
        if (this.channel != null && this.channel.eIsProxy()) {
            InternalEObject oldChannel = (InternalEObject)this.channel;
            this.channel = (ChannelDeclaration)this.eResolveProxy(oldChannel);
            if (this.channel != oldChannel && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldChannel, (Object)this.channel));
            }
        }
        return this.channel;
    }

    public ChannelDeclaration basicGetChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(ChannelDeclaration newChannel) {
        ChannelDeclaration oldChannel = this.channel;
        this.channel = newChannel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldChannel, (Object)this.channel));
        }
    }

    @Override
    public VariableDeclaration getVariable() {
        if (this.variable != null && this.variable.eIsProxy()) {
            InternalEObject oldVariable = (InternalEObject)this.variable;
            this.variable = (VariableDeclaration)this.eResolveProxy(oldVariable);
            if (this.variable != oldVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldVariable, (Object)this.variable));
            }
        }
        return this.variable;
    }

    public VariableDeclaration basicGetVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(VariableDeclaration newVariable) {
        VariableDeclaration oldVariable = this.variable;
        this.variable = newVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldVariable, (Object)this.variable));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (variablePart: ");
        result.append(this.variablePart);
        result.append(')');
        return result.toString();
    }
}

