/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.PartDefinition;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.util.BehaviorTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDefinitionImpl
extends BehaviorTypeImpl
implements MessageDefinition {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedFQFaultName = null;
    private boolean m_enableFQNCaching = false;
    protected static final String FAULT_NAME_EDEFAULT = null;
    protected String faultName = FAULT_NAME_EDEFAULT;
    protected EList<PartDefinition> partDefinitions;
    protected static final MessageClassification CLASSIFICATION_EDEFAULT = MessageClassification.REQUEST;
    protected MessageClassification classification = CLASSIFICATION_EDEFAULT;
    protected InformationType informationType;

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
    }

    @Override
    public OperationDefinition getOperationDefinition() {
        return (OperationDefinition)this.getParent();
    }

    @Override
    public PartDefinition getPartDefinition(String name) {
        PartDefinition ret = null;
        Iterator iter = this.getPartDefinitions().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (PartDefinition)iter.next();
            if (ret.getName().equals(name)) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean getCanInitiateSession() {
        boolean ret = false;
        if (this.getInformationType() != null) {
            ret = this.getInformationType().getCanInitiateSession();
        }
        return ret;
    }

    @Override
    public String getFullyQualifiedFaultName() {
        if ((this.m_cachedFQFaultName == null || !this.m_enableFQNCaching) && NamesUtil.isSet((String)this.getFaultName())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getFaultName(), this);
            if (namespace == null && this.getOperationDefinition() != null && this.getOperationDefinition().getServiceType() != null) {
                namespace = NameSpaceUtil.getNamespace((String)this.getOperationDefinition().getServiceType().getFullyQualifiedName());
            }
            String localpart = XMLUtils.getLocalname((String)this.getFaultName());
            this.m_cachedFQFaultName = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                if (this.m_enableFQNCaching) {
                    logger.fine("Caching qname=" + this.m_cachedFQFaultName + " for " + this);
                } else {
                    logger.fine("Returning qname=" + this.m_cachedFQFaultName + " for " + this);
                }
            }
        }
        return this.m_cachedFQFaultName;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
    }

    protected MessageDefinitionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.MESSAGE_DEFINITION;
    }

    @Override
    public MessageClassification getClassification() {
        return this.classification;
    }

    @Override
    public void setClassification(MessageClassification newClassification) {
        MessageClassification oldClassification = this.classification;
        MessageClassification messageClassification = this.classification = newClassification == null ? CLASSIFICATION_EDEFAULT : newClassification;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldClassification, (Object)this.classification));
        }
    }

    @Override
    public InformationType getInformationType() {
        if (this.informationType != null && this.informationType.eIsProxy()) {
            InternalEObject oldInformationType = (InternalEObject)this.informationType;
            this.informationType = (InformationType)this.eResolveProxy(oldInformationType);
            if (this.informationType != oldInformationType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldInformationType, (Object)this.informationType));
            }
        }
        return this.informationType;
    }

    public InformationType basicGetInformationType() {
        return this.informationType;
    }

    @Override
    public void setInformationType(InformationType newInformationType) {
        InformationType oldInformationType = this.informationType;
        this.informationType = newInformationType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldInformationType, (Object)this.informationType));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getPartDefinitions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getFaultName();
            }
            case 3: {
                return this.getPartDefinitions();
            }
            case 4: {
                return this.getClassification();
            }
            case 5: {
                if (resolve) {
                    return this.getInformationType();
                }
                return this.basicGetInformationType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setFaultName((String)newValue);
                return;
            }
            case 3: {
                this.getPartDefinitions().clear();
                this.getPartDefinitions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setClassification((MessageClassification)((Object)newValue));
                return;
            }
            case 5: {
                this.setInformationType((InformationType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setFaultName(FAULT_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getPartDefinitions().clear();
                return;
            }
            case 4: {
                this.setClassification(CLASSIFICATION_EDEFAULT);
                return;
            }
            case 5: {
                this.setInformationType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return FAULT_NAME_EDEFAULT == null ? this.faultName != null : !FAULT_NAME_EDEFAULT.equals(this.faultName);
            }
            case 3: {
                return this.partDefinitions != null && !this.partDefinitions.isEmpty();
            }
            case 4: {
                return this.classification != CLASSIFICATION_EDEFAULT;
            }
            case 5: {
                return this.informationType != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public EList<PartDefinition> getPartDefinitions() {
        if (this.partDefinitions == null) {
            this.partDefinitions = new EObjectContainmentEList(PartDefinition.class, (InternalEObject)this, 3);
        }
        return this.partDefinitions;
    }

    @Override
    public String getFaultName() {
        return this.faultName;
    }

    @Override
    public void setFaultName(String newFaultName) {
        String oldFaultName = this.faultName;
        this.faultName = newFaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldFaultName, (Object)this.faultName));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (faultName: ");
        result.append(this.faultName);
        result.append(", classification: ");
        result.append((Object)this.classification);
        result.append(')');
        return result.toString();
    }
}

