/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.schema.SchemaException;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.NameSpace;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;

public class NameSpaceImpl
extends BehaviorTypeImpl
implements NameSpace {
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected static final String URI_EDEFAULT = null;
    protected String uRI = URI_EDEFAULT;
    protected static final String SCHEMA_LOCATION_EDEFAULT = null;
    protected String schemaLocation = SCHEMA_LOCATION_EDEFAULT;

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (NamesUtil.isSet((String)this.getURI())) {
            try {
                new URL(this.getURI());
            }
            catch (MalformedURLException malformedURLException) {
                l.report((Object)this, NameSpaceImpl.getMessage("_INVALID_URI", new String[]{this.getURI()}), 1);
            }
        }
        if (NamesUtil.isSet((String)this.getSchemaLocation()) && context != null) {
            try {
                String namespace = context.getSchemaManager().registerSchema(this.getSchemaLocation());
                if (namespace == null) {
                    l.report((Object)this, NameSpaceImpl.getMessage("_NOT_FOUND_SCHEMA_LOCATION", new String[]{this.getSchemaLocation()}), 2);
                } else if (!namespace.equals(this.getURI())) {
                    l.report((Object)this, NameSpaceImpl.getMessage("_SCHEMA_LOCATION_URI_MISMATCH", new String[]{namespace, this.getURI()}), 2);
                }
            }
            catch (SchemaException schemaException) {
                l.report((Object)this, NameSpaceImpl.getMessage("_FAILED_TO_LOAD_SCHEMA", new String[]{this.getSchemaLocation()}), 1);
            }
        }
    }

    protected NameSpaceImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.NAME_SPACE;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    public String getURI() {
        return this.uRI;
    }

    public void setURI(String newURI) {
        String oldURI = this.uRI;
        this.uRI = newURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldURI, (Object)this.uRI));
        }
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        String oldSchemaLocation = this.schemaLocation;
        this.schemaLocation = newSchemaLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSchemaLocation, (Object)this.schemaLocation));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getPrefix();
            }
            case 3: {
                return this.getURI();
            }
            case 4: {
                return this.getSchemaLocation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setPrefix((String)newValue);
                return;
            }
            case 3: {
                this.setURI((String)newValue);
                return;
            }
            case 4: {
                this.setSchemaLocation((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 3: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 4: {
                this.setSchemaLocation(SCHEMA_LOCATION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 3: {
                return URI_EDEFAULT == null ? this.uRI != null : !URI_EDEFAULT.equals(this.uRI);
            }
            case 4: {
                return SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (prefix: ");
        result.append(this.prefix);
        result.append(", uRI: ");
        result.append(this.uRI);
        result.append(", schemaLocation: ");
        result.append(this.schemaLocation);
        result.append(')');
        return result.toString();
    }
}

