/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.Parallel;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.SessionFactory;

public class ParallelImpl
extends StructuralTypeImpl
implements Parallel,
InternalSessionListener {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, OutOfSequenceMessageException {
        boolean ret = false;
        if (this.getActivityTypes().size() > 0) {
            InternalSession subsession = SessionFactory.getScopedSession(session);
            subsession.setInternalSessionListener(this);
            int i = this.getActivityTypes().size() - 1;
            while (i >= 0) {
                subsession.schedule((ActivityTypeImpl)this.getActivityTypes().get(i));
                --i;
            }
            ret = subsession.process(event);
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return ret;
    }

    public void sessionListenerRegistered(InternalSession session) {
    }

    public void sessionFinished(InternalSession session) throws ServiceException {
        if (session.getTerminatingException() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Parallel Propagating exception '" + session.getTerminatingException() + "'");
            }
            this.propagateException(session.getParent(), session.getTerminatingException());
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Parallel session completed");
            }
            this.completed(session.getParent());
        }
    }

    protected void propagateException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        super.handleException(session, exception);
    }

    protected void handleException(InternalSession session, ExceptionEvent exception) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Terminating parallel session due to exception '" + exception + "'");
        }
        session.sessionTerminated(exception);
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        if (scope != this) {
            if (after != null) {
                if (this.getParentImpl() instanceof ActivityTypeImpl) {
                    ret = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path);
                }
            } else if (this.getParentImpl() instanceof ActivityTypeImpl) {
                List postconds = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path);
                boolean f_optionalPaths = true;
                int i = 0;
                while (i < this.getActivityTypes().size()) {
                    ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                    List sublist = act.getNextMessageRelevantActivities(null, false, scope, path);
                    if (sublist == null) {
                        logger.warning("Parallel element [" + act.getId() + "] does not contain any lookahead message activities");
                    } else {
                        if (f_optionalPaths && postconds != null && !sublist.containsAll(postconds)) {
                            f_optionalPaths = false;
                        }
                        if (ret == null) {
                            ret = sublist;
                        } else {
                            int j = 0;
                            while (j < sublist.size()) {
                                if (!ret.contains(sublist.get(j))) {
                                    ret.add(sublist.get(j));
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                if (ret != null && !f_optionalPaths) {
                    ret.removeAll(postconds);
                }
                if (ret == null) {
                    logger.warning("Parallel [" + this.getId() + "] does not contain any lookahead message activities");
                }
            }
        }
        return ret;
    }

    public boolean isSequentialGroupingConstruct() {
        return false;
    }

    public void cleanup() {
        if (this.getActivityTypes().size() == 1 && this.getParent() instanceof StructuralTypeImpl) {
            int index = ((StructuralTypeImpl)this.getParent()).getActivityTypes().indexOf((Object)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Move single parallel's (" + this + ") activity to parent index=" + index + " activity=" + this.getActivityTypes().get(0));
            }
            if (index != -1) {
                ((StructuralTypeImpl)this.getParent()).getActivityTypes().add(index, (Object)((ActivityType)this.getActivityTypes().get(0)));
                ((StructuralTypeImpl)this.getParent()).getActivityTypes().remove((Object)this);
            }
        } else {
            super.cleanup();
        }
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.parallelStart(this);
        super.visit(visitor);
        visitor.parallelEnd(this);
    }

    protected ParallelImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.PARALLEL;
    }
}

