/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.Perform;
import org.pi4soa.service.behavior.VariableBinding;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.ExceptionHandlerImpl;
import org.pi4soa.service.behavior.impl.SessionEndPredicateImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.LookaheadElement;
import org.pi4soa.service.session.internal.Predicate;
import org.pi4soa.service.session.internal.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformImpl
extends ActivityTypeImpl
implements Perform,
LookaheadElement,
InternalSessionListener {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private List m_completionPredicates = null;
    private List m_exceptionPropagationPredicates = null;
    private List m_preConditions = null;
    protected BehaviorDescription behaviorDescription;
    protected static final String INSTANCE_ID_EDEFAULT = null;
    protected String instanceId = INSTANCE_ID_EDEFAULT;
    protected static final Boolean ISOLATED_EDEFAULT = Boolean.FALSE;
    protected Boolean isolated = ISOLATED_EDEFAULT;
    protected static final Boolean WAIT_FOR_COMPLETION_EDEFAULT = Boolean.TRUE;
    protected Boolean waitForCompletion = WAIT_FOR_COMPLETION_EDEFAULT;
    protected EList<VariableBinding> variableBindings;

    @Override
    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException {
        boolean ret = true;
        if (this.isIsolated()) {
            Iterator iter = this.getVariableBindings().iterator();
            while (ret && iter.hasNext()) {
                VariableBinding bind = (VariableBinding)iter.next();
                if (!session.isLocked(bind.getParentVariable().getName())) continue;
                ret = false;
            }
        }
        return ret;
    }

    @Override
    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException, OutOfSequenceMessageException {
        boolean ret = false;
        Serializable id = this.evaluateInstanceId(session);
        InternalSession parentSession = session;
        if (this.getWaitForCompletion() == Boolean.FALSE && !parentSession.isBehavioralSession() && (parentSession = session.getBehavioralSessionParent()) == null) {
            logger.severe("Could not obtain behavioral session parent for perform with 'wait for completion' set to FALSE");
        }
        InternalSession subsession = SessionFactory.getBehavioralSession(parentSession, this.getBehaviorDescription(), id, this.isIsolated(), this.getVariableBindingsAsMap());
        subsession.setInternalSessionListener(this);
        subsession.schedule((BehaviorDescriptionImpl)this.getBehaviorDescription());
        ret = subsession.process(event);
        this.unschedule(session);
        if (this.getWaitForCompletion() == Boolean.FALSE) {
            this.completed(session);
        }
        return ret;
    }

    @Override
    public void sessionListenerRegistered(InternalSession session) {
        if (this.getCompletionPredicates() != null && this.getCompletionPredicates().size() > 0) {
            Predicate[] preds = new Predicate[this.getCompletionPredicates().size()];
            preds = this.getCompletionPredicates().toArray(preds);
            if (!(this.getBehaviorDescription().getHasCompletionExpression() != Boolean.TRUE || session.getConfiguration().getEvaluateState() && this.isSet(this.getBehaviorDescription().getCompletionExpression()))) {
                session.setCompletionPredicates(preds);
            }
            session.setPostConditions(preds);
        }
        if (!session.getConfiguration().getEvaluateState()) {
            Predicate[] excPropagatePreds = this.getExceptionPropagatedPredicates(session.getParent());
            session.setExceptionPropagationConditions(excPropagatePreds);
        }
    }

    @Override
    public void sessionFinished(InternalSession session) throws ServiceException {
        if (session.getTerminatingException() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Propagating exception '" + session.getTerminatingException() + "'");
            }
            this.handleException(session.getParent(), session.getTerminatingException());
        } else if (this.getWaitForCompletion() != Boolean.FALSE) {
            this.completed(session.getParent());
        }
    }

    protected Predicate[] getExceptionPropagatedPredicates(InternalSession session) {
        int extra = 0;
        int len = this.getExceptionPropagationPredicates().size();
        if (session.getExceptionPropagationConditions() != null) {
            extra = session.getExceptionPropagationConditions().length;
        }
        Predicate[] ret = new Predicate[len + extra];
        ret = this.getExceptionPropagationPredicates().toArray(ret);
        int i = 0;
        while (i < extra) {
            ret[len + i] = session.getExceptionPropagationConditions()[i];
            ++i;
        }
        return ret;
    }

    public Map getVariableBindingsAsMap() {
        Hashtable<String, String> ret = null;
        if (this.getVariableBindings().size() > 0) {
            ret = new Hashtable<String, String>();
            for (VariableBinding bind : this.getVariableBindings()) {
                if (bind.getBoundVariable() != null && bind.getParentVariable() != null) {
                    ret.put(bind.getParentVariable().getName(), bind.getBoundVariable().getName());
                    continue;
                }
                logger.severe("Bind details must have variables defined: " + bind);
            }
        }
        return ret;
    }

    public boolean isIsolated() {
        boolean ret = false;
        if (this.getIsolated() != null && this.getVariableBindings().size() > 0) {
            ret = this.getIsolated();
        }
        return ret;
    }

    protected Serializable evaluateInstanceId(InternalSession session) {
        Serializable id = null;
        if (this.getInstanceId() != null) {
            XPathEvaluator evaluator = session.getConfiguration().getXPathEvaluator();
            try {
                Object evalid = evaluator.evaluate((Object)session, this.getInstanceId(), (XMLPrefixResolver)this);
                if (evalid instanceof Serializable) {
                    id = (Serializable)evalid;
                } else {
                    String mesg = PerformImpl.getMessage("_INVALID_PERFORM_INSTANCE_ID", new Object[]{this.getInstanceId()});
                    session.error(mesg, null);
                }
            }
            catch (XPathException xpe) {
                String mesg = PerformImpl.getMessage("_UNAVAILABLE_PERFORM_INSTANCE_ID", new Object[]{this.getInstanceId()});
                session.error(mesg, xpe);
            }
        }
        return id;
    }

    @Override
    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        Vector<BehaviorDescription> newlist;
        List ret = null;
        boolean f_optional = false;
        if (this.getBehaviorDescription() instanceof BehaviorDescriptionImpl && (path == null || !path.contains(this.getBehaviorDescription()))) {
            newlist = new Vector<BehaviorDescription>();
            if (path != null) {
                newlist.addAll(path);
            }
            newlist.add(this.getBehaviorDescription());
            ret = ((BehaviorDescriptionImpl)this.getBehaviorDescription()).getNextMessageRelevantActivities(null, false, scope, newlist);
        }
        if (ret != null) {
            int i = ret.size() - 1;
            while (i >= 0) {
                Object obj = ret.get(i);
                if (obj instanceof SessionEndPredicateImpl) {
                    ret.remove(i);
                    f_optional = true;
                }
                --i;
            }
        }
        if (!(!(this.getParentImpl() instanceof ActivityTypeImpl) || !f_optional && this.getWaitForCompletion() != Boolean.FALSE || scope == this || path != null && path.contains(this.getBehaviorDescription()))) {
            newlist = new Vector();
            if (path != null) {
                newlist.addAll(path);
            }
            newlist.add(this.getBehaviorDescription());
            List skiplist = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, newlist);
            if (skiplist != null) {
                if (ret == null) {
                    ret = skiplist;
                } else {
                    int i = 0;
                    while (i < skiplist.size()) {
                        if (!ret.contains(skiplist.get(i))) {
                            ret.add(skiplist.get(i));
                        }
                        ++i;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        if (this.getBehaviorDescription() instanceof BehaviorDescriptionImpl) {
            List list = ((BehaviorDescriptionImpl)this.getBehaviorDescription()).getNextMessageRelevantActivities(null, true, null, null);
            if (list != null) {
                int i = list.size() - 1;
                while (i >= 0) {
                    Object obj = list.get(i);
                    if (obj instanceof SessionEndPredicateImpl) {
                        list.remove(i);
                    }
                    --i;
                }
            }
            this.initializeConditions(list, this.getPreConditions());
        }
        this.initializeCompletionConditions();
        this.initializeExceptionPropagationPredicates();
    }

    @Override
    protected void cleanup() {
        if ((this.getBehaviorDescription() == null || this.getBehaviorDescription().eContainer() == null) && this.getParent() instanceof StructuralTypeImpl) {
            BehaviorTypeImpl parent = this.getParentImpl();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Remove: " + this);
            }
            ((StructuralTypeImpl)this.getParent()).getActivityTypes().remove((Object)this);
            parent.cleanup();
        }
    }

    protected void initializeCompletionConditions() {
        if (this.getParentImpl() instanceof ActivityTypeImpl && this.getWaitForCompletion() != Boolean.FALSE) {
            List list = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, true, null, null);
            this.initializeConditions(list, this.getCompletionPredicates());
        }
    }

    protected void initializeExceptionPropagationPredicates() {
        BehaviorDescriptionImpl bd = this.getBehaviorDescriptionImpl();
        if (bd != null) {
            for (ExceptionHandlerImpl eh : bd.getExceptionHandlers()) {
                List list = eh.getNextMessageRelevantActivities(null, false, null, null);
                if (list == null) continue;
                this.initializeConditions(list, this.getExceptionPropagationPredicates());
            }
        }
    }

    public List getCompletionPredicates() {
        if (this.m_completionPredicates == null) {
            this.m_completionPredicates = new Vector();
        }
        return this.m_completionPredicates;
    }

    public List getExceptionPropagationPredicates() {
        if (this.m_exceptionPropagationPredicates == null) {
            this.m_exceptionPropagationPredicates = new Vector();
        }
        return this.m_exceptionPropagationPredicates;
    }

    @Override
    public void visit(BehaviorVisitor visitor) {
        visitor.perform(this);
        super.visit(visitor);
    }

    @Override
    public List getPreConditions() {
        if (this.m_preConditions == null) {
            this.m_preConditions = new Vector();
        }
        return this.m_preConditions;
    }

    @Override
    public List getPostConditions() {
        return this.getCompletionPredicates();
    }

    protected PerformImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.PERFORM;
    }

    @Override
    public BehaviorDescription getBehaviorDescription() {
        if (this.behaviorDescription != null && this.behaviorDescription.eIsProxy()) {
            InternalEObject oldBehaviorDescription = (InternalEObject)this.behaviorDescription;
            this.behaviorDescription = (BehaviorDescription)this.eResolveProxy(oldBehaviorDescription);
            if (this.behaviorDescription != oldBehaviorDescription && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldBehaviorDescription, (Object)this.behaviorDescription));
            }
        }
        return this.behaviorDescription;
    }

    public BehaviorDescription basicGetBehaviorDescription() {
        return this.behaviorDescription;
    }

    @Override
    public void setBehaviorDescription(BehaviorDescription newBehaviorDescription) {
        BehaviorDescription oldBehaviorDescription = this.behaviorDescription;
        this.behaviorDescription = newBehaviorDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldBehaviorDescription, (Object)this.behaviorDescription));
        }
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void setInstanceId(String newInstanceId) {
        String oldInstanceId = this.instanceId;
        this.instanceId = newInstanceId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldInstanceId, (Object)this.instanceId));
        }
    }

    @Override
    public Boolean getIsolated() {
        return this.isolated;
    }

    @Override
    public void setIsolated(Boolean newIsolated) {
        Boolean oldIsolated = this.isolated;
        this.isolated = newIsolated;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldIsolated, (Object)this.isolated));
        }
    }

    @Override
    public EList<VariableBinding> getVariableBindings() {
        if (this.variableBindings == null) {
            this.variableBindings = new EObjectContainmentEList(VariableBinding.class, (InternalEObject)this, 6);
        }
        return this.variableBindings;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getVariableBindings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                if (resolve) {
                    return this.getBehaviorDescription();
                }
                return this.basicGetBehaviorDescription();
            }
            case 3: {
                return this.getInstanceId();
            }
            case 4: {
                return this.getIsolated();
            }
            case 5: {
                return this.getWaitForCompletion();
            }
            case 6: {
                return this.getVariableBindings();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setBehaviorDescription((BehaviorDescription)newValue);
                return;
            }
            case 3: {
                this.setInstanceId((String)newValue);
                return;
            }
            case 4: {
                this.setIsolated((Boolean)newValue);
                return;
            }
            case 5: {
                this.setWaitForCompletion((Boolean)newValue);
                return;
            }
            case 6: {
                this.getVariableBindings().clear();
                this.getVariableBindings().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setBehaviorDescription(null);
                return;
            }
            case 3: {
                this.setInstanceId(INSTANCE_ID_EDEFAULT);
                return;
            }
            case 4: {
                this.setIsolated(ISOLATED_EDEFAULT);
                return;
            }
            case 5: {
                this.setWaitForCompletion(WAIT_FOR_COMPLETION_EDEFAULT);
                return;
            }
            case 6: {
                this.getVariableBindings().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.behaviorDescription != null;
            }
            case 3: {
                return INSTANCE_ID_EDEFAULT == null ? this.instanceId != null : !INSTANCE_ID_EDEFAULT.equals(this.instanceId);
            }
            case 4: {
                return ISOLATED_EDEFAULT == null ? this.isolated != null : !ISOLATED_EDEFAULT.equals(this.isolated);
            }
            case 5: {
                return WAIT_FOR_COMPLETION_EDEFAULT == null ? this.waitForCompletion != null : !WAIT_FOR_COMPLETION_EDEFAULT.equals(this.waitForCompletion);
            }
            case 6: {
                return this.variableBindings != null && !this.variableBindings.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void setWaitForCompletion(Boolean newWaitForCompletion) {
        Boolean oldWaitForCompletion = this.waitForCompletion;
        this.waitForCompletion = newWaitForCompletion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldWaitForCompletion, (Object)this.waitForCompletion));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (instanceId: ");
        result.append(this.instanceId);
        result.append(", isolated: ");
        result.append(this.isolated);
        result.append(", waitForCompletion: ");
        result.append(this.waitForCompletion);
        result.append(')');
        return result.toString();
    }
}

