/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.RaiseException;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.ExceptionHandlerImpl;
import org.pi4soa.service.behavior.impl.ExceptionPropagatedPredicateImpl;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.util.BehaviorTypeUtil;

public class RaiseExceptionImpl
extends ActivityTypeImpl
implements RaiseException {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedFQExceptionType = null;
    private boolean m_enableFQNCaching = false;
    protected static final String EXCEPTION_TYPE_EDEFAULT = null;
    protected String exceptionType = EXCEPTION_TYPE_EDEFAULT;

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (NamesUtil.isSet((String)this.getExceptionType())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getExceptionType(), this);
            if (namespace == null) {
                l.report((Object)this, RaiseExceptionImpl.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getExceptionType()}), 2);
            } else if (context != null) {
                String localpart = XMLUtils.getLocalname((String)this.getExceptionType());
                if (!context.getSchemaManager().isValidType(namespace, localpart)) {
                    l.report((Object)this, RaiseExceptionImpl.getMessage("_UNKNOWN_TYPE_IN_NAMESPACE", new Object[]{localpart, namespace}), 2);
                }
            }
        }
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException {
        this.handleException(session, new ExceptionEvent(this.getFullyQualifiedExceptionType()));
        return false;
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List<ExceptionPropagatedPredicateImpl> ret = null;
        BehaviorDescriptionImpl bd = this.getBehaviorDescriptionImpl();
        if (bd != null) {
            if (!this.isCalledFromExceptionHandler()) {
                Iterator iter = bd.getExceptionHandlers().iterator();
                while (iter.hasNext() && ret == null) {
                    ExceptionHandlerImpl eh = (ExceptionHandlerImpl)iter.next();
                    if (eh.getExceptionType() != null && !eh.getExceptionType().equals(this.getExceptionType())) continue;
                    ret = eh.getNextMessageRelevantActivities(null, false, scope, path);
                }
            }
            if (ret == null) {
                ret = new Vector<ExceptionPropagatedPredicateImpl>();
                if (scope != this) {
                    ret.add(new ExceptionPropagatedPredicateImpl());
                }
            }
        }
        return ret;
    }

    protected boolean isCalledFromExceptionHandler() {
        boolean ret = false;
        BehaviorTypeImpl parent = this.getParentImpl();
        while (!ret && parent != null && !(parent instanceof BehaviorDescriptionImpl)) {
            if (parent instanceof ExceptionHandlerImpl) {
                ret = true;
            }
            parent = parent.getParentImpl();
        }
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.raiseException(this);
        super.visit(visitor);
    }

    public String getFullyQualifiedExceptionType() {
        if ((this.m_cachedFQExceptionType == null || !this.m_enableFQNCaching) && NamesUtil.isSet((String)this.getExceptionType())) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getExceptionType(), this);
            String localpart = XMLUtils.getLocalname((String)this.getExceptionType());
            this.m_cachedFQExceptionType = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                if (this.m_enableFQNCaching) {
                    logger.fine("Caching qname=" + this.m_cachedFQExceptionType + " for " + this);
                } else {
                    logger.fine("Returning qname=" + this.m_cachedFQExceptionType + " for " + this);
                }
            }
        }
        return this.m_cachedFQExceptionType;
    }

    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
    }

    protected RaiseExceptionImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.RAISE_EXCEPTION;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String newExceptionType) {
        String oldExceptionType = this.exceptionType;
        this.exceptionType = newExceptionType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldExceptionType, (Object)this.exceptionType));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getExceptionType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setExceptionType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setExceptionType(EXCEPTION_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return EXCEPTION_TYPE_EDEFAULT == null ? this.exceptionType != null : !EXCEPTION_TYPE_EDEFAULT.equals(this.exceptionType);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (exceptionType: ");
        result.append(this.exceptionType);
        result.append(')');
        return result.toString();
    }
}

