/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.service.Channel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Message;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.ChannelDeclaration;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.MessageActivityImpl;
import org.pi4soa.service.behavior.impl.ServiceDescriptionImpl;
import org.pi4soa.service.behavior.impl.ServiceTypeImpl;
import org.pi4soa.service.extensions.ActivityExtension;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.ReceiveActivityExtension;
import org.pi4soa.service.session.internal.InternalSession;

public class ReceiveImpl
extends MessageActivityImpl
implements Receive {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private ReceiveActivityExtension m_extension = null;

    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        ServiceTypeImpl st = null;
        if (this.getMessageDefinition() != null && this.getMessageDefinition().getOperationDefinition() != null) {
            st = (ServiceTypeImpl)this.getMessageDefinition().getOperationDefinition().getServiceType();
        }
        if (st != null) {
            if (this.getMessageDefinition().getClassification() == MessageClassification.REQUEST) {
                st.setServiceProvider(true);
            } else if (this.getMessageDefinition().getClassification() == MessageClassification.RESPONSE || this.getMessageDefinition().getClassification() == MessageClassification.NOTIFICATION) {
                st.setServiceClient(true);
            }
        }
    }

    public boolean isInitialMatch(Message mesg) {
        boolean ret = false;
        if (mesg != null && !mesg.isOutbound()) {
            ret = super.isInitialMatch(mesg);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("isInitiatMatch ret=" + ret);
        }
        return ret;
    }

    protected void handleMessage(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException {
        super.handleMessage(session, event);
        if (event instanceof Message) {
            Message mesg = (Message)event;
            Channel channel = session.getChannel(this.getChannel().getName(), this.getChannel().getFullyQualifiedChannelType(), this.getChannel().getInformationType().getFullyQualifiedType(), this.getChannel().getServiceType().getFullyQualifiedName());
            if (session.getConfiguration().getServiceTracker() != null) {
                this.completeMessage(mesg);
                session.getConfiguration().getServiceTracker().receivedMessage(this, session, channel, mesg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessageContent(InternalSession session, Message message, Channel channel) throws ServiceException {
        if (session.getConfiguration().getEvaluateState() && this.getVariable() != null) {
            if (this.getVariable() instanceof ChannelDeclaration) {
                ChannelDeclaration cdecl = (ChannelDeclaration)this.getVariable();
                Channel ch = session.getChannel(cdecl.getName(), null, null, null);
                if (ch == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(session + ": Received passed channel '" + cdecl.getName() + "'");
                    }
                    ch = session.getChannel(cdecl.getName(), cdecl.getFullyQualifiedChannelType(), cdecl.getInformationType().getFullyQualifiedType(), cdecl.getServiceType().getFullyQualifiedName());
                    EndpointReference ref = session.getConfiguration().getServiceRegistry().createEndpointReference(message.getValue(), cdecl.getInformationType().getFullyQualifiedType());
                    if (ref == null) throw new ServiceException("Failed to establish endpoint reference for received channel '" + cdecl.getName() + "'");
                    session.setServiceReference(ch, ref);
                }
            } else {
                this.setVariable(session, this.getVariable().getName(), this.getVariablePart(), message.getValue());
            }
        }
        if (this.m_extension != null) {
            this.m_extension.processMessage(session.getExtensionContext(), message);
        }
        if (session.getConfiguration().isMonitoring() || session.getConfiguration().getMessageHandler() == null) return;
        session.getConfiguration().getMessageHandler().acknowledge(channel, message);
    }

    protected String getInterfaceName() {
        return Receive.class.getName();
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
        super.initialize(resolver);
        if (resolver != null && this.isActivityExtensionRequired()) {
            ServiceDescriptionImpl sd = this.getServiceDescriptionImpl();
            BehaviorDescriptionImpl bd = this.getBehaviorDescriptionImpl();
            if (sd != null) {
                this.m_extension = resolver.resolveReceiveActivityExtension(sd.getFullyQualifiedName(), bd.getFullyQualifiedName(), this.getName());
            }
            if (this.m_extension == null) {
                throw new ExtensionException("Activity extension for receive activity '" + this.getName() + "' could not be found");
            }
        }
    }

    protected ActivityExtension getActivityExtension() {
        return this.m_extension;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.receive(this);
        super.visit(visitor);
    }

    protected ReceiveImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.RECEIVE;
    }
}

