/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.RepetitionType;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.behavior.impl.ServiceDescriptionImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.behavior.impl.XPathConditionImpl;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.PredicateExtension;
import org.pi4soa.service.session.internal.InternalSession;

public abstract class RepetitionTypeImpl
extends StructuralTypeImpl
implements RepetitionType {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private PredicateImpl m_predicate = null;
    private PredicateImpl m_reEvaluateCondition = null;
    private PredicateExtension m_reEvaluationExtensionPredicate = null;
    private boolean m_checkingPreConditions = false;
    protected static final String EXPRESSION_EDEFAULT = null;
    protected String expression = EXPRESSION_EDEFAULT;
    protected static final String RE_EVALUATE_EXPRESSION_EDEFAULT = null;
    protected String reEvaluateExpression = RE_EVALUATE_EXPRESSION_EDEFAULT;

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
    }

    public PredicateImpl getCondition() {
        return this.m_predicate;
    }

    protected void setCondition(PredicateImpl pred) {
        this.m_predicate = pred;
    }

    public PredicateImpl getReEvaluateCondition() {
        return this.m_reEvaluateCondition;
    }

    protected void setReEvaluateCondition(PredicateImpl pred) {
        this.m_reEvaluateCondition = pred;
    }

    protected boolean isReEvaluateExpressionNonObservable() {
        boolean ret = false;
        if (!NamesUtil.isSet((String)this.getReEvaluateExpression())) {
            ret = true;
        }
        return ret;
    }

    public boolean isConditionalGroupingConstruct() {
        return true;
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
            this.unschedule(session);
        } else if (this.isBlockingActivity()) {
            this.unschedule(session);
            this.completed(session);
        }
        return false;
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                boolean repeat = this.shouldRepeat(session);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Should repeat activity? " + repeat + " activity is '" + this + "' session=" + session);
                }
                if (repeat) {
                    this.repeatActivity(session);
                } else {
                    this.completed(session);
                }
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Repetition could not find completed child");
        }
    }

    protected boolean shouldRepeat(InternalSession session) throws ServiceException {
        boolean ret;
        block16: {
            ret = false;
            if (this.getReEvaluationPredicateExtension() != null && !session.getConfiguration().isMonitoring()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Calling predicate extension '" + this.getPredicateExtension() + "' session=" + session);
                }
                ret = this.getReEvaluationPredicateExtension().isSatisfied(session.getReadOnlyExtensionContext(), null);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Predicate extension '" + this.getPredicateExtension() + "' returned=" + ret);
                }
            } else if (!session.getConfiguration().getEvaluateState() || this.isReEvaluateExpressionNonObservable()) {
                ret = true;
            } else if (this.getReEvaluateCondition() instanceof PredicateImpl) {
                PredicateImpl pred = this.getReEvaluateCondition();
                if (pred.isConditionPredicate()) {
                    try {
                        ret = pred.isSatisfied(session, null);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Evaluated repeat predicate '" + pred + "'? " + ret + " activity is '" + this + "' session=" + session);
                        }
                        break block16;
                    }
                    catch (ServiceException se) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Evaluated repeat predicate '" + pred + "' caused exception=" + se + ", activity is '" + this + "' session=" + session);
                        }
                        break block16;
                    }
                }
                logger.severe("Repetition can only have 'condition' based predicates as re-evaluate conditions");
            } else if (this.getReEvaluateCondition() != null) {
                logger.severe("Repetition has unknown predicate implementation");
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Re-evaluation condition is NULL for activity '" + this + "' session=" + session);
            }
        }
        return ret;
    }

    protected void repeatActivity(InternalSession session) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Repeat activity '" + this + "' session=" + session);
        }
        session.schedule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        int pos = 0;
        if (after != null) {
            pos = this.getActivityTypes().indexOf((Object)after);
            if (pos != -1) {
                ++pos;
            } else {
                logger.warning("Repeat [" + this.getId() + "] does not contain activity: " + after);
            }
        }
        if (pos != -1) {
            List skiplist;
            boolean f_postConditionsRequired;
            ActivityTypeImpl act;
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            boolean bl = f_postConditionsRequired = ret == null;
            if (after != null && f_postConditionsRequired && (this.getReEvaluateExpression() != null || this.isReEvaluateExpressionNonObservable())) {
                act = this;
                synchronized (act) {
                    if (!this.m_checkingPreConditions) {
                        this.m_checkingPreConditions = true;
                        try {
                            ret = this.getNextMessageRelevantActivities(null, true, scope, path);
                        }
                        finally {
                            this.m_checkingPreConditions = false;
                        }
                    }
                }
            }
            if (!(after != null && !f_postConditionsRequired || this.isChoiceElement() || local || !(this.getParentImpl() instanceof ActivityTypeImpl) || this.isCheckingPreConditions() && !this.usePreConditionsOnly() || scope == this || (skiplist = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path)) == null)) {
                if (ret == null) {
                    ret = skiplist;
                } else {
                    int i2 = 0;
                    while (i2 < skiplist.size()) {
                        if (!ret.contains(skiplist.get(i2))) {
                            ret.add(skiplist.get(i2));
                        }
                        ++i2;
                    }
                }
            }
            if (ret == null) {
                logger.warning("Repeat [" + this.getId() + "] does not contain any lookahead message activities");
            }
        }
        return ret;
    }

    public boolean isConditionObservable() {
        return this.getCondition() != null;
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
        super.initialize(resolver);
        if (this.isReEvaluationPredicateExtensionRequired() && resolver != null) {
            ServiceDescriptionImpl sd = this.getServiceDescriptionImpl();
            BehaviorDescriptionImpl bd = this.getBehaviorDescriptionImpl();
            if (sd != null) {
                this.m_reEvaluationExtensionPredicate = resolver.resolveReEvaluationPredicateExtension(sd.getFullyQualifiedName(), bd.getFullyQualifiedName(), this.getName());
                if (this.m_reEvaluationExtensionPredicate == null) {
                    throw new ExtensionException("Re-Evaluation Predicate extension for repetition activity '" + this.getName() + "' could not be found");
                }
            }
        }
    }

    public boolean isReEvaluationPredicateExtensionRequired() {
        boolean ret = false;
        if ((this.isPredicateExtensionRequired() || this.isConditionObservable()) && this.isReEvaluateExpressionNonObservable()) {
            ret = true;
        }
        return ret;
    }

    protected PredicateExtension getReEvaluationPredicateExtension() {
        return this.m_reEvaluationExtensionPredicate;
    }

    protected void initializeElement() throws ServiceException {
        if (this.isSet(this.getExpression())) {
            XPathConditionImpl xpath = new XPathConditionImpl(this);
            xpath.setExpression(this.getExpression());
            xpath.setBlockingPredicate(this.isBlockingActivity());
            this.m_predicate = xpath;
            this.getPreConditions().add(xpath);
        }
        if (this.isSet(this.getReEvaluateExpression())) {
            this.m_reEvaluateCondition = new XPathConditionImpl(this);
            ((XPathConditionImpl)this.m_reEvaluateCondition).setExpression(this.getReEvaluateExpression());
        }
        super.initializeElement();
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.repetitionTypeStart(this);
        super.visit(visitor);
        visitor.repetitionTypeEnd(this);
    }

    protected RepetitionTypeImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.REPETITION_TYPE;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String newExpression) {
        String oldExpression = this.expression;
        this.expression = newExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldExpression, (Object)this.expression));
        }
    }

    public String getReEvaluateExpression() {
        return this.reEvaluateExpression;
    }

    public void setReEvaluateExpression(String newReEvaluateExpression) {
        String oldReEvaluateExpression = this.reEvaluateExpression;
        this.reEvaluateExpression = newReEvaluateExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldReEvaluateExpression, (Object)this.reEvaluateExpression));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getExpression();
            }
            case 4: {
                return this.getReEvaluateExpression();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setExpression((String)newValue);
                return;
            }
            case 4: {
                this.setReEvaluateExpression((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setExpression(EXPRESSION_EDEFAULT);
                return;
            }
            case 4: {
                this.setReEvaluateExpression(RE_EVALUATE_EXPRESSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return EXPRESSION_EDEFAULT == null ? this.expression != null : !EXPRESSION_EDEFAULT.equals(this.expression);
            }
            case 4: {
                return RE_EVALUATE_EXPRESSION_EDEFAULT == null ? this.reEvaluateExpression != null : !RE_EVALUATE_EXPRESSION_EDEFAULT.equals(this.reEvaluateExpression);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (expression: ");
        result.append(this.expression);
        result.append(", reEvaluateExpression: ");
        result.append(this.reEvaluateExpression);
        result.append(')');
        return result.toString();
    }
}

