/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.service.Channel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.Message;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.ChannelDeclaration;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.UsageType;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.MessageActivityImpl;
import org.pi4soa.service.behavior.impl.ServiceDescriptionImpl;
import org.pi4soa.service.behavior.impl.ServiceTypeImpl;
import org.pi4soa.service.extensions.ActivityExtension;
import org.pi4soa.service.extensions.ChannelCreationExtension;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.SendActivityExtension;
import org.pi4soa.service.registry.ServiceRegistry;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.MessageUtil;

public class SendImpl
extends MessageActivityImpl
implements Send {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private SendActivityExtension m_extension = null;
    private ChannelCreationExtension m_mainChannelExtension = null;
    private ChannelCreationExtension m_passedChannelExtension = null;
    protected static final Boolean NEW_PASSED_CHANNEL_EDEFAULT = Boolean.FALSE;
    protected Boolean newPassedChannel = NEW_PASSED_CHANNEL_EDEFAULT;

    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        ServiceTypeImpl st = null;
        if (this.getMessageDefinition() != null && this.getMessageDefinition().getOperationDefinition() != null) {
            st = (ServiceTypeImpl)this.getMessageDefinition().getOperationDefinition().getServiceType();
        }
        if (st != null) {
            if (this.getMessageDefinition().getClassification() == MessageClassification.REQUEST) {
                st.setServiceClient(true);
            } else if (this.getMessageDefinition().getClassification() == MessageClassification.RESPONSE || this.getMessageDefinition().getClassification() == MessageClassification.NOTIFICATION) {
                st.setServiceProvider(true);
            }
        }
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
        super.initialize(resolver);
        if (resolver != null) {
            ServiceDescriptionImpl sd = this.getServiceDescriptionImpl();
            BehaviorDescriptionImpl bd = this.getBehaviorDescriptionImpl();
            if (sd != null) {
                if (this.isActivityExtensionRequired()) {
                    this.m_extension = resolver.resolveSendActivityExtension(sd.getFullyQualifiedName(), bd.getFullyQualifiedName(), this.getName());
                    if (this.m_extension == null) {
                        throw new ExtensionException("Activity extension for send activity '" + this.getName() + "' could not be found");
                    }
                }
                if (this.isChannelCreationExtensionRequired()) {
                    this.m_mainChannelExtension = resolver.resolveChannelCreationExtension(sd.getFullyQualifiedName(), bd.getFullyQualifiedName(), this.getChannel().getName());
                    if (this.m_mainChannelExtension == null && logger.isLoggable(Level.FINE)) {
                        logger.fine("Channel creation extension for send activity '" + this.getName() + "' and channel '" + this.getChannel().getName() + "' could not be found");
                    }
                }
                if (this.isPassedChannelCreationExtensionRequired()) {
                    ChannelDeclaration cdecl = (ChannelDeclaration)this.getVariable();
                    this.m_passedChannelExtension = resolver.resolveChannelCreationExtension(sd.getFullyQualifiedName(), bd.getFullyQualifiedName(), cdecl.getName());
                    if (this.m_passedChannelExtension == null && logger.isLoggable(Level.FINE)) {
                        logger.fine("Passed channel creation extension for send activity '" + this.getName() + "' and passed channel '" + cdecl.getName() + "' could not be found");
                    }
                }
            }
        }
    }

    public boolean isChannelCreationExtensionRequired() {
        boolean ret = false;
        if (this.getChannel() != null && this.getChannel().getServiceType() != null && this.getChannel().getServiceType().isServiceClient() && this.getClassification() == MessageClassification.REQUEST) {
            ret = true;
        }
        return ret;
    }

    public boolean isPassedChannelCreationExtensionRequired() {
        ChannelDeclaration cdecl;
        ServiceType stype;
        boolean ret = false;
        if (this.getVariable() instanceof ChannelDeclaration && (stype = (cdecl = (ChannelDeclaration)this.getVariable()).getServiceType()) != null && stype.isServiceClient()) {
            ret = true;
        }
        return ret;
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException {
        boolean ret = false;
        ret = session.getConfiguration().isMonitoring() ? super.canProcess(session, event) : true;
        return ret;
    }

    public boolean isInitialMatch(Message mesg) {
        boolean ret = false;
        if (mesg != null && mesg.isOutbound()) {
            ret = super.isInitialMatch(mesg);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("isInitiatMatch ret=" + ret);
        }
        return ret;
    }

    protected void handleMessage(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException {
        if (session.getConfiguration().isMonitoring()) {
            super.handleMessage(session, event);
            if (event instanceof Message) {
                Message mesg = (Message)event;
                Channel channel = session.getChannel(this.getChannel().getName(), this.getChannel().getFullyQualifiedChannelType(), this.getChannel().getInformationType().getFullyQualifiedType(), this.getChannel().getServiceType().getFullyQualifiedName());
                if (session.getConfiguration().getServiceTracker() != null) {
                    this.completeMessage(mesg);
                    session.getConfiguration().getServiceTracker().sentMessage(this, session, channel, mesg);
                }
            }
        } else {
            Channel channel = session.getChannel(this.getChannel().getName(), this.getChannel().getFullyQualifiedChannelType(), this.getChannel().getInformationType().getFullyQualifiedType(), this.getChannel().getServiceType().getFullyQualifiedName());
            Serializable mesgValue = this.getMessageValue(channel, session);
            Message mesg = this.createMessageEvent(channel, session, mesgValue);
            session.getConfiguration().getMessageHandler().dispatch(channel, mesg, this.getOperationDefinition());
            if (session.getConfiguration().getServiceTracker() != null) {
                this.completeMessage(mesg);
                session.getConfiguration().getServiceTracker().sentMessage(this, session, channel, mesg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable getMessageValue(Channel channel, InternalSession session) throws ServiceException, UnresolvedConstraintException {
        ChannelDeclaration cdecl;
        Object ret = null;
        if (this.getVariable() != null) {
            if (!(this.getVariable() instanceof ChannelDeclaration)) return this.getVariable(session, this.getVariable().getName(), this.getVariablePart());
            cdecl = (ChannelDeclaration)this.getVariable();
            Channel chan = session.getChannel(cdecl.getName(), null, null, null);
            if (chan == null) {
                chan = session.getChannel(cdecl.getName(), cdecl.getFullyQualifiedChannelType(), cdecl.getInformationType().getFullyQualifiedType(), cdecl.getServiceType().getFullyQualifiedName());
            } else if (this.getNewPassedChannel() == Boolean.TRUE) {
                session.warning("Channel '" + cdecl.getName() + "', of type '" + cdecl.getChannelType() + "', being passed on channel type '" + this.getChannel().getChannelType() + "', is not a NEW channel", null);
            }
            if (chan == null) throw new ServiceException("Unable to send channel '" + this.getVariable().getName() + "'");
            if (chan.getServiceReference() == null) {
                EndpointReference ref = null;
                ServiceType stype = cdecl.getServiceType();
                if (stype != null) {
                    if (stype.isServiceProvider()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(session + ": Passing endpoint reference " + "to own service interface");
                        }
                        if (session.getConfiguration().getEndpointReferences() != null && session.getConfiguration().getEndpointReferences().length > 0) {
                            ref = session.getConfiguration().getEndpointReferences()[0];
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine(session + ": Found session endpoint reference:" + ref);
                            }
                        }
                    }
                } else {
                    logger.severe("Failed to obtain service type '" + cdecl.getServiceType() + "' definition for passed channel '" + cdecl.getName() + "'");
                }
                if (ref == null) {
                    ref = this.discover(session, cdecl.getInformationType().getFullyQualifiedType(), cdecl.getServiceType().getFullyQualifiedName(), session.getConfiguration().getServiceRegistry());
                }
                if (ref != null) {
                    session.setServiceReference(chan, ref);
                    ret = ref.toText(channel.getPrimaryIdentities());
                } else {
                    logger.severe("Failed to discover endpoint for service type '" + cdecl.getServiceType() + "'");
                }
            } else {
                ret = chan.getServiceReference().toText(channel.getPrimaryIdentities());
            }
            if (cdecl.getUsage() != UsageType.DISTINCT) {
                if (cdecl.getUsage() != UsageType.ONCE) return ret;
            }
        } else {
            if (this.m_extension == null) throw new ServiceException("Unable to determine message value to send");
            return this.m_extension.getMessageContent(session.getExtensionContext());
        }
        session.relinquishChannel(cdecl.getName());
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Message createMessageEvent(Channel channel, InternalSession session, Serializable value) throws ServiceException {
        Message ret = null;
        Identity sessionIdentity = session.getSessionIdentity();
        Identity channelIdentity = null;
        if (sessionIdentity != null) {
            Set<Identity> ids = channel.getPrimaryIdentities();
            if (ids.size() > 0) {
                channelIdentity = ids.iterator().next();
                if (ids.size() > 1) {
                    logger.severe("Only single identity should be associated with a channel that uses explicit identities");
                }
            } else {
                channelIdentity = session.getConfiguration().getIdentityManager().getIdentity();
                session.registerChannelIdentity(channel, channelIdentity, this.isServerChannel());
            }
        }
        if (channel.getServiceReference() == null) {
            EndpointReference ref = this.discover(session, this.getChannel().getServiceType().getFullyQualifiedName(), channel.getServiceReferenceType(), session.getConfiguration().getServiceRegistry());
            if (ref != null) {
                session.setServiceReference(channel, ref);
            } else {
                logger.severe("Failed to discover endpoint for service type '" + this.getChannel().getServiceType() + "'");
            }
        }
        if ((ret = this.getClassification() == MessageClassification.REQUEST ? session.getConfiguration().getMessageHandler().createRequest(this.getOperationName(), this.getFullyQualifiedFaultName(), this.getMessageType(), this.getChannel().getServiceType().getFullyQualifiedName(), channel.getServiceReference(), value, sessionIdentity, channelIdentity) : session.getConfiguration().getMessageHandler().createResponse(this.getOperationName(), this.getFullyQualifiedFaultName(), this.getMessageType(), this.getChannel().getServiceType().getFullyQualifiedName(), channel.getServiceReference(), value, sessionIdentity, channelIdentity)) == null || sessionIdentity != null) return ret;
        ServiceDescriptionImpl sdesc = this.getServiceDescriptionImpl();
        if (sdesc != null) {
            List<Identity> ids = MessageUtil.deriveIdentity(sdesc, ret, session.getConfiguration());
            if (ids == null || ids.size() <= 0) throw new ServiceException("Message being sent '" + ret + "' does not any identity information");
            ret.setMessageIdentities(ids);
            if (!this.isFullMatch(ret, channel, session)) throw new ServiceException("Message being sent '" + ret + "' does not have the identity information " + "required to be sent on the channel '" + channel.getName() + "'");
            this.registerMessageIdentities(session, ids, channel);
            return ret;
        } else {
            logger.severe("Service description could not be found");
        }
        return ret;
    }

    public boolean isServerChannel() {
        boolean ret = false;
        if (this.getClassification() != MessageClassification.REQUEST) {
            ret = true;
        }
        return ret;
    }

    protected EndpointReference discover(InternalSession session, String serviceType, String endpointReferenceType, ServiceRegistry registry) throws ServiceException {
        EndpointReference ret = null;
        if (this.m_mainChannelExtension == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Default discovery: serviceType=" + serviceType + " endpointRefType=" + endpointReferenceType);
            }
            ret = registry.discover(serviceType, endpointReferenceType);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extension based discovery: serviceType=" + serviceType + " endpointRefType=" + endpointReferenceType);
            }
            ret = this.m_mainChannelExtension.discover(session.getExtensionContext(), serviceType, endpointReferenceType, registry, null);
        }
        return ret;
    }

    protected EndpointReference discover(InternalSession session, ChannelDeclaration cdecl, ServiceRegistry registry) throws ServiceException {
        EndpointReference ret = null;
        if (this.m_passedChannelExtension == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Default passed channel discovery: serviceType=" + cdecl.getInformationType().getFullyQualifiedType() + " endpointRefType=" + cdecl.getServiceType().getFullyQualifiedName());
            }
            ret = registry.discover(cdecl.getInformationType().getFullyQualifiedType(), cdecl.getServiceType().getFullyQualifiedName());
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extension based passed channel discovery: serviceType=" + cdecl.getInformationType().getFullyQualifiedType() + " endpointRefType=" + cdecl.getServiceType().getFullyQualifiedName());
            }
            ret = this.m_passedChannelExtension.discover(session.getExtensionContext(), cdecl.getInformationType().getFullyQualifiedType(), cdecl.getServiceType().getFullyQualifiedName(), registry, null);
        }
        return ret;
    }

    protected void processMessageContent(InternalSession session, Message message, Channel channel) throws ServiceException {
        if (session.getConfiguration().getShouldVerifyMessageContent()) {
            boolean match = true;
            Serializable oldValue = null;
            Serializable newValue = message.getValue();
            try {
                oldValue = this.getVariable(session, this.getVariable().getName(), this.getVariablePart());
            }
            catch (Exception exception) {}
            if (oldValue != null) {
                if (oldValue instanceof Map) {
                    if (newValue instanceof Map) {
                        Map newMap = (Map)((Object)newValue);
                        Map oldMap = (Map)((Object)oldValue);
                        if (newMap.size() != oldMap.size()) {
                            match = false;
                        } else {
                            Set newKeys = newMap.keySet();
                            Iterator iter = newKeys.iterator();
                            while (match && iter.hasNext()) {
                                String key = (String)iter.next();
                                Object oldPart = oldMap.get(key);
                                if (oldPart == null) {
                                    match = false;
                                    continue;
                                }
                                if (this.isEquivalent(oldPart, newMap.get(key))) continue;
                                match = false;
                            }
                        }
                    } else {
                        match = false;
                    }
                } else if (!this.isEquivalent(oldValue, newValue)) {
                    match = false;
                }
            }
            if (!match && session.getConfiguration().getServiceTracker() != null) {
                String mesg = SendImpl.getMessage("_DIFFERENT_CONTENTS", null);
                session.getConfiguration().getServiceTracker().warning(session, mesg, null);
            }
        }
        if (session.getConfiguration().getEvaluateState() && this.getVariable() != null) {
            this.setVariable(session, this.getVariable().getName(), this.getVariablePart(), message.getValue());
        }
    }

    protected boolean isEquivalent(Object first, Object second) {
        boolean ret = false;
        if (first != null && second != null && first.equals(second)) {
            ret = true;
        }
        return ret;
    }

    protected String getInterfaceName() {
        return Send.class.getName();
    }

    public OperationDefinition getOperationDefinition() {
        OperationDefinition ret = null;
        if (this.getMessageDefinition() != null) {
            ret = this.getMessageDefinition().getOperationDefinition();
        }
        return ret;
    }

    protected ActivityExtension getActivityExtension() {
        return this.m_extension;
    }

    protected boolean handlesUnresolvedConstraint() {
        boolean ret = false;
        if (this.m_extension != null) {
            ret = true;
        }
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.send(this);
        super.visit(visitor);
    }

    protected SendImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.SEND;
    }

    public Boolean getNewPassedChannel() {
        return this.newPassedChannel;
    }

    public void setNewPassedChannel(Boolean newNewPassedChannel) {
        Boolean oldNewPassedChannel = this.newPassedChannel;
        this.newPassedChannel = newNewPassedChannel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldNewPassedChannel, (Object)this.newPassedChannel));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getNewPassedChannel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setNewPassedChannel((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setNewPassedChannel(NEW_PASSED_CHANNEL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return NEW_PASSED_CHANNEL_EDEFAULT == null ? this.newPassedChannel != null : !NEW_PASSED_CHANNEL_EDEFAULT.equals(this.newPassedChannel);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (newPassedChannel: ");
        result.append(this.newPassedChannel);
        result.append(')');
        return result.toString();
    }
}

