/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.Sequence;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.session.internal.InternalSession;

public class SequenceImpl
extends StructuralTypeImpl
implements Sequence {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return false;
    }

    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                this.completed(session);
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            logger.severe("Sequence could not find completed child");
        }
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        int pos = 0;
        if (after != null && (pos = this.getActivityTypes().indexOf((Object)after)) != -1) {
            ++pos;
        }
        if (pos != -1) {
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (ret == null) {
                ret = this.getEndOfSequenceMessageRelevantActivities(scope);
            }
        }
        return ret;
    }

    protected List getEndOfSequenceMessageRelevantActivities(BehaviorTypeImpl scope) {
        List ret = null;
        if (this.getParentImpl() instanceof ActivityTypeImpl && scope != this) {
            ret = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, null);
        }
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.sequenceStart(this);
        super.visit(visitor);
        visitor.sequenceEnd(this);
    }

    protected SequenceImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.SEQUENCE;
    }
}

