/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageActivity;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.NameSpace;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.InformationTypeImpl;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.util.BehaviorTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionImpl
extends BehaviorTypeImpl
implements ServiceDescription {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedQName = null;
    private boolean m_enableFQNCaching = false;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final Boolean STATELESS_EDEFAULT = Boolean.FALSE;
    protected Boolean stateless = STATELESS_EDEFAULT;
    protected EList<NameSpace> nameSpaces;
    protected EList<ServiceType> serviceTypes;
    protected EList<BehaviorDescription> behaviorDescriptions;
    protected EList<InformationType> informationTypes;

    @Override
    public void setName(String newName) {
        super.setName(newName);
        this.m_cachedQName = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cleared cached qname for " + this);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.m_cachedQName == null || !this.m_enableFQNCaching) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getName(), this);
            String localpart = XMLUtils.getLocalname((String)this.getName());
            this.m_cachedQName = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Caching qname=" + this.m_cachedQName + " for " + this);
            }
        }
        return this.m_cachedQName;
    }

    public void validate(ModelListener l, ValidationContext context) throws ValidationException {
        if (l == null) {
            throw new ValidationException("Model listener must be provided");
        }
        this.validateBehaviorType(l, context);
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.getStateless() != Boolean.TRUE) {
            boolean f_rootFound = false;
            boolean f_defaultParticipant = false;
            Vector<String> participantNames = new Vector<String>();
            int i = 0;
            while (i < this.getBehaviorDescriptions().size()) {
                BehaviorDescription bd = (BehaviorDescription)this.getBehaviorDescriptions().get(i);
                if (bd.getRoot() == Boolean.TRUE) {
                    f_rootFound = true;
                    if (NamesUtil.isSet((String)bd.getParticipant())) {
                        if (participantNames.contains(bd.getParticipant())) {
                            l.report((Object)this, ServiceDescriptionImpl.getMessage("_DUPLICATE_ROOT_PARTICIPANTS", new String[]{bd.getParticipant()}), 2);
                        } else {
                            participantNames.add(bd.getParticipant());
                        }
                    } else {
                        if (f_defaultParticipant) {
                            l.report((Object)this, ServiceDescriptionImpl.getMessage("_SINGLE_ROOT_UNSPECIFIED_PARTICIPANT", null), 2);
                        }
                        f_defaultParticipant = true;
                    }
                }
                ++i;
            }
            if (!f_rootFound) {
                l.report((Object)this, ServiceDescriptionImpl.getMessage("_NO_INITIAL_BEHAVIOR", null), 2);
            }
        }
    }

    @Override
    public void initialize(ExtensionResolver resolver) throws ExtensionException {
        if (this.getStateless() != Boolean.TRUE) {
            super.initialize(resolver);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Skipping initialization of extension resolver due to stateless service");
        }
    }

    @Override
    public void initialize() throws ServiceException {
        this.cleanupElements();
        super.initialize();
    }

    @Override
    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
        int i = 0;
        while (i < this.getBehaviorDescriptions().size()) {
            BehaviorDescriptionImpl act = (BehaviorDescriptionImpl)this.getBehaviorDescriptions().get(i);
            if (act.getRoot() == Boolean.TRUE) {
                List acts = act.getNextMessageRelevantActivities(null, true, null, null);
                for (Object obj : acts) {
                    if (!(obj instanceof MessageActivity)) continue;
                    MessageActivity ma = (MessageActivity)obj;
                    ServiceType st = null;
                    if (ma.getChannel() != null) {
                        st = ma.getChannel().getServiceType();
                    }
                    if (ma.getClassification() == MessageClassification.RESPONSE) {
                        logger.warning("Initial message activity is a response (can only be request or notification): " + ma);
                        continue;
                    }
                    if (st == null) continue;
                    String mtype = null;
                    if (ma.getMessageDefinition().getInformationType() != null && !NamesUtil.isSet((String)(mtype = ma.getMessageDefinition().getInformationType().getFullyQualifiedType()))) {
                        mtype = ma.getMessageDefinition().getInformationType().getFullyQualifiedElement();
                    }
                    List ops = null;
                    ops = ma.getClassification() == MessageClassification.REQUEST ? st.getOperationDefinitions(ma.getOperationName(), mtype, null) : st.getNotificationDefinitions(ma.getOperationName(), mtype);
                    if (ops != null && ops.size() == 1) {
                        OperationDefinition opdef = (OperationDefinition)ops.get(0);
                        if (opdef != null && ma.getClassification() == MessageClassification.REQUEST && opdef.getRequest().getInformationType() instanceof InformationTypeImpl) {
                            ((InformationTypeImpl)opdef.getRequest().getInformationType()).setCanInitiateSession(true);
                            continue;
                        }
                        if (opdef != null && ma.getClassification() == MessageClassification.NOTIFICATION && opdef.getNotification().getInformationType() instanceof InformationTypeImpl) {
                            ((InformationTypeImpl)opdef.getNotification().getInformationType()).setCanInitiateSession(true);
                            continue;
                        }
                        logger.warning("Operation definition for initial message activity '" + ma + "' could not be found");
                        continue;
                    }
                    logger.severe("Failed to find single operation definition for '" + ma + "'");
                }
            }
            ++i;
        }
    }

    @Override
    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, UnresolvedConstraintException, LockedInformationException, OutOfSequenceMessageException {
        return super.processEvent(session, event);
    }

    @Override
    public boolean isServiceTypeRelevant(String serviceType) {
        boolean ret = false;
        if (this.getServiceType(serviceType) != null) {
            ret = true;
        }
        return ret;
    }

    @Override
    public ServiceType getServiceType(String name) {
        ServiceType ret = null;
        Iterator iter = this.getServiceTypes().iterator();
        while (ret == null && iter.hasNext()) {
            ServiceType st = (ServiceType)iter.next();
            if (st.getFullyQualifiedName() == null || !st.getFullyQualifiedName().equals(name)) continue;
            ret = st;
        }
        return ret;
    }

    @Override
    public BehaviorDescription getBehaviorDescription(String name) {
        BehaviorDescription ret = null;
        Iterator iter = this.getBehaviorDescriptions().iterator();
        while (ret == null && iter.hasNext()) {
            BehaviorDescription bd = (BehaviorDescription)iter.next();
            if (bd.getName() == null || !bd.getName().equals(name)) continue;
            ret = bd;
        }
        return ret;
    }

    @Override
    protected ServiceDescriptionImpl getServiceDescriptionImpl() {
        return this;
    }

    @Override
    public void visit(BehaviorVisitor visitor) {
        visitor.serviceDescriptionStart(this);
        super.visit(visitor);
        visitor.serviceDescriptionEnd(this);
    }

    @Override
    public boolean canBeInitiated() {
        boolean ret = false;
        int i = 0;
        while (!ret && i < this.getBehaviorDescriptions().size()) {
            BehaviorDescriptionImpl bd = (BehaviorDescriptionImpl)this.getBehaviorDescriptions().get(i);
            if (bd.canBeInitiated()) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public MessageActivity[] getInitialMessageActivities() {
        Object[] ret = null;
        Vector results = new Vector();
        int i = 0;
        while (i < this.getBehaviorDescriptions().size()) {
            BehaviorDescriptionImpl act = (BehaviorDescriptionImpl)this.getBehaviorDescriptions().get(i);
            if (act.getRoot() == Boolean.TRUE) {
                List acts = act.getNextMessageRelevantActivities(null, true, null, null);
                for (Object obj : acts) {
                    if (!(obj instanceof MessageActivity)) continue;
                    results.add(obj);
                }
            }
            ++i;
        }
        ret = new MessageActivity[results.size()];
        results.copyInto(ret);
        return ret;
    }

    public MessageActivity[] getInitialMessageActivities(String participant) {
        MessageActivity[] ret = null;
        BehaviorDescription bd = this.getBehaviorDescription(participant);
        if (bd != null) {
            ret = bd.getInitialMessageActivities();
        }
        if (ret == null) {
            ret = new MessageActivity[]{};
        }
        return ret;
    }

    @Override
    public BehaviorDescription getInitialBehaviorDescription(String participant) {
        BehaviorDescription ret = null;
        Vector<BehaviorDescription> roots = new Vector<BehaviorDescription>();
        if (!NamesUtil.isSet((String)participant)) {
            participant = null;
        }
        int i = 0;
        while (ret == null && i < this.getBehaviorDescriptions().size()) {
            BehaviorDescription bd = (BehaviorDescription)this.getBehaviorDescriptions().get(i);
            if (bd.getRoot() == Boolean.TRUE) {
                if (participant == null && bd.getParticipant() == null || participant != null && bd.getParticipant() != null && participant.equals(bd.getParticipant())) {
                    ret = bd;
                } else {
                    roots.add(bd);
                }
            }
            ++i;
        }
        if (ret == null && participant == null && roots.size() == 1) {
            ret = (BehaviorDescription)roots.get(0);
        }
        return ret;
    }

    @Override
    public String getNameSpaceURIForPrefix(String prefix) {
        String ret = null;
        Iterator iter = this.getNameSpaces().iterator();
        while (ret == null && iter.hasNext()) {
            NameSpace ns = (NameSpace)iter.next();
            if (!ns.getPrefix().equals(prefix)) continue;
            ret = ns.getURI();
        }
        return ret;
    }

    @Override
    public String getNameSpacePrefixForURI(String uri) {
        String ret = null;
        Iterator iter = this.getNameSpaces().iterator();
        while (ret == null && iter.hasNext()) {
            NameSpace ns = (NameSpace)iter.next();
            if (!ns.getURI().equals(uri)) continue;
            ret = ns.getPrefix();
        }
        return ret;
    }

    @Override
    public List getParticipantNames() {
        Vector<String> ret = new Vector<String>();
        for (BehaviorDescription bd : this.getBehaviorDescriptions()) {
            if (bd.getRoot() != Boolean.TRUE) continue;
            String participant = bd.getParticipant();
            if (participant == null) {
                participant = "";
            }
            ret.add(participant);
        }
        return ret;
    }

    @Override
    public InformationType getInformationType(String name) {
        InformationType ret = null;
        Iterator iter = this.getInformationTypes().iterator();
        while (ret == null && iter.hasNext()) {
            InformationType it = (InformationType)iter.next();
            if (it.getName() == null || !it.getName().equals(name)) continue;
            ret = it;
        }
        return ret;
    }

    protected ServiceDescriptionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.SERVICE_DESCRIPTION;
    }

    @Override
    public Boolean getStateless() {
        return this.stateless;
    }

    @Override
    public void setStateless(Boolean newStateless) {
        Boolean oldStateless = this.stateless;
        this.stateless = newStateless;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStateless, (Object)this.stateless));
        }
    }

    @Override
    public EList<NameSpace> getNameSpaces() {
        if (this.nameSpaces == null) {
            this.nameSpaces = new EObjectContainmentEList(NameSpace.class, (InternalEObject)this, 4);
        }
        return this.nameSpaces;
    }

    @Override
    public EList<ServiceType> getServiceTypes() {
        if (this.serviceTypes == null) {
            this.serviceTypes = new EObjectContainmentEList(ServiceType.class, (InternalEObject)this, 5);
        }
        return this.serviceTypes;
    }

    @Override
    public EList<BehaviorDescription> getBehaviorDescriptions() {
        if (this.behaviorDescriptions == null) {
            this.behaviorDescriptions = new EObjectContainmentEList(BehaviorDescription.class, (InternalEObject)this, 6);
        }
        return this.behaviorDescriptions;
    }

    @Override
    public EList<InformationType> getInformationTypes() {
        if (this.informationTypes == null) {
            this.informationTypes = new EObjectContainmentEList(InformationType.class, (InternalEObject)this, 7);
        }
        return this.informationTypes;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getNameSpaces()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getServiceTypes()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getBehaviorDescriptions()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getInformationTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getVersion();
            }
            case 3: {
                return this.getStateless();
            }
            case 4: {
                return this.getNameSpaces();
            }
            case 5: {
                return this.getServiceTypes();
            }
            case 6: {
                return this.getBehaviorDescriptions();
            }
            case 7: {
                return this.getInformationTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setVersion((String)newValue);
                return;
            }
            case 3: {
                this.setStateless((Boolean)newValue);
                return;
            }
            case 4: {
                this.getNameSpaces().clear();
                this.getNameSpaces().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getServiceTypes().clear();
                this.getServiceTypes().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getBehaviorDescriptions().clear();
                this.getBehaviorDescriptions().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getInformationTypes().clear();
                this.getInformationTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 3: {
                this.setStateless(STATELESS_EDEFAULT);
                return;
            }
            case 4: {
                this.getNameSpaces().clear();
                return;
            }
            case 5: {
                this.getServiceTypes().clear();
                return;
            }
            case 6: {
                this.getBehaviorDescriptions().clear();
                return;
            }
            case 7: {
                this.getInformationTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 3: {
                return STATELESS_EDEFAULT == null ? this.stateless != null : !STATELESS_EDEFAULT.equals(this.stateless);
            }
            case 4: {
                return this.nameSpaces != null && !this.nameSpaces.isEmpty();
            }
            case 5: {
                return this.serviceTypes != null && !this.serviceTypes.isEmpty();
            }
            case 6: {
                return this.behaviorDescriptions != null && !this.behaviorDescriptions.isEmpty();
            }
            case 7: {
                return this.informationTypes != null && !this.informationTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", stateless: ");
        result.append(this.stateless);
        result.append(')');
        return result.toString();
    }
}

