/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.util.BehaviorTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTypeImpl
extends BehaviorTypeImpl
implements ServiceType {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private String m_cachedQName = null;
    private boolean m_enableFQNCaching = false;
    private boolean m_serviceProvider = false;
    private boolean m_serviceClient = false;
    private Map m_messageTypeCache = null;
    protected EList<OperationDefinition> operationDefinitions;

    @Override
    public void setName(String newName) {
        super.setName(newName);
        this.m_cachedQName = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cleared cached qname for " + this);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.m_cachedQName == null || !this.m_enableFQNCaching) {
            String namespace = BehaviorTypeUtil.getNamespace(this.getName(), this);
            String localpart = XMLUtils.getLocalname((String)this.getName());
            this.m_cachedQName = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Caching qname=" + this.m_cachedQName + " for " + this);
            }
        }
        return this.m_cachedQName;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        super.initializeElement();
        this.m_enableFQNCaching = true;
        this.m_messageTypeCache = new Hashtable();
        for (OperationDefinition op : this.getOperationDefinitions()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Initialize message cache for op=" + op + " messageTypeCache=" + this.m_messageTypeCache);
            }
            int i = 0;
            while (i < op.getMessageDefinitions().size()) {
                MessageDefinition mdef = (MessageDefinition)op.getMessageDefinitions().get(i);
                if (mdef.getInformationType() != null) {
                    String fqtype = mdef.getInformationType().getFullyQualifiedType();
                    if (!NamesUtil.isSet((String)fqtype)) {
                        fqtype = mdef.getInformationType().getFullyQualifiedElement();
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("fqtype=" + fqtype);
                    }
                    if (fqtype != null) {
                        Vector<OperationDefinition> list = (Vector<OperationDefinition>)this.m_messageTypeCache.get(fqtype);
                        if (list == null) {
                            list = new Vector<OperationDefinition>();
                            this.m_messageTypeCache.put(fqtype, list);
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("added new message cache entry for fqtype=" + fqtype);
                            }
                        }
                        if (fqtype != null && !list.contains(op)) {
                            list.add(op);
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("added op=" + op + " to message cache entry for fqtype=" + fqtype);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public List getOperationDefinitions(String name, String requestType, String responseType) {
        Vector<OperationDefinition> ret = new Vector<OperationDefinition>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Get operation defns for name=" + name + " reqType=" + requestType + " respType=" + responseType);
        }
        Iterator iter = null;
        if (this.m_messageTypeCache != null && (requestType == null && responseType != null || responseType == null && requestType != null)) {
            List main = null;
            if (requestType != null) {
                main = (List)this.m_messageTypeCache.get(requestType);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Using request type '" + requestType + "' cached list: " + main + " messageTypeCache=" + this.m_messageTypeCache);
                }
            }
            if (responseType != null) {
                main = (List)this.m_messageTypeCache.get(responseType);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Using response type '" + responseType + "' cached list: " + main + " messageTypeCache=" + this.m_messageTypeCache);
                }
            }
            if (main != null) {
                iter = main.iterator();
            }
        } else {
            iter = this.getOperationDefinitions().iterator();
        }
        while (iter != null && iter.hasNext()) {
            OperationDefinition op = (OperationDefinition)iter.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Check opdef=" + op);
            }
            if (name != null && !op.getName().equals(name)) continue;
            boolean reqFound = requestType == null;
            boolean respFound = responseType == null;
            Iterator miter = op.getMessageDefinitions().iterator();
            while (!(reqFound && respFound || !miter.hasNext())) {
                MessageDefinition mdef = (MessageDefinition)miter.next();
                if (mdef.getInformationType() == null) continue;
                String type = mdef.getInformationType().getFullyQualifiedType();
                if (!NamesUtil.isSet((String)type)) {
                    type = mdef.getInformationType().getFullyQualifiedElement();
                }
                if (!reqFound && type != null && mdef.getClassification() == MessageClassification.REQUEST && type.equals(requestType)) {
                    reqFound = true;
                    continue;
                }
                if (respFound || type == null || mdef.getClassification() != MessageClassification.RESPONSE || !type.equals(responseType)) continue;
                respFound = true;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Result requestFound=" + reqFound + " responseFound=" + respFound);
            }
            if (!reqFound || !respFound) continue;
            ret.add(op);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning " + ret.size() + " operation definitions");
        }
        return ret;
    }

    @Override
    public List getNotificationDefinitions(String name, String type) {
        Vector<OperationDefinition> ret = new Vector<OperationDefinition>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Get notification operation defns for name=" + name + " type=" + type);
        }
        Iterator iter = null;
        if (this.m_messageTypeCache != null) {
            List list = (List)this.m_messageTypeCache.get(type);
            if (list != null) {
                iter = list.iterator();
            }
        } else {
            iter = this.getOperationDefinitions().iterator();
        }
        while (iter != null && iter.hasNext()) {
            MessageDefinition mdef;
            OperationDefinition op = (OperationDefinition)iter.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Check opdef=" + op);
            }
            if (name != null && !op.getName().equals(name) || op.getMessageDefinitions().size() != 1 || (mdef = (MessageDefinition)op.getMessageDefinitions().get(0)).getClassification() != MessageClassification.NOTIFICATION || mdef.getInformationType() == null) continue;
            String fqtype = mdef.getInformationType().getFullyQualifiedType();
            if (!NamesUtil.isSet((String)fqtype)) {
                fqtype = mdef.getInformationType().getFullyQualifiedElement();
            }
            if (type != null && !fqtype.equals(type)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Notification found");
            }
            ret.add(op);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning " + ret.size() + " notification based operation definitions");
        }
        return ret;
    }

    @Override
    public boolean isServiceProvider() {
        return this.m_serviceProvider;
    }

    public void setServiceProvider(boolean provider) {
        this.m_serviceProvider = provider;
    }

    @Override
    public boolean isServiceClient() {
        return this.m_serviceClient;
    }

    public void setServiceClient(boolean client) {
        this.m_serviceClient = client;
    }

    protected ServiceTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.SERVICE_TYPE;
    }

    @Override
    public EList<OperationDefinition> getOperationDefinitions() {
        if (this.operationDefinitions == null) {
            this.operationDefinitions = new EObjectContainmentEList(OperationDefinition.class, (InternalEObject)this, 2);
        }
        return this.operationDefinitions;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getOperationDefinitions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getOperationDefinitions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getOperationDefinitions().clear();
                this.getOperationDefinitions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getOperationDefinitions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.operationDefinitions != null && !this.operationDefinitions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

