/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.LookaheadElement;
import org.pi4soa.service.session.internal.Predicate;

public class SessionEndPredicateImpl
extends PredicateImpl {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private boolean m_messageLookaheadPredicate = false;
    private boolean m_recvOnlyLookaheadPredicates = false;
    private List m_activityList = null;
    private boolean m_initialized = false;

    public SessionEndPredicateImpl(List activityList) {
        this.m_activityList = activityList;
    }

    public boolean isSatisfied(InternalSession session, ServiceEvent evt) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        boolean ret = false;
        Predicate[] preds = session.getPostConditions();
        if (preds != null && preds.length > 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Evaluate " + preds.length + " session end predicate(s)");
            }
            int i = 0;
            while (!ret && i < preds.length) {
                block16: {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Evaluating " + preds[i]);
                        }
                        if (preds[i] instanceof SessionEndPredicateImpl) {
                            InternalSession parent = null;
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Predicate '" + preds[i] + "' is another " + "session end predicate, apply to parent session");
                            }
                            if (session.isBehavioralSession()) {
                                parent = session.getParent();
                            } else {
                                parent = session.getBehavioralSessionParent();
                                if (parent != null) {
                                    parent = parent.getParent();
                                }
                            }
                            if (parent != null) {
                                ret = preds[i].isSatisfied(parent, evt);
                            } else {
                                logger.severe("Session end predicate had no parent session");
                            }
                        } else {
                            ret = preds[i].isSatisfied(session, evt);
                        }
                    }
                    catch (UnresolvedConstraintException uce) {
                        if (!logger.isLoggable(Level.FINEST)) break block16;
                        logger.finest("Predicate '" + preds[i] + "' returned unresolved constraint exception: " + uce);
                    }
                }
                ++i;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Evaluated session end predicate=" + ret);
            }
            if (!ret) {
                throw new UnresolvedConstraintException();
            }
        }
        return ret;
    }

    protected synchronized void initialize() {
        if (!this.m_initialized) {
            this.m_initialized = true;
            if (this.m_activityList != null && this.m_activityList.size() > 0) {
                this.m_messageLookaheadPredicate = true;
                this.m_recvOnlyLookaheadPredicates = true;
                int i = 0;
                while (this.m_messageLookaheadPredicate && i < this.m_activityList.size()) {
                    if (this.m_activityList.get(i) instanceof LookaheadElement) {
                        List preds = ((LookaheadElement)this.m_activityList.get(i)).getPostConditions();
                        boolean mesgbased = false;
                        int j = 0;
                        while (j < preds.size()) {
                            Predicate pred = (Predicate)preds.get(j);
                            if (pred.isMessagePredicate()) {
                                mesgbased = true;
                                if (!pred.isReceiveLookaheadPredicate()) {
                                    this.m_recvOnlyLookaheadPredicates = false;
                                }
                            }
                            ++j;
                        }
                        if (!mesgbased) {
                            this.m_messageLookaheadPredicate = false;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isMessagePredicate() {
        this.initialize();
        return this.m_messageLookaheadPredicate;
    }

    public boolean isReceiveLookaheadPredicate() {
        this.initialize();
        return this.m_recvOnlyLookaheadPredicates;
    }
}

