/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.TimedUnit;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.behavior.impl.StructuralTypeImpl;
import org.pi4soa.service.behavior.impl.XPathConditionImpl;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.Predicate;
import org.pi4soa.service.session.internal.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedUnitImpl
extends StructuralTypeImpl
implements TimedUnit,
InternalSessionListener {
    protected static final String TIME_TO_COMPLETE_EDEFAULT = null;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private PredicateImpl m_timeToCompletePredicate = null;
    protected String timeToComplete = TIME_TO_COMPLETE_EDEFAULT;
    protected EList<ActivityType> timeoutActivityTypes;

    @Override
    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException, OutOfSequenceMessageException {
        boolean ret = false;
        if (this.getActivityTypes().size() > 0) {
            InternalSession subsession = SessionFactory.getScopedSession(session);
            subsession.setInternalSessionListener(this);
            subsession.schedule((ActivityTypeImpl)this.getActivityTypes().get(0));
            ret = subsession.process(event);
        } else {
            this.completed(session);
        }
        this.unschedule(session);
        return ret;
    }

    @Override
    public void sessionListenerRegistered(InternalSession session) {
        Vector<PredicateImpl> predicates = new Vector<PredicateImpl>();
        predicates.add(this.getTimeToCompletePredicate());
        List list = null;
        if (this.getTimeoutActivityTypes().size() > 0) {
            list = ((ActivityTypeImpl)this.getTimeoutActivityTypes().get(0)).getNextMessageRelevantActivities(null, false, null, null);
        } else if (this.getParentImpl() instanceof ActivityTypeImpl) {
            list = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, true, null, null);
        }
        this.initializeConditions(list, predicates);
        Predicate[] preds = new Predicate[predicates.size()];
        predicates.toArray(preds);
        session.setCompletionPredicates(preds);
    }

    @Override
    public void sessionFinished(InternalSession session) throws ServiceException {
        if (session.getTerminatingException() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Propagating exception '" + session.getTerminatingException() + "'");
            }
            session.clearTimeouts(this.getEndpointDescriptionURI());
            this.handleException(session.getParent(), session.getTerminatingException());
        } else if (session.isEarlyCompletion()) {
            if (this.getTimeoutActivityTypes().size() > 0) {
                session.getParent().schedule((ActivityTypeImpl)this.getTimeoutActivityTypes().get(0));
            } else {
                this.completed(session.getParent());
            }
        } else {
            session.clearTimeouts(this.getEndpointDescriptionURI());
            this.completed(session.getParent());
        }
    }

    @Override
    protected void childCompleted(InternalSession session, BehaviorTypeImpl child) throws ServiceException {
        int pos = this.getActivityTypes().indexOf((Object)child);
        if (pos != -1) {
            if (++pos == this.getActivityTypes().size()) {
                session.sessionCompleted();
            } else {
                session.schedule((ActivityTypeImpl)this.getActivityTypes().get(pos));
            }
        } else {
            pos = this.getTimeoutActivityTypes().indexOf((Object)child);
            if (pos != -1) {
                if (++pos == this.getTimeoutActivityTypes().size()) {
                    this.completed(session);
                } else {
                    session.schedule((ActivityTypeImpl)this.getTimeoutActivityTypes().get(pos));
                }
            } else {
                logger.severe("Timed Unit could not find completed child");
            }
        }
    }

    @Override
    protected List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        int pos = 0;
        if (after != null && (pos = this.getActivityTypes().indexOf((Object)after)) != -1) {
            ++pos;
        }
        if (pos != -1) {
            int i = pos;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, path);
                ++i;
            }
            if (ret == null && this.getParentImpl() instanceof ActivityTypeImpl && scope != this) {
                ret = ((ActivityTypeImpl)this.getParentImpl()).getNextMessageRelevantActivities(this, false, scope, path);
            }
        }
        return ret;
    }

    @Override
    protected boolean isBlockingActivity() {
        return true;
    }

    @Override
    protected void initializeElement() throws ServiceException {
        if (this.isSet(this.getTimeToComplete())) {
            XPathConditionImpl xpath = new XPathConditionImpl(this);
            xpath.setExpression(this.getTimeToComplete());
            xpath.setBlockingPredicate(this.isBlockingActivity());
            this.m_timeToCompletePredicate = xpath;
        }
        super.initializeElement();
    }

    public PredicateImpl getTimeToCompletePredicate() {
        return this.m_timeToCompletePredicate;
    }

    @Override
    public void visit(BehaviorVisitor visitor) {
        visitor.timedUnitStart(this);
        super.visit(visitor);
        visitor.timedUnitEnd(this);
    }

    protected TimedUnitImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.TIMED_UNIT;
    }

    @Override
    public String getTimeToComplete() {
        return this.timeToComplete;
    }

    @Override
    public void setTimeToComplete(String newTimeToComplete) {
        String oldTimeToComplete = this.timeToComplete;
        this.timeToComplete = newTimeToComplete;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTimeToComplete, (Object)this.timeToComplete));
        }
    }

    @Override
    public EList<ActivityType> getTimeoutActivityTypes() {
        if (this.timeoutActivityTypes == null) {
            this.timeoutActivityTypes = new EObjectContainmentEList(ActivityType.class, (InternalEObject)this, 4);
        }
        return this.timeoutActivityTypes;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getTimeoutActivityTypes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getTimeToComplete();
            }
            case 4: {
                return this.getTimeoutActivityTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setTimeToComplete((String)newValue);
                return;
            }
            case 4: {
                this.getTimeoutActivityTypes().clear();
                this.getTimeoutActivityTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setTimeToComplete(TIME_TO_COMPLETE_EDEFAULT);
                return;
            }
            case 4: {
                this.getTimeoutActivityTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return TIME_TO_COMPLETE_EDEFAULT == null ? this.timeToComplete != null : !TIME_TO_COMPLETE_EDEFAULT.equals(this.timeToComplete);
            }
            case 4: {
                return this.timeoutActivityTypes != null && !this.timeoutActivityTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (timeToComplete: ");
        result.append(this.timeToComplete);
        result.append(')');
        return result.toString();
    }
}

