/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorVisitor;
import org.pi4soa.service.behavior.When;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.BehaviorTypeImpl;
import org.pi4soa.service.behavior.impl.RepetitionTypeImpl;
import org.pi4soa.service.behavior.impl.WhenReEvaluation;
import org.pi4soa.service.session.internal.InternalSession;

public class WhenImpl
extends RepetitionTypeImpl
implements When {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    protected static final Boolean RE_EVALUATE_EDEFAULT = Boolean.FALSE;
    protected Boolean reEvaluate = RE_EVALUATE_EDEFAULT;

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (NamesUtil.isSet((String)this.getReEvaluateExpression()) && this.getReEvaluate() != Boolean.TRUE) {
            l.report((Object)this, WhenImpl.getMessage("_REEVALUATE_NOT_ENABLED", null), 2);
        }
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        boolean ret = false;
        ret = this.internalCanProcess(session, event);
        return ret;
    }

    protected boolean internalCanProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        boolean ret = super.canProcess(session, event);
        if (!ret && session.getConfiguration().getEvaluateState()) {
            throw new UnresolvedConstraintException();
        }
        return ret;
    }

    protected boolean getDefaultShouldSkipValue(InternalSession session) {
        boolean ret = false;
        return ret;
    }

    protected boolean shouldSkipNode(InternalSession session, ServiceEvent event) throws ServiceException {
        boolean ret = false;
        return ret;
    }

    protected boolean shouldRepeat(InternalSession session) throws ServiceException {
        boolean ret = false;
        if (this.getReEvaluate() == Boolean.TRUE) {
            ret = super.shouldRepeat(session);
        }
        return ret;
    }

    protected void repeatActivity(InternalSession session) {
        if (!session.getConfiguration().getEvaluateState() || this.isReEvaluateExpressionNonObservable()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Repeat activity (when re-eval) '" + this + "' session=" + session);
            }
            session.schedule(new WhenReEvaluation(this));
        } else {
            super.repeatActivity(session);
        }
    }

    protected boolean isBlockingActivity() {
        return true;
    }

    public List getNextMessageRelevantActivities(BehaviorTypeImpl after, boolean local, BehaviorTypeImpl scope, List path) {
        List ret = null;
        if (after == null) {
            int i = 0;
            while (ret == null && i < this.getActivityTypes().size()) {
                ActivityTypeImpl act = (ActivityTypeImpl)this.getActivityTypes().get(i);
                ret = act.getNextMessageRelevantActivities(null, false, scope, null);
                ++i;
            }
        } else {
            ret = super.getNextMessageRelevantActivities(after, local, scope, null);
        }
        return ret;
    }

    protected boolean isReEvaluateExpressionNonObservable() {
        boolean ret = false;
        if (!NamesUtil.isSet((String)this.getReEvaluateExpression()) && this.getReEvaluate() == Boolean.TRUE) {
            ret = true;
        }
        return ret;
    }

    protected void unschedule(InternalSession session) {
        super.unschedule(session);
        session.clearTimeouts(this.getEndpointDescriptionURI());
    }

    public boolean isConditionalGroupingConstruct() {
        return true;
    }

    protected boolean usePreConditionsOnly() {
        return true;
    }

    public boolean isReEvaluationPredicateExtensionRequired() {
        boolean ret = this.getReEvaluate() == Boolean.TRUE && (super.isReEvaluationPredicateExtensionRequired() || this.isReEvaluateExpressionNonObservable() && !this.isOnlyReceivePostLookheadConditions());
        return ret;
    }

    public void visit(BehaviorVisitor visitor) {
        visitor.whenStart(this);
        super.visit(visitor);
        visitor.whenEnd(this);
    }

    protected boolean handlesUnresolvedConstraint() {
        return true;
    }

    protected void cleanup() {
        super.cleanup();
    }

    protected WhenImpl() {
    }

    protected EClass eStaticClass() {
        return BehaviorPackage.Literals.WHEN;
    }

    public Boolean getReEvaluate() {
        return this.reEvaluate;
    }

    public void setReEvaluate(Boolean newReEvaluate) {
        Boolean oldReEvaluate = this.reEvaluate;
        this.reEvaluate = newReEvaluate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldReEvaluate, (Object)this.reEvaluate));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getReEvaluate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setReEvaluate((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setReEvaluate(RE_EVALUATE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return RE_EVALUATE_EDEFAULT == null ? this.reEvaluate != null : !RE_EVALUATE_EDEFAULT.equals(this.reEvaluate);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (reEvaluate: ");
        result.append(this.reEvaluate);
        result.append(')');
        return result.toString();
    }
}

