/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.ActivityTypeImpl;
import org.pi4soa.service.behavior.impl.WhenImpl;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.ResumableBehaviorElement;
import org.pi4soa.service.session.internal.SessionConfiguration;

public class WhenReEvaluation
implements ResumableBehaviorElement,
Externalizable {
    private static final long serialVersionUID = -6338480089374130711L;
    private static final int SERIALIZATION_VERSION = 1;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private transient WhenImpl m_when = null;
    private String m_whenId = null;

    public WhenReEvaluation() {
    }

    public WhenReEvaluation(WhenImpl when) {
        this.m_when = when;
    }

    public WhenImpl getWhenImpl() {
        return this.m_when;
    }

    public String getId() {
        return String.valueOf(this.getClass().getSimpleName()) + ":" + this.m_whenId;
    }

    public void scheduled(InternalSession session) {
    }

    public boolean process(InternalSession session, ServiceEvent event) throws ServiceException {
        boolean ret = false;
        boolean processed = false;
        boolean postpone = false;
        try {
            if (this.canProcess(session, event)) {
                ret = this.processEvent(session, event);
                processed = true;
            }
        }
        catch (LockedInformationException lockedInformationException) {
            postpone = true;
        }
        catch (UnresolvedConstraintException unresolvedConstraintException) {
        }
        catch (ServiceException se) {
            ExceptionEvent evt = new ExceptionEvent(se.getExceptionType());
            logger.severe("Converting service exception '" + se + "' into exception event");
            if (session.getConfiguration().getServiceTracker() != null) {
                session.getConfiguration().getServiceTracker().error(session, se.getMessage(), se);
            }
            this.m_when.handleException(session, evt);
            processed = true;
        }
        if (!postpone && !processed && this.m_when.evaluatePostConditions(session, event)) {
            this.m_when.completed(session);
            this.unschedule(session);
        }
        return ret;
    }

    protected void unschedule(InternalSession session) {
        session.unschedule(this);
        session.clearTimeouts(this.m_when.getEndpointDescriptionURI());
    }

    protected boolean processEvent(InternalSession session, ServiceEvent event) throws ServiceException {
        if (this.m_when.getActivityTypes().size() > 0) {
            session.schedule((ActivityTypeImpl)this.m_when.getActivityTypes().get(0));
            this.unschedule(session);
        } else {
            this.unschedule(session);
            this.m_when.completed(session);
        }
        return false;
    }

    public boolean canProcess(InternalSession session, ServiceEvent event) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        boolean postconds;
        if (this.m_when.isReEvaluateExpressionNonObservable() && (postconds = this.m_when.evaluatePostConditions(session, event))) {
            throw new UnresolvedConstraintException();
        }
        return this.m_when.internalCanProcess(session, event);
    }

    public void initialize(ExtensionResolver resolver) throws ExtensionException {
    }

    public void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        if (logger.isLoggable(Level.FINER)) {
            logger.info("Resume choice for '" + sdesc + "': Locating when " + "element for id '" + this.m_whenId + "'");
        }
        if (this.m_whenId != null) {
            this.m_when = (WhenImpl)config.getSessionComponentResolver().getBehaviorElement(sdesc, this.m_whenId);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        String id = null;
        if (this.m_when != null) {
            id = this.m_when.getId();
        }
        out.writeUTF(id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_whenId = in.readUTF();
        }
    }
}

