/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.ExceptionUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.impl.PredicateImpl;
import org.pi4soa.service.behavior.xpath.BehaviorResolver;
import org.pi4soa.service.behavior.xpath.XPathFunctionContext;
import org.pi4soa.service.session.internal.InternalSession;

public class XPathConditionImpl
extends PredicateImpl {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.impl");
    private static final String XPATH_EVALUATION_ERROR = "XPathEvaluationError";
    private ActivityType m_activityType = null;
    private boolean m_blocking = false;
    protected static final String EXPRESSION_EDEFAULT = null;
    protected String m_expression = EXPRESSION_EDEFAULT;

    public XPathConditionImpl(ActivityType acttype) {
        this.m_activityType = acttype;
    }

    public boolean isSatisfied(InternalSession session, ServiceEvent evt) throws UnresolvedConstraintException, LockedInformationException, ServiceException {
        boolean ret = false;
        XPathEvaluator evaluator = session.getConfiguration().getXPathEvaluator();
        try {
            Object value;
            Object context = session;
            if (this.isBlockingPredicate()) {
                XPathFunctionContext xpfc = new XPathFunctionContext();
                xpfc.setActivityType(this.getActivityType());
                xpfc.setSession(session);
                xpfc.setBlockingActivity(true);
                context = xpfc;
            }
            if ((value = evaluator.evaluate(context, this.getExpression(), this.getXMLPrefixResolver())) instanceof Boolean) {
                ret = (Boolean)value;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("SessionID=" + session.getId() + " : XPath expression '" + this.getExpression() + "' evaluated to " + ret);
                }
            } else if (value != null) {
                if (value instanceof String) {
                    if (((String)value).trim().length() > 0) {
                        ret = true;
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("SessionID=" + session.getId() + " : XPath expression '" + this.getExpression() + "' evaluated to string '" + value + "' with result " + ret);
                    }
                } else {
                    logger.warning("SessionID=" + session.getId() + " : XPath expression '" + this.getExpression() + "' evaluated to non-boolean type '" + value.getClass().getName() + "'");
                }
            }
        }
        catch (XPathException xpe) {
            if (xpe.getCause() instanceof UnresolvedConstraintException) {
                throw (UnresolvedConstraintException)xpe.getCause();
            }
            if (xpe.getCause() instanceof LockedInformationException) {
                throw (LockedInformationException)xpe.getCause();
            }
            logger.warning("Failed to evaluate condition: " + (Object)((Object)xpe));
            throw new ServiceException("XPath evaluation failed", ExceptionUtil.getExceptionQName((String)"http://www.pi4soa.org/service", (String)XPATH_EVALUATION_ERROR), xpe);
        }
        return ret;
    }

    public boolean isConditionPredicate() {
        return true;
    }

    protected boolean isBlockingPredicate() {
        return this.m_blocking;
    }

    protected void setBlockingPredicate(boolean blocking) {
        this.m_blocking = blocking;
    }

    protected ActivityType getActivityType() {
        return this.m_activityType;
    }

    protected XMLPrefixResolver getXMLPrefixResolver() {
        XMLPrefixResolver ret = null;
        if (this.m_activityType instanceof XMLPrefixResolver) {
            ret = (XMLPrefixResolver)this.m_activityType;
        } else {
            logger.warning("Unable to find XML prefix resolver for activity type: " + this.m_activityType);
            ret = BehaviorResolver.getInstance();
        }
        return ret;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public void setExpression(String newExpression) {
        this.m_expression = newExpression;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (expression: ");
        result.append(this.m_expression);
        result.append(')');
        return result.toString();
    }
}

