/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.projection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.projection.CDLParticipantProjection;
import org.pi4soa.common.resource.ArtifactManager;
import org.pi4soa.common.resource.FileSystemArtifactManager;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.projection.CDL2ToBehaviorProjector;
import org.pi4soa.service.util.ServiceDescriptionManager;

public class BehaviorProjection {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.projection");

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: BehaviorProjection cdlFilePath participant");
            System.exit(1);
        }
        try {
            ServiceDescription sdesc = BehaviorProjection.projectServiceDescription(args[0], args[1]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ServiceDescriptionManager.save(sdesc, baos);
            System.out.println(baos.toString());
        }
        catch (Exception e) {
            System.err.println("Failed to project service description: " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static ServiceDescription projectServiceDescription(String cdlFilePath, String participant) throws ServiceException {
        ServiceDescription ret = null;
        Package cdlpack = null;
        ParticipantType partType = null;
        try {
            cdlpack = CDLManager.load((String)cdlFilePath);
            if (cdlpack != null) {
                partType = cdlpack.getParticipantType(participant);
                if (partType == null && NameSpaceUtil.isFullyQualifiedName((String)participant)) {
                    String localpart = NameSpaceUtil.getLocalPart((String)participant);
                    partType = cdlpack.getParticipantType(localpart);
                }
                if (partType == null) {
                    logger.severe("CDL model '" + cdlFilePath + "' does not have a participant type '" + participant + "'");
                }
            }
        }
        catch (IOException e) {
            logger.severe("Failed to load CDL '" + cdlFilePath + "': " + e);
        }
        String folderPath = null;
        FileSystemArtifactManager artifacts = null;
        if (cdlFilePath != null) {
            int index = cdlFilePath.lastIndexOf(File.separator);
            int otherindex = cdlFilePath.lastIndexOf("/");
            if (otherindex > index) {
                index = otherindex;
            }
            if (index != -1) {
                folderPath = cdlFilePath.substring(0, index);
                artifacts = new FileSystemArtifactManager(folderPath);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CDL file parent folder: " + folderPath);
            }
        }
        ret = BehaviorProjection.projectServiceDescription(cdlpack, partType, artifacts);
        return ret;
    }

    public static ServiceDescription projectServiceDescription(Package cdlpack, ParticipantType partType, ArtifactManager artifacts) throws ServiceException {
        ServiceDescription ret = null;
        if (partType != null && cdlpack != null) {
            CDL2ToBehaviorProjector behaviorProjection = new CDL2ToBehaviorProjector(partType, artifacts);
            CDLParticipantProjection cdlPartProjection = new CDLParticipantProjection((CDLVisitor)behaviorProjection, partType);
            cdlpack.visit((CDLVisitor)cdlPartProjection);
            ret = behaviorProjection.getServiceDescription();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Project service description: cdl=" + cdlpack + " participantType=" + partType + " ret=" + ret);
        }
        return ret;
    }
}

