/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.projection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.BindDetails;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.CopyDetails;
import org.pi4soa.cdl.DataType;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.NoAction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantBindDetails;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.PassingChannelDetails;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.SilentAction;
import org.pi4soa.cdl.Token;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.WhenType;
import org.pi4soa.cdl.projection.CDLTypeProxy;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.InteractionUtil;
import org.pi4soa.cdl.xpath.XPathProjection;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.Assign;
import org.pi4soa.service.behavior.AtomicUnit;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorFactory;
import org.pi4soa.service.behavior.BehaviorType;
import org.pi4soa.service.behavior.ChannelDeclaration;
import org.pi4soa.service.behavior.Choice;
import org.pi4soa.service.behavior.CompletionHandler;
import org.pi4soa.service.behavior.Conditional;
import org.pi4soa.service.behavior.ExceptionHandler;
import org.pi4soa.service.behavior.Finalize;
import org.pi4soa.service.behavior.Identity;
import org.pi4soa.service.behavior.IdentityType;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.Parallel;
import org.pi4soa.service.behavior.Perform;
import org.pi4soa.service.behavior.RaiseException;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.Sequence;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.StructuralType;
import org.pi4soa.service.behavior.TimedUnit;
import org.pi4soa.service.behavior.Unobservable;
import org.pi4soa.service.behavior.UsageType;
import org.pi4soa.service.behavior.VariableBinding;
import org.pi4soa.service.behavior.VariableDeclaration;
import org.pi4soa.service.behavior.When;
import org.pi4soa.service.behavior.While;
import org.pi4soa.service.behavior.projection.DefaultServiceTypeResolver;
import org.pi4soa.service.behavior.projection.ServiceTypeResolver;
import org.pi4soa.service.util.BehaviorTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDL2ChoreoToBehaviorProjector
implements CDLVisitor {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.projection");
    private static final String SERVICE_ENDPOINT_NS_PREFIX = "sens";
    private ServiceDescription m_serviceDescription = null;
    private BehaviorDescription m_behaviorDescription = null;
    private ParticipantType m_participantType = null;
    private Participant m_participant = null;
    private BehaviorDescription m_parent = null;
    private ServiceTypeResolver m_resolver = new DefaultServiceTypeResolver();
    private BehaviorType m_currentBehaviorType = null;
    private static final boolean CONDITION_PROJECT_SINGLETON = true;

    public CDL2ChoreoToBehaviorProjector(ParticipantType participantType, Participant participant, ServiceDescription sdesc, BehaviorDescription parent, ServiceTypeResolver resolver) {
        this.m_participantType = participantType;
        this.m_serviceDescription = sdesc;
        this.m_participant = participant;
        this.m_parent = parent;
        if (resolver != null) {
            this.m_resolver = resolver;
        }
    }

    public Participant getParticipant() {
        return this.m_participant;
    }

    public BehaviorDescription getBehaviorDescription() {
        return this.m_behaviorDescription;
    }

    public void setBehaviorDescription(BehaviorDescription bd) {
        this.m_behaviorDescription = bd;
    }

    public ServiceDescription getServiceDescription() {
        return this.m_serviceDescription;
    }

    public void assign(org.pi4soa.cdl.Assign assign) {
        if (assign.getParticipant() == this.m_participant && assign.getCopyDetails().size() > 0) {
            Vector<RaiseException> exceptions = new Vector<RaiseException>();
            BehaviorDescription bd = null;
            if (this.getCurrentScopeElement() instanceof ActivityType) {
                bd = ((ActivityType)this.getCurrentScopeElement()).getEnclosingBehaviorDescription();
            }
            if (bd == null) {
                logger.severe("Unable to project assign as no behavioraldescription available");
            }
            AtomicUnit atomic = null;
            if (assign.getCopyDetails().size() > 1) {
                atomic = BehaviorFactory.eINSTANCE.createAtomicUnit();
            }
            int i = 0;
            while (i < assign.getCopyDetails().size()) {
                CopyDetails copy = (CopyDetails)assign.getCopyDetails().get(i);
                Assign elem = BehaviorFactory.eINSTANCE.createAssign();
                elem.setName(copy.getName());
                elem.setDescription(copy.getDescription());
                elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)copy));
                if (this.isSet(copy.getSourceExpression())) {
                    elem.setExpression(this.convertExpression((CDLType)copy, copy.getSourceExpression(), true));
                } else if (copy.getSourceVariable() != null) {
                    elem.setExpression(this.convertGetVariable(copy.getSourceVariable(), copy.getSourceVariablePart()));
                }
                VariableDeclaration vard = bd.getVariable(copy.getTargetVariable().getName());
                elem.setVariable(vard);
                if (this.isSet(copy.getTargetVariablePart())) {
                    elem.setPartName(copy.getTargetVariablePart());
                }
                if (atomic != null) {
                    atomic.getActivityTypes().add((Object)elem);
                } else {
                    this.addToScope(elem);
                }
                if (this.isSet(copy.getCauseException())) {
                    RaiseException raise = BehaviorFactory.eINSTANCE.createRaiseException();
                    raise.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)copy));
                    raise.setExceptionType(this.convertQName((CDLType)copy, copy.getCauseException()));
                    exceptions.add(raise);
                }
                ++i;
            }
            if (atomic != null) {
                this.addToScope(atomic);
            }
            i = 0;
            while (i < exceptions.size()) {
                RaiseException raise = (RaiseException)exceptions.get(i);
                this.addToScope(raise);
                ++i;
            }
        }
    }

    public void choiceStart(org.pi4soa.cdl.Choice choice) {
        Choice elem = BehaviorFactory.eINSTANCE.createChoice();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)choice));
        elem.setName(NamesUtil.getNameFromDescription((String)choice.getDescription()));
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void choiceEnd(org.pi4soa.cdl.Choice choice) {
        Choice elem = (Choice)this.getCurrentScopeElement();
        int i = 0;
        while (i < elem.getActivityTypes().size()) {
            ActivityType at = (ActivityType)elem.getActivityTypes().get(i);
            if (!(at instanceof StructuralType)) {
                Sequence seq = BehaviorFactory.eINSTANCE.createSequence();
                seq.setGlobalDescriptionURI(at.getGlobalDescriptionURI());
                if (NamesUtil.isSet((String)at.getName())) {
                    seq.setName(at.getName());
                } else {
                    seq.setName(NamesUtil.getNameFromDescription((String)at.getDescription()));
                }
                elem.getActivityTypes().remove(i);
                seq.getActivityTypes().add((Object)at);
                elem.getActivityTypes().add(i, (Object)seq);
            }
            ++i;
        }
        this.endScope();
    }

    protected BehaviorDescription getBehaviorDescription(Choreography choreography, Participant participant, BehaviorDescription parent) {
        BehaviorDescription ret = null;
        String behaviorName = this.getBehaviorName(choreography.getName(), participant);
        if (!(choreography.getParent() instanceof Choreography) || participant != null && participant.getFree() != Boolean.TRUE) {
            ret = this.m_serviceDescription.getBehaviorDescription(behaviorName);
            if (ret == null) {
                ret = BehaviorFactory.eINSTANCE.createBehaviorDescription();
                ret.setName(behaviorName);
                if (participant != null) {
                    ret.setParticipant(participant.getName());
                }
                if (choreography.getRoot() == Boolean.TRUE || participant != null && participant.getFree() != Boolean.TRUE) {
                    ret.setRoot(Boolean.TRUE);
                }
                this.m_serviceDescription.getBehaviorDescriptions().add((Object)ret);
            }
        } else {
            ret = parent.getEnclosedBehaviorDescription(behaviorName);
            if (ret == null) {
                ret = BehaviorFactory.eINSTANCE.createBehaviorDescription();
                ret.setName(behaviorName);
                if (participant != null) {
                    ret.setParticipant(participant.getName());
                }
                parent.getEnclosedBehaviorDescriptions().add((Object)ret);
            }
        }
        return ret;
    }

    public void choreographyStart(Choreography choreography) {
        BehaviorDescription elem = this.getBehaviorDescription(choreography, this.m_participant, this.m_parent);
        String behaviorName = this.getBehaviorName(choreography.getName(), this.m_participant);
        if (elem != null && elem.getActivityTypes().size() > 0) {
            logger.severe("Top level behavior '" + behaviorName + "' was not un-initialized");
        }
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)choreography));
        elem.setDescription(choreography.getDescription());
        if (choreography.hasCompletionCondition()) {
            elem.setCompletionExpression(this.convertExpression((CDLType)choreography, choreography.getCompletionCondition(), true));
            elem.setHasCompletionExpression(Boolean.TRUE);
        }
        this.projectVariables(choreography, elem);
        this.setBehaviorDescription(elem);
        this.startScope(elem);
    }

    protected String getBehaviorName(String choreoName, Participant participant) {
        String ret = choreoName;
        if (participant != null) {
            ret = String.valueOf(ret) + "_" + participant.getName();
        }
        return ret;
    }

    protected boolean intersection(List l1, List l2) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < l1.size()) {
            ret = l2.contains(l1.get(i));
            ++i;
        }
        return ret;
    }

    protected void projectVariables(Choreography choreo, BehaviorDescription behavior) {
        for (Variable var : choreo.getVariableDefinitions()) {
            if (var.getRoleTypes().size() != 0 && this.m_participant != null && !this.intersection((List)this.m_participant.getRoleTypes(), (List)var.getRoleTypes())) continue;
            VariableDeclaration decl = null;
            decl = var.getType() instanceof ChannelType ? BehaviorFactory.eINSTANCE.createChannelDeclaration() : BehaviorFactory.eINSTANCE.createVariableDeclaration();
            decl.setName(var.getName());
            decl.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)var));
            decl.setFree(var.getFree());
            decl.setMutable(var.getMutable());
            decl.setSilent(var.getSilent());
            if (var.getType() instanceof ChannelType) {
                String channelType = var.getType().getName();
                if (XMLUtils.getPrefix((String)channelType) == null) {
                    channelType = "sens:" + channelType;
                }
                ((ChannelDeclaration)decl).setChannelType(channelType);
                String serviceTypeName = this.resolveServiceType(var);
                ServiceType serviceType = this.getServiceType(serviceTypeName);
                ((ChannelDeclaration)decl).setServiceType(serviceType);
                ((ChannelDeclaration)decl).setUsage(this.translateUsageType(((ChannelType)var.getType()).getUsage()));
                for (org.pi4soa.cdl.Identity cdlId : ((ChannelType)var.getType()).getIdentities()) {
                    Identity id = BehaviorFactory.eINSTANCE.createIdentity();
                    id.setDescription(cdlId.getDescription());
                    id.setName(cdlId.getName());
                    id.setType(IdentityType.get(cdlId.getType().getValue()));
                    int i = 0;
                    while (i < cdlId.getTokens().size()) {
                        Token token = (Token)cdlId.getTokens().get(i);
                        id.getTokens().add((Object)token.getName());
                        ++i;
                    }
                    ((ChannelDeclaration)decl).getIdentities().add((Object)id);
                }
                if (var.getType() != null && ((ChannelType)var.getType()).getReferenceToken() != null && ((ChannelType)var.getType()).getReferenceToken().getInformationType() != null) {
                    InformationType infoType = this.m_serviceDescription.getInformationType(((ChannelType)var.getType()).getReferenceToken().getInformationType().getName());
                    decl.setInformationType(infoType);
                }
            } else if (var.getType() != null) {
                InformationType infoType = this.m_serviceDescription.getInformationType(var.getType().getName());
                decl.setInformationType(infoType);
            }
            behavior.getVariableDeclarations().add((Object)decl);
        }
    }

    protected UsageType translateUsageType(org.pi4soa.cdl.UsageType type) {
        UsageType ret = null;
        if (type == org.pi4soa.cdl.UsageType.DISTINCT) {
            ret = UsageType.DISTINCT;
        } else if (type == org.pi4soa.cdl.UsageType.ONCE) {
            ret = UsageType.ONCE;
        } else if (type == org.pi4soa.cdl.UsageType.SHARED) {
            ret = UsageType.SHARED;
        }
        return ret;
    }

    public void choreographyEnd(Choreography choreography) {
        BehaviorDescription element;
        BehaviorType btype = this.getCurrentScopeElement();
        this.endScope();
        if (btype instanceof BehaviorDescription && (element = (BehaviorDescription)btype).getActivityTypes().size() == 0) {
            if (element.getParent() instanceof BehaviorDescription) {
                ((BehaviorDescription)element.getParent()).getEnclosedBehaviorDescriptions().remove((Object)element);
            } else if (element.getParent() instanceof ServiceDescription) {
                ((ServiceDescription)element.getParent()).getBehaviorDescriptions().remove((Object)element);
            }
        }
    }

    public void conditionalStart(org.pi4soa.cdl.Conditional conditional) {
        Conditional elem = null;
        elem = BehaviorFactory.eINSTANCE.createConditional();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)conditional));
        elem.setName(conditional.getName());
        elem.setDescription(conditional.getDescription());
        if (this.isSet(conditional.getExpression())) {
            elem.setExpression(this.convertExpression((CDLType)conditional, conditional.getExpression(), true));
        }
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void conditionalEnd(org.pi4soa.cdl.Conditional conditional) {
        this.endScope();
    }

    public void exceptionHandlerStart(org.pi4soa.cdl.ExceptionHandler handler) {
    }

    public void exceptionHandlerEnd(org.pi4soa.cdl.ExceptionHandler handler) {
    }

    public void exceptionWorkUnitStart(ExceptionWorkUnit workunit) {
        ExceptionHandler elem = BehaviorFactory.eINSTANCE.createExceptionHandler();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)workunit));
        elem.setDescription(workunit.getDescription());
        if (this.isSet(workunit.getExceptionType())) {
            elem.setExceptionType(this.convertQName((CDLType)workunit, workunit.getExceptionType()));
        }
        this.m_behaviorDescription.getExceptionHandlers().add((Object)elem);
        this.startScope(elem);
    }

    public void exceptionWorkUnitEnd(ExceptionWorkUnit workunit) {
        ExceptionHandler elem = (ExceptionHandler)this.getCurrentScopeElement();
        if (elem.getActivityTypes().size() == 0) {
            Unobservable unobservable = BehaviorFactory.eINSTANCE.createUnobservable();
            elem.getActivityTypes().add((Object)unobservable);
        }
        this.endScope();
    }

    public void finalizerStart(FinalizerHandler finalizer) {
        CompletionHandler elem = this.m_behaviorDescription.getCompletionHandler(finalizer.getName());
        if (elem == null) {
            elem = BehaviorFactory.eINSTANCE.createCompletionHandler();
            elem.setName(finalizer.getName());
            this.m_behaviorDescription.getCompletionHandlers().add((Object)elem);
        }
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)finalizer));
        elem.setDescription(finalizer.getDescription());
        this.startScope(elem);
    }

    public void finalizerEnd(FinalizerHandler finalizer) {
        this.endScope();
    }

    public void finalize(org.pi4soa.cdl.Finalize finalize) {
        boolean f_generate = false;
        Participant target = null;
        if (finalize.getParticipantBindDetails().size() == 0) {
            if (this.m_participant == null) {
                f_generate = true;
            }
        } else {
            Iterator iter = finalize.getParticipantBindDetails().iterator();
            while (!f_generate && iter.hasNext()) {
                ParticipantBindDetails bind = (ParticipantBindDetails)iter.next();
                if (bind.getThisParticipant() != this.m_participant) continue;
                target = bind.getFreeParticipant();
                if (target != null && this.m_participantType != null) {
                    if (!this.m_participantType.getRoleTypes().containsAll((Collection)target.getRoleTypes())) continue;
                    f_generate = true;
                    continue;
                }
                f_generate = true;
            }
        }
        if (f_generate) {
            Finalize elem = BehaviorFactory.eINSTANCE.createFinalize();
            elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)finalize));
            elem.setDescription(finalize.getDescription());
            BehaviorDescription bd = this.getBehaviorDescription(finalize.getChoreography(), target, this.m_behaviorDescription);
            if (bd != null) {
                String finalizerName = null;
                if (finalize.getFinalizer() != null) {
                    finalizerName = finalize.getFinalizer().getName();
                } else if (finalize.getChoreography().getFinalizers().size() == 1) {
                    FinalizerHandler fh = (FinalizerHandler)finalize.getChoreography().getFinalizers().get(0);
                    finalizerName = fh.getName();
                }
                if (finalizerName != null) {
                    CompletionHandler ch = bd.getCompletionHandler(finalizerName);
                    if (ch == null) {
                        ch = BehaviorFactory.eINSTANCE.createCompletionHandler();
                        ch.setName(finalizerName);
                        bd.getCompletionHandlers().add((Object)ch);
                    }
                    elem.setCompletionHandler(ch);
                }
                if (this.isSet(finalize.getChoreographyInstanceId())) {
                    elem.setInstanceId(this.convertExpression((CDLType)finalize, finalize.getChoreographyInstanceId(), true));
                }
                this.addToScope(elem);
            } else {
                String behaviorName = this.getBehaviorName(finalize.getChoreography().getName(), target);
                logger.fine("Behavior description '" + behaviorName + "' not found, so not projecting finalize");
            }
        }
    }

    public void interaction(Interaction interaction) {
        boolean f_generateClient = false;
        boolean f_generateServer = false;
        if (this.m_participant != null) {
            if (interaction.getToParticipant() == this.m_participant) {
                f_generateServer = true;
            }
            if (interaction.getFromParticipant() == this.m_participant) {
                f_generateClient = true;
            }
        } else if (this.m_participantType != null) {
            if (this.m_participantType.getRoleTypes().contains((Object)interaction.getToRoleType()) && interaction.getToParticipant() == null) {
                f_generateServer = true;
            } else if (this.m_participantType.getRoleTypes().contains((Object)interaction.getFromRoleType()) && interaction.getFromParticipant() == null) {
                f_generateClient = true;
            }
        } else {
            f_generateClient = true;
            f_generateServer = true;
        }
        if (f_generateClient || f_generateServer) {
            ExchangeDetails[] faults;
            ExchangeDetails[] notifications;
            ExchangeDetails[] responds;
            Sequence seq = BehaviorFactory.eINSTANCE.createSequence();
            seq.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)interaction));
            seq.setName(interaction.getName());
            seq.setDescription(interaction.getDescription());
            ExchangeDetails[] reqs = interaction.getRequestExchanges();
            if (reqs != null && reqs.length > 0) {
                this.processExchange(seq, interaction, reqs[0], f_generateClient, f_generateServer);
            }
            if ((responds = interaction.getResponseExchanges()).length + (notifications = interaction.getNotificationExchanges()).length + (faults = interaction.getFaultExchanges()).length > 1) {
                Sequence subseq;
                Choice choice = BehaviorFactory.eINSTANCE.createChoice();
                int i = 0;
                while (i < responds.length) {
                    subseq = BehaviorFactory.eINSTANCE.createSequence();
                    subseq.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)responds[i]));
                    subseq.setName(responds[i].getName());
                    this.processExchange(subseq, interaction, responds[i], f_generateServer, f_generateClient);
                    choice.getActivityTypes().add((Object)subseq);
                    ++i;
                }
                i = 0;
                while (i < notifications.length) {
                    subseq = BehaviorFactory.eINSTANCE.createSequence();
                    subseq.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)notifications[i]));
                    subseq.setName(notifications[i].getName());
                    this.processExchange(subseq, interaction, notifications[i], f_generateServer, f_generateClient);
                    choice.getActivityTypes().add((Object)subseq);
                    ++i;
                }
                i = 0;
                while (i < faults.length) {
                    subseq = BehaviorFactory.eINSTANCE.createSequence();
                    subseq.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)faults[i]));
                    subseq.setName(faults[i].getName());
                    this.processExchange(subseq, interaction, faults[i], f_generateServer, f_generateClient);
                    choice.getActivityTypes().add((Object)subseq);
                    ++i;
                }
                seq.getActivityTypes().add((Object)choice);
            } else if (responds.length == 1) {
                this.processExchange(seq, interaction, responds[0], f_generateServer, f_generateClient);
            } else if (notifications.length == 1) {
                this.processExchange(seq, interaction, notifications[0], f_generateServer, f_generateClient);
            } else if (faults.length == 1) {
                this.processExchange(seq, interaction, faults[0], f_generateServer, f_generateClient);
            }
            boolean timeout = this.processTimeout(interaction);
            if (seq.getActivityTypes().size() == 1) {
                this.addToScope((BehaviorType)seq.getActivityTypes().get(0));
            } else if (this.getCurrentScopeElement() instanceof StructuralType && ((StructuralType)this.getCurrentScopeElement()).isSequentialGroupingConstruct()) {
                StructuralType scope = (StructuralType)this.getCurrentScopeElement();
                scope.getActivityTypes().addAll(seq.getActivityTypes());
            } else {
                this.addToScope(seq);
            }
            if (timeout) {
                this.endScope();
            }
        }
    }

    protected void processExchange(Sequence seq, Interaction interaction, ExchangeDetails details, boolean generateSend, boolean generateReceive) {
        RaiseException raise;
        VariableDeclaration channel;
        VariableDeclaration var;
        BehaviorDescription bd = null;
        String serviceTypeName = this.resolveServiceType(interaction.getChannelVariable());
        MessageDefinition mdef = this.getMessageDefinition(interaction, details, serviceTypeName);
        if (this.getCurrentScopeElement() instanceof ActivityType) {
            bd = ((ActivityType)this.getCurrentScopeElement()).getEnclosingBehaviorDescription();
        }
        if (bd == null) {
            logger.severe("Unable to project exchange as no behavioraldescription available");
        }
        if (generateSend && InteractionUtil.isSendExchange((ExchangeDetails)details)) {
            ChannelType ctype;
            PassingChannelDetails pcd;
            this.addRecordDetails((List<ActivityType>)seq.getActivityTypes(), interaction, (List<RecordDetails>)details.getSendRecordDetails(), WhenType.BEFORE);
            Send send = BehaviorFactory.eINSTANCE.createSend();
            send.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)details));
            send.setName(details.getName());
            send.setMessageDefinition(mdef);
            if (details.getSendVariable() != null && details.getSendVariable().getName() != null) {
                var = bd.getVariable(details.getSendVariable().getName());
                if (var == null) {
                    logger.severe("Failed to find variable '" + details.getSendVariable().getName() + "' associated with behavior description '" + bd.getFullyQualifiedName() + "'");
                }
                send.setVariable(var);
                if (this.isSet(details.getSendVariablePart())) {
                    send.setVariablePart(details.getSendVariablePart());
                }
            }
            if ((channel = bd.getVariable(interaction.getChannelVariable().getName())) == null) {
                logger.severe("Failed to find channel '" + interaction.getChannelVariable().getName() + "' associated with behavior description '" + bd.getFullyQualifiedName() + "'");
            } else if (!(channel instanceof ChannelDeclaration)) {
                logger.severe("Variable '" + interaction.getChannelVariable().getName() + "', associated with behavior description '" + bd.getFullyQualifiedName() + "', was not a channel instance");
            } else {
                send.setChannel((ChannelDeclaration)channel);
            }
            if (details.getType() instanceof ChannelType && (pcd = (ctype = (ChannelType)interaction.getChannelVariable().getType()).getPassingChannelDetails((ChannelType)details.getType())) != null) {
                send.setNewPassedChannel(pcd.getNew());
            }
            seq.getActivityTypes().add((Object)send);
            if (this.isSet(details.getSendCauseException())) {
                raise = BehaviorFactory.eINSTANCE.createRaiseException();
                raise.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)details));
                raise.setExceptionType(this.convertQName((CDLType)details, details.getSendCauseException()));
                seq.getActivityTypes().add((Object)raise);
            }
            this.addRecordDetails((List<ActivityType>)seq.getActivityTypes(), interaction, (List<RecordDetails>)details.getSendRecordDetails(), WhenType.AFTER);
        }
        if (generateReceive && InteractionUtil.isReceiveExchange((ExchangeDetails)details)) {
            this.addRecordDetails((List<ActivityType>)seq.getActivityTypes(), interaction, (List<RecordDetails>)details.getReceiveRecordDetails(), WhenType.BEFORE);
            Receive recv = BehaviorFactory.eINSTANCE.createReceive();
            recv.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)details));
            recv.setName(details.getName());
            recv.setMessageDefinition(mdef);
            if (details.getReceiveVariable() != null && details.getReceiveVariable().getName() != null) {
                var = bd.getVariable(details.getReceiveVariable().getName());
                if (var == null) {
                    logger.severe("Failed to find variable '" + details.getReceiveVariable().getName() + "' associated with behavior description '" + bd.getFullyQualifiedName() + "'");
                }
                recv.setVariable(var);
                if (this.isSet(details.getReceiveVariablePart())) {
                    recv.setVariablePart(details.getReceiveVariablePart());
                }
            }
            if ((channel = bd.getVariable(interaction.getChannelVariable().getName())) == null) {
                logger.severe("Failed to find channel '" + interaction.getChannelVariable().getName() + "' associated with behavior description '" + bd.getFullyQualifiedName() + "'");
            } else if (!(channel instanceof ChannelDeclaration)) {
                logger.severe("Variable '" + interaction.getChannelVariable().getName() + "', associated with behavior description '" + bd.getFullyQualifiedName() + "', was not a channel instance");
            } else {
                recv.setChannel((ChannelDeclaration)channel);
            }
            seq.getActivityTypes().add((Object)recv);
            if (this.isSet(details.getReceiveCauseException())) {
                raise = BehaviorFactory.eINSTANCE.createRaiseException();
                raise.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)details));
                raise.setExceptionType(this.convertQName((CDLType)details, details.getReceiveCauseException()));
                seq.getActivityTypes().add((Object)raise);
            }
            this.addRecordDetails((List<ActivityType>)seq.getActivityTypes(), interaction, (List<RecordDetails>)details.getReceiveRecordDetails(), WhenType.AFTER);
        }
    }

    protected String convertQName(CDLType cdlType, String qname) {
        String ret = qname;
        if (XMLUtils.getPrefix((String)qname) == null) {
            ret = "sens:" + qname;
        }
        return ret;
    }

    protected ServiceType getServiceType(String serviceTypeName) {
        ServiceType ret = null;
        if (serviceTypeName != null && (ret = this.m_serviceDescription.getServiceType(serviceTypeName)) == null) {
            ret = BehaviorFactory.eINSTANCE.createServiceType();
            String namespace = NameSpaceUtil.getNamespace((String)serviceTypeName);
            String localpart = NameSpaceUtil.getLocalPart((String)serviceTypeName);
            String prefix = BehaviorTypeUtil.getPrefixResolver(this.m_serviceDescription).getPrefix(namespace);
            ret.setName(String.valueOf(prefix) + ":" + localpart);
            this.m_serviceDescription.getServiceTypes().add((Object)ret);
        }
        return ret;
    }

    protected MessageDefinition getMessageDefinition(Interaction interaction, ExchangeDetails details, String serviceTypeName) {
        MessageDefinition ret = null;
        ServiceType serviceType = null;
        OperationDefinition operation = null;
        if (serviceTypeName != null) {
            InformationType infoType;
            org.pi4soa.cdl.InformationType cdlInfoType;
            ExchangeDetails reqDetails = null;
            String defType = null;
            List ops = null;
            serviceType = this.getServiceType(serviceTypeName);
            if (details.getAction() != ExchangeActionType.NOTIFY) {
                List reqDetailList = InteractionUtil.getRequestExchangeDetails((ExchangeDetails)details);
                if (reqDetailList.size() > 0) {
                    reqDetails = (ExchangeDetails)reqDetailList.get(0);
                }
                if (reqDetails != null) {
                    defType = CDLTypeUtil.getRealInformationType((DataType)reqDetails.getType());
                    if (defType == null) {
                        defType = CDLTypeUtil.getRealInformationElement((DataType)reqDetails.getType());
                    }
                    if (defType != null) {
                        String namespace = CDLTypeUtil.getNamespace((String)defType, (CDLType)details);
                        String localpart = XMLUtils.getLocalname((String)defType);
                        defType = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
                    }
                }
                ops = serviceType.getOperationDefinitions(interaction.getOperation(), defType, null);
            } else {
                defType = CDLTypeUtil.getRealInformationType((DataType)details.getType());
                if (defType == null) {
                    defType = CDLTypeUtil.getRealInformationElement((DataType)details.getType());
                }
                if (defType != null) {
                    String namespace = CDLTypeUtil.getNamespace((String)defType, (CDLType)details);
                    String localpart = XMLUtils.getLocalname((String)defType);
                    defType = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
                }
                ops = serviceType.getNotificationDefinitions(interaction.getOperation(), defType);
            }
            if (ops.size() == 1) {
                operation = (OperationDefinition)ops.get(0);
            } else if (ops.size() > 1) {
                logger.severe("Found more than one operation definition for '" + interaction.getOperation() + "' and request type '" + defType + "': " + ops.size());
            }
            if (operation == null) {
                operation = BehaviorFactory.eINSTANCE.createOperationDefinition();
                operation.setName(interaction.getOperation());
                serviceType.getOperationDefinitions().add((Object)operation);
                if (reqDetails != null) {
                    org.pi4soa.cdl.InformationType cdlInfoType2;
                    MessageDefinition req = BehaviorFactory.eINSTANCE.createMessageDefinition();
                    operation.getMessageDefinitions().add((Object)req);
                    req.setClassification(MessageClassification.REQUEST);
                    if (reqDetails.getType() != null && (cdlInfoType2 = CDLTypeUtil.getInformationType((DataType)reqDetails.getType())) != null) {
                        InformationType infoType2 = this.m_serviceDescription.getInformationType(cdlInfoType2.getName());
                        req.setInformationType(infoType2);
                    }
                }
            }
            if (details.getAction().equals((Object)ExchangeActionType.REQUEST)) {
                ret = operation.getRequest();
                if (ret == null) {
                    ret = BehaviorFactory.eINSTANCE.createMessageDefinition();
                    operation.getMessageDefinitions().add((Object)ret);
                    ret.setClassification(MessageClassification.REQUEST);
                    if (details.getType() != null && (cdlInfoType = CDLTypeUtil.getInformationType((DataType)details.getType())) != null) {
                        infoType = this.m_serviceDescription.getInformationType(cdlInfoType.getName());
                        ret.setInformationType(infoType);
                    }
                }
            } else if (details.getAction().equals((Object)ExchangeActionType.RESPOND)) {
                if (details.getFaultName() != null && details.getFaultName().trim().length() > 0) {
                    String originalFaultName = details.getFaultName();
                    String faultName = null;
                    faultName = this.convertQName((CDLType)details, originalFaultName);
                    ret = operation.getFault(faultName);
                    if (ret == null) {
                        org.pi4soa.cdl.InformationType cdlInfoType3;
                        ret = BehaviorFactory.eINSTANCE.createMessageDefinition();
                        ret.setFaultName(faultName);
                        ret.setClassification(MessageClassification.RESPONSE);
                        if (details.getType() != null && (cdlInfoType3 = CDLTypeUtil.getInformationType((DataType)details.getType())) != null) {
                            InformationType infoType3 = this.m_serviceDescription.getInformationType(cdlInfoType3.getName());
                            ret.setInformationType(infoType3);
                        }
                        operation.getMessageDefinitions().add((Object)ret);
                    }
                } else {
                    ret = operation.getResponse();
                    if (ret == null) {
                        ret = BehaviorFactory.eINSTANCE.createMessageDefinition();
                        ret.setClassification(MessageClassification.RESPONSE);
                        if (details.getType() != null && (cdlInfoType = CDLTypeUtil.getInformationType((DataType)details.getType())) != null) {
                            infoType = this.m_serviceDescription.getInformationType(cdlInfoType.getName());
                            ret.setInformationType(infoType);
                        }
                        operation.getMessageDefinitions().add((Object)ret);
                    }
                }
            } else if (details.getAction().equals((Object)ExchangeActionType.NOTIFY) && (ret = operation.getNotification()) == null) {
                ret = BehaviorFactory.eINSTANCE.createMessageDefinition();
                ret.setClassification(MessageClassification.NOTIFICATION);
                if (details.getType() != null && (cdlInfoType = CDLTypeUtil.getInformationType((DataType)details.getType())) != null) {
                    infoType = this.m_serviceDescription.getInformationType(cdlInfoType.getName());
                    ret.setInformationType(infoType);
                }
                operation.getMessageDefinitions().add((Object)ret);
            }
        }
        return ret;
    }

    protected String resolveServiceType(Variable var) {
        String ret = null;
        if (this.m_resolver != null) {
            ret = this.m_resolver.resolve(var);
        }
        return ret;
    }

    protected void addRecordDetails(List<ActivityType> seq, Interaction interaction, List<RecordDetails> recordDetails, WhenType when) {
        BehaviorDescription bd = null;
        if (this.getCurrentScopeElement() instanceof ActivityType) {
            bd = ((ActivityType)this.getCurrentScopeElement()).getEnclosingBehaviorDescription();
        }
        if (bd == null) {
            logger.severe("Unable to project assign as no behavioraldescription available");
        }
        int i = 0;
        while (i < recordDetails.size()) {
            RecordDetails details = recordDetails.get(i);
            if (details.getWhen() == when) {
                Assign assign = BehaviorFactory.eINSTANCE.createAssign();
                if (this.isSet(details.getSourceExpression())) {
                    assign.setExpression(this.convertExpression((CDLType)details, details.getSourceExpression(), true));
                } else if (details.getSourceVariable() != null) {
                    assign.setExpression(this.convertGetVariable(details.getSourceVariable(), details.getSourceVariablePart()));
                }
                if (details.getTargetVariable() != null) {
                    VariableDeclaration vard = bd.getVariable(details.getTargetVariable().getName());
                    assign.setVariable(vard);
                    if (this.isSet(details.getTargetVariablePart())) {
                        assign.setPartName(details.getTargetVariablePart());
                    }
                }
                seq.add(assign);
                if (this.isSet(details.getCauseException())) {
                    RaiseException raise = BehaviorFactory.eINSTANCE.createRaiseException();
                    raise.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)details));
                    raise.setExceptionType(this.convertQName((CDLType)details, details.getCauseException()));
                    seq.add(raise);
                }
            }
            ++i;
        }
    }

    protected boolean processTimeout(Interaction interaction) {
        boolean ret = false;
        if (NamesUtil.isSet((String)interaction.getTimeToComplete())) {
            TimedUnit tu = BehaviorFactory.eINSTANCE.createTimedUnit();
            tu.setGlobalDescriptionURI(interaction.getName());
            String time = interaction.getTimeToComplete();
            if (!time.startsWith("'") && !time.startsWith("\"")) {
                time = "'" + time + "'";
            }
            String expr = "sdl:hasTimerExpired(" + time + ")";
            tu.setTimeToComplete(expr);
            if (interaction.getTimeoutFromRoleTypeRecordDetails() != null) {
                this.addRecordDetails((List<ActivityType>)tu.getTimeoutActivityTypes(), interaction, (List<RecordDetails>)interaction.getTimeoutFromRoleTypeRecordDetails(), WhenType.TIMEOUT);
            }
            if (interaction.getTimeoutToRoleTypeRecordDetails() != null) {
                this.addRecordDetails((List<ActivityType>)tu.getTimeoutActivityTypes(), interaction, (List<RecordDetails>)interaction.getTimeoutToRoleTypeRecordDetails(), WhenType.TIMEOUT);
            }
            this.addToScope(tu);
            this.startScope(tu);
            ret = true;
        }
        return ret;
    }

    public void noAction(NoAction noAction) {
        if (noAction.getParticipant() == this.m_participant) {
            Unobservable elem = BehaviorFactory.eINSTANCE.createUnobservable();
            elem.setSilentAction(Boolean.FALSE);
            String uri = CDLTypeUtil.getURIFragment((CDLType)noAction);
            if ((uri == null || uri.length() == 2) && noAction.getParent() != null) {
                uri = CDLTypeUtil.getURIFragment((CDLType)noAction.getParent());
            }
            elem.setGlobalDescriptionURI(uri);
            String name = NamesUtil.getNameFromDescription((String)noAction.getDescription());
            elem.setName(name);
            elem.setDescription(noAction.getDescription());
            this.addToScope(elem);
        }
    }

    public void packageStart(Package pack) {
    }

    public void packageEnd(Package pack) {
    }

    public void parallelStart(org.pi4soa.cdl.Parallel parallel) {
        Parallel elem = BehaviorFactory.eINSTANCE.createParallel();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)parallel));
        elem.setName(NamesUtil.getNameFromDescription((String)parallel.getDescription()));
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void parallelEnd(org.pi4soa.cdl.Parallel parallel) {
        this.endScope();
    }

    public void perform(org.pi4soa.cdl.Perform perform) {
        boolean f_generate = false;
        Participant target = null;
        if (perform.getParticipantBindDetails().size() == 0) {
            if (this.m_participant == null) {
                f_generate = true;
            }
        } else {
            Iterator iter = perform.getParticipantBindDetails().iterator();
            while (!f_generate && iter.hasNext()) {
                ParticipantBindDetails bind = (ParticipantBindDetails)iter.next();
                if (bind.getThisParticipant() != this.m_participant) continue;
                target = bind.getFreeParticipant();
                if (target != null && this.m_participantType != null) {
                    if (!this.m_participantType.getRoleTypes().containsAll((Collection)target.getRoleTypes())) continue;
                    f_generate = true;
                    continue;
                }
                f_generate = true;
            }
        }
        if (f_generate) {
            Perform elem = BehaviorFactory.eINSTANCE.createPerform();
            elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)perform));
            elem.setWaitForCompletion(perform.getWaitForCompletion());
            elem.setDescription(perform.getDescription());
            BehaviorDescription bd = this.getBehaviorDescription(perform.getChoreography(), target, this.m_behaviorDescription);
            if (bd != null) {
                this.addToScope(elem);
                this.initializePerform(elem, bd, perform);
            } else {
                String behaviorName = this.getBehaviorName(perform.getChoreography().getName(), target);
                logger.fine("Behavior description '" + behaviorName + "' not found, so not projecting perform");
            }
        }
    }

    protected void initializePerform(Perform elem, BehaviorDescription bd, org.pi4soa.cdl.Perform perform) {
        Choreography choreo = perform.getChoreography();
        elem.setBehaviorDescription(bd);
        elem.setIsolated(choreo.getIsolation());
        if (this.isSet(perform.getChoreographyInstanceId())) {
            elem.setInstanceId(this.convertExpression((CDLType)perform, perform.getChoreographyInstanceId(), true));
        }
        EList rtypes = null;
        if (this.m_participant != null) {
            rtypes = this.m_participant.getRoleTypes();
        } else if (this.m_participantType != null) {
            rtypes = this.m_participantType.getRoleTypes();
        }
        int i = 0;
        while (i < perform.getBindDetails().size()) {
            BindDetails details = (BindDetails)perform.getBindDetails().get(i);
            if (rtypes == null || rtypes.contains(details.getThisRole())) {
                VariableBinding binding = BehaviorFactory.eINSTANCE.createVariableBinding();
                VariableDeclaration parentvar = elem.getEnclosingBehaviorDescription().getVariable(details.getThisVariable().getName());
                VariableDeclaration boundvar = bd.getVariable(details.getFreeVariable().getName());
                binding.setParentVariable(parentvar);
                binding.setBoundVariable(boundvar);
                if (NamesUtil.isSet((String)details.getFreeVariable().getName())) {
                    binding.setBoundVariableName(details.getFreeVariable().getName());
                }
                elem.getVariableBindings().add((Object)binding);
            }
            ++i;
        }
    }

    protected void initializeFinalize(Finalize elem, CompletionHandler ch) {
        elem.setCompletionHandler(ch);
    }

    public void sequenceStart(org.pi4soa.cdl.Sequence sequence) {
        Sequence elem = BehaviorFactory.eINSTANCE.createSequence();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)sequence));
        elem.setName(NamesUtil.getNameFromDescription((String)sequence.getDescription()));
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void sequenceEnd(org.pi4soa.cdl.Sequence sequence) {
        this.endScope();
    }

    public void silentAction(SilentAction silentAction) {
        if (silentAction.getParticipant() == this.m_participant) {
            Unobservable elem = BehaviorFactory.eINSTANCE.createUnobservable();
            elem.setSilentAction(Boolean.TRUE);
            elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)silentAction));
            elem.setName(silentAction.getName());
            elem.setDescription(silentAction.getDescription());
            this.addToScope(elem);
        }
    }

    public void whenStart(org.pi4soa.cdl.When when) {
        When elem = BehaviorFactory.eINSTANCE.createWhen();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)when));
        elem.setName(when.getName());
        elem.setDescription(when.getDescription());
        if (this.isSet(when.getExpression())) {
            elem.setExpression(this.convertExpression((CDLType)when, when.getExpression(), true));
        }
        if (this.isSet(when.getReEvaluateCondition())) {
            elem.setReEvaluateExpression(this.convertExpression((CDLType)when, when.getReEvaluateCondition(), true));
        }
        elem.setReEvaluate(when.getReEvaluate());
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void whenEnd(org.pi4soa.cdl.When when) {
        this.endScope();
    }

    public void whileStart(org.pi4soa.cdl.While whileElem) {
        While elem = BehaviorFactory.eINSTANCE.createWhile();
        elem.setGlobalDescriptionURI(CDLTypeUtil.getURIFragment((CDLType)whileElem));
        elem.setName(whileElem.getName());
        elem.setDescription(whileElem.getDescription());
        if (this.isSet(whileElem.getExpression())) {
            elem.setExpression(this.convertExpression((CDLType)whileElem, whileElem.getExpression(), true));
        }
        if (this.isSet(whileElem.getReEvaluateCondition())) {
            elem.setReEvaluateExpression(this.convertExpression((CDLType)whileElem, whileElem.getReEvaluateCondition(), true));
        }
        this.addToScope(elem);
        this.startScope(elem);
    }

    public void whileEnd(org.pi4soa.cdl.While whileElem) {
        this.endScope();
    }

    protected boolean isSet(String value) {
        boolean ret = false;
        if (value != null && value.trim().length() > 0) {
            ret = true;
        }
        return ret;
    }

    protected void addToScope(BehaviorType element) {
        if (this.m_currentBehaviorType instanceof StructuralType && element instanceof ActivityType) {
            StructuralType struct = (StructuralType)this.m_currentBehaviorType;
            struct.getActivityTypes().add((Object)((ActivityType)element));
        }
    }

    protected void removeFromScope(BehaviorType element) {
        if (this.m_currentBehaviorType instanceof StructuralType && element instanceof ActivityType) {
            StructuralType struct = (StructuralType)this.m_currentBehaviorType;
            struct.getActivityTypes().remove((Object)element);
        }
    }

    public void startScope(BehaviorType element) {
        this.m_currentBehaviorType = element;
    }

    public BehaviorType getCurrentScopeElement() {
        return this.m_currentBehaviorType;
    }

    public void endScope() {
        if (this.m_currentBehaviorType != null) {
            this.startScope(this.m_currentBehaviorType.getParent());
        } else {
            this.startScope(null);
        }
    }

    protected String convertGetVariable(Variable variable, String part) {
        String expr = "cdl:getVariable('" + variable.getName() + "','";
        if (part != null && part.trim().length() > 0) {
            expr = String.valueOf(expr) + part;
        }
        expr = String.valueOf(expr) + "','')";
        return this.convertExpression((CDLType)variable, expr, true);
    }

    protected String convertExpression(CDLType cdlType, String cdlExpression, boolean allowSingletonParticipant) {
        String ret = null;
        if (NamesUtil.isSet((String)cdlExpression)) {
            ret = cdlExpression;
            if (this.m_participantType != null) {
                if (cdlType instanceof CDLTypeProxy) {
                    cdlType = ((CDLTypeProxy)cdlType).getCDLType();
                }
                if (!NamesUtil.isSet((String)(ret = XPathProjection.projectExpression((CDLType)cdlType, (String)cdlExpression, (RoleType[])this.m_participantType.getRoleTypesForContext(), (Participant)this.m_participant))) && allowSingletonParticipant) {
                    RoleType[] rtypes = this.m_participantType.getRoleTypesForContext();
                    if (this.m_participant != null) {
                        rtypes = this.m_participant.getRoleTypesForContext();
                    }
                    ret = XPathProjection.projectExpression((CDLType)cdlType, (String)cdlExpression, (RoleType[])rtypes, null);
                }
            }
            if (NamesUtil.isSet((String)ret)) {
                ret = cdlExpression.replaceAll("cdl:", "sdl:");
            }
        }
        return ret;
    }
}

